/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.clickhouse.ast.ClickhouseCreateTableStatement;
import com.alibaba.druid.sql.dialect.clickhouse.visitor.ClickhouseVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class ClickhouseOutputVisitor
extends SQLASTOutputVisitor
implements ClickhouseVisitor {
    public ClickhouseOutputVisitor(Appendable appender) {
        super(appender, DbType.clickhouse);
    }

    public ClickhouseOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public ClickhouseOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        if (x.getExpr() != null) {
            x.getExpr().accept(this);
        } else if (x.getSubQuery() != null) {
            this.print('(');
            this.println();
            SQLSelect query2 = x.getSubQuery();
            if (query2 != null) {
                query2.accept(this);
            } else {
                x.getReturningStatement().accept(this);
            }
            this.println();
            this.print(')');
        }
        this.print(' ');
        this.print0(this.ucase ? "AS " : "as ");
        this.print0(x.getAlias());
        return false;
    }

    @Override
    public boolean visit(SQLStructDataType x) {
        this.print0(this.ucase ? "NESTED (" : "nested (");
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getFields(), ",");
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLStructDataType.Field x) {
        SQLDataType dataType;
        SQLName name = x.getName();
        if (name != null) {
            name.accept(this);
        }
        if ((dataType = x.getDataType()) != null) {
            this.print(' ');
            dataType.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ClickhouseCreateTableStatement x) {
        List<SQLAssignItem> settings;
        SQLExpr sampleBy;
        SQLOrderBy orderBy;
        super.visit(x);
        SQLExpr partitionBy = x.getPartitionBy();
        if (partitionBy != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            partitionBy.accept(this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.println();
            orderBy.accept(this);
        }
        if ((sampleBy = x.getSampleBy()) != null) {
            this.println();
            this.print0(this.ucase ? "SAMPLE BY " : "sample by ");
            sampleBy.accept(this);
        }
        if (!(settings = x.getSettings()).isEmpty()) {
            this.println();
            this.print0(this.ucase ? "SETTINGS " : "settings ");
            this.printAndAccept(settings, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD COLUMN " : "add column ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }
}

