/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.console;

import java.util.List;

public class TableFormatter {
    public static String format(List<String[]> rows) {
        String[] titleRow = rows.get(0);
        int[] maxLens = new int[titleRow.length];
        for (String[] row : rows) {
            for (int j = 0; j < row.length; ++j) {
                int len = TableFormatter.displayLen(row[j]);
                if (len <= maxLens[j]) continue;
                maxLens[j] = len;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TableFormatter.makeSplitLine(maxLens));
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            String[] row = rows.get(i2);
            sb.append("|");
            for (int j = 0; j < row.length; ++j) {
                sb.append(TableFormatter.padStr(row[j], maxLens[j]));
                sb.append(" |");
            }
            sb.append("\n");
            if (i2 != 0) continue;
            sb.append(TableFormatter.makeSplitLine(maxLens));
        }
        sb.append(TableFormatter.makeSplitLine(maxLens));
        return sb.toString();
    }

    public static String makeSplitLine(int[] maxLens) {
        StringBuilder sb = new StringBuilder("+");
        for (int len : maxLens) {
            for (int i2 = 0; i2 < len; ++i2) {
                sb.append("-");
            }
            sb.append("-+");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static int displayLen(String value) {
        return value.length();
    }

    public static String padStr(String old, int length) {
        if (old == null) {
            return "";
        }
        int vLen = TableFormatter.displayLen(old);
        if (vLen > length) {
            return old;
        }
        StringBuilder sb = new StringBuilder(old);
        for (int i2 = 0; i2 < length - vLen; ++i2) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

