/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole;

import com.alibaba.druid.support.jconsole.DruidPanel;
import com.alibaba.druid.support.jconsole.DruidSqlDetailFrame;
import com.alibaba.druid.support.jconsole.model.ColumnGroup;
import com.alibaba.druid.support.jconsole.model.DruidTableModel;
import com.alibaba.druid.support.jconsole.model.GroupableTableHeader;
import com.alibaba.druid.support.jconsole.model.GroupableTableHeaderUI;
import com.alibaba.druid.support.jconsole.model.RowHeaderTable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class DruidSQLPanel
extends DruidPanel {
    private static final long serialVersionUID = 1L;
    private static final String REQUEST_URL = "/sql.json";
    private static final ArrayList<String> SHOW_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("SQL");
            this.add("ExecuteCount");
            this.add("TotalTime");
            this.add("InTransactionCount");
            this.add("ErrorCount");
            this.add("EffectedRowCount");
            this.add("FetchRowCount");
            this.add("RunningCount");
            this.add("ConcurrentMax");
            this.add(DruidSQLPanel.HISTOGRAM);
            this.add(DruidSQLPanel.Effected_RowCount_HISOGRAM);
            this.add(DruidSQLPanel.ExecuteAndResult_Hold_HISOGRAM);
            this.add(DruidSQLPanel.FetchRowCount_HISOGRAM);
        }
    };
    private static final ArrayList<String> REAL_SHOW_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("SQL");
            this.add("ExecuteCount");
            this.add("TotalTime");
            this.add("InTransactionCount");
            this.add("ErrorCount");
            this.add("EffectedRowCount");
            this.add("FetchRowCount");
            this.add("RunningCount");
            this.add("ConcurrentMax");
            this.add(DruidSQLPanel.HISTOGRAM);
            this.add(DruidSQLPanel.Effected_RowCount_HISOGRAM);
            this.add(DruidSQLPanel.ExecuteAndResult_Hold_HISOGRAM);
            this.add(DruidSQLPanel.FetchRowCount_HISOGRAM);
        }
    };
    private static final String HISTOGRAM = "Histogram";
    private static final String Effected_RowCount_HISOGRAM = "EffectedRowCountHistogram";
    private static final String ExecuteAndResult_Hold_HISOGRAM = "ExecuteAndResultHoldTimeHistogram";
    private static final String FetchRowCount_HISOGRAM = "FetchRowCountHistogram";
    private static final ArrayList<String> ARRAY_DATA_MAP = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(DruidSQLPanel.HISTOGRAM);
            this.add(DruidSQLPanel.Effected_RowCount_HISOGRAM);
            this.add(DruidSQLPanel.ExecuteAndResult_Hold_HISOGRAM);
            this.add(DruidSQLPanel.FetchRowCount_HISOGRAM);
        }
    };
    private static final int FIST_LIST_OFFSET = 9;
    private ColumnGroup groupHistogram;
    private ColumnGroup groupEffectedRowCountHistogram;
    private ColumnGroup groupExecuteAndResultHoldTimeHistogram;
    private ColumnGroup groupFetchRowCountHistogram;
    private ArrayList<Integer> listHistogram;
    private ArrayList<Integer> listEffectedRowCountHistogram;
    private ArrayList<Integer> listExecuteAndResultHoldTimeHistogram;
    private ArrayList<Integer> listFetchRowCountHistogram;
    private ArrayList<String> ids;
    private static final String JSON_ID_NAME = "ID";

    public DruidSQLPanel() {
        this.url = REQUEST_URL;
    }

    private void addGroupData(String keyNow, int index) {
        if (HISTOGRAM.equals(keyNow)) {
            this.listHistogram.add(index);
        } else if (Effected_RowCount_HISOGRAM.equals(keyNow)) {
            this.listEffectedRowCountHistogram.add(index);
        } else if (ExecuteAndResult_Hold_HISOGRAM.equals(keyNow)) {
            this.listExecuteAndResultHoldTimeHistogram.add(index);
        } else if (FetchRowCount_HISOGRAM.equals(keyNow)) {
            this.listFetchRowCountHistogram.add(index);
        }
    }

    private ArrayList<LinkedHashMap<String, Object>> preProcess(ArrayList<LinkedHashMap<String, Object>> data) {
        this.groupHistogram = new ColumnGroup(HISTOGRAM);
        this.groupEffectedRowCountHistogram = new ColumnGroup(Effected_RowCount_HISOGRAM);
        this.groupExecuteAndResultHoldTimeHistogram = new ColumnGroup(ExecuteAndResult_Hold_HISOGRAM);
        this.groupFetchRowCountHistogram = new ColumnGroup(FetchRowCount_HISOGRAM);
        this.listHistogram = new ArrayList();
        this.listEffectedRowCountHistogram = new ArrayList();
        this.listExecuteAndResultHoldTimeHistogram = new ArrayList();
        this.listFetchRowCountHistogram = new ArrayList();
        this.ids = new ArrayList();
        ArrayList<LinkedHashMap<String, Object>> newData = new ArrayList<LinkedHashMap<String, Object>>();
        int dataIndex = 0;
        for (LinkedHashMap<String, Object> dataNow : data) {
            Iterator<Map.Entry<String, Object>> it = dataNow.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                if (JSON_ID_NAME.equals(key)) {
                    this.ids.add(value != null ? value.toString() : null);
                }
                if (SHOW_LIST.contains(key)) continue;
                it.remove();
            }
            int offset = 9;
            for (String arrayKey : ARRAY_DATA_MAP) {
                Object arrayData = dataNow.get(arrayKey);
                if (!(arrayData instanceof ArrayList)) continue;
                dataNow.remove(arrayKey);
                if (dataIndex == 0) {
                    REAL_SHOW_LIST.remove(arrayKey);
                }
                ArrayList arrayDataList = (ArrayList)arrayData;
                int len = arrayDataList.size();
                for (int j = 0; j < len; ++j) {
                    int a = j - 1 >= 0 ? (int)Math.pow(10.0, j - 1) : 0;
                    int b = (int)Math.pow(10.0, j);
                    String newKey = arrayKey + "-" + a + "~" + b + "ms";
                    dataNow.put(newKey, arrayDataList.get(j));
                    if (dataIndex != 0) continue;
                    REAL_SHOW_LIST.add(newKey);
                    int index = offset + j;
                    this.addGroupData(arrayKey, index);
                    if (j != len - 1) continue;
                    offset = index + 1;
                }
            }
            ++dataIndex;
            newData.add(dataNow);
        }
        return newData;
    }

    private void addTableGroup() {
        TableColumnModel cm = this.table.getColumnModel();
        for (int i2 : this.listHistogram) {
            this.groupHistogram.add(cm.getColumn(i2));
        }
        for (int j : this.listEffectedRowCountHistogram) {
            this.groupEffectedRowCountHistogram.add(cm.getColumn(j));
        }
        for (int x : this.listExecuteAndResultHoldTimeHistogram) {
            this.groupExecuteAndResultHoldTimeHistogram.add(cm.getColumn(x));
        }
        for (int y : this.listFetchRowCountHistogram) {
            this.groupFetchRowCountHistogram.add(cm.getColumn(y));
        }
        GroupableTableHeader header = (GroupableTableHeader)this.table.getTableHeader();
        header.addColumnGroup(this.groupHistogram);
        header.addColumnGroup(this.groupEffectedRowCountHistogram);
        header.addColumnGroup(this.groupExecuteAndResultHoldTimeHistogram);
        header.addColumnGroup(this.groupFetchRowCountHistogram);
        header.setUI(new GroupableTableHeaderUI());
    }

    @Override
    protected void tableDataProcess(ArrayList<LinkedHashMap<String, Object>> data) {
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new GroupableTableHeader(this.columnModel);
            }
        };
        data = this.preProcess(data);
        this.tableModel = new DruidTableModel(data, REAL_SHOW_LIST);
        this.table.setModel(this.tableModel);
        this.table.setAutoResizeMode(0);
        this.addTableGroup();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = DruidSQLPanel.this.table.getSelectedRow();
                    String id = (String)DruidSQLPanel.this.ids.get(row);
                    new DruidSqlDetailFrame(id, DruidSQLPanel.this.conn);
                }
            }
        });
        RowHeaderTable header = new RowHeaderTable(this.table, 20);
        this.scrollPane.setRowHeaderView(header);
        this.scrollPane.setViewportView(this.table);
        JLabel jb = new JLabel("N", 0);
        jb.setBorder(new BevelBorder(0, null, null, null, null));
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", jb);
    }
}

