/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.spring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FastJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object>
implements GenericHttpMessageConverter<Object> {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public FastJsonHttpMessageConverter() {
        super(MediaType.ALL);
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return super.canRead(contextClass, mediaType);
    }

    @Override
    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return super.canWrite(clazz, mediaType);
    }

    @Override
    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readType(this.getType(type, contextClass), inputMessage);
    }

    @Override
    public void write(Object o, Type type, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        super.write(o, contentType, outputMessage);
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readType(this.getType(clazz, null), inputMessage);
    }

    private Object readType(Type type, HttpInputMessage inputMessage) {
        Object t;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            InputStream in = inputMessage.getBody();
            byte[] buf = new byte[65536];
            while ((len = in.read(buf)) != -1) {
                if (len <= 0) continue;
                baos.write(buf, 0, len);
            }
            byte[] bytes = baos.toByteArray();
            t = JSON.parseObject(bytes, type, this.fastJsonConfig.getFeatures());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JSONException ex) {
                throw new HttpMessageNotReadableException("JSON parse error: " + ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new HttpMessageNotReadableException("I/O error while reading input message", ex);
            }
        }
        baos.close();
        return t;
    }

    @Override
    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int contentLength;
            HttpHeaders headers = outputMessage.getHeaders();
            if (object instanceof String && com.alibaba.fastjson2.JSON.isValidObject((String)object)) {
                byte[] strBytes = ((String)object).getBytes(this.fastJsonConfig.getCharset());
                contentLength = strBytes.length;
                outputMessage.getBody().write(strBytes, 0, strBytes.length);
            } else if (object instanceof byte[] && com.alibaba.fastjson2.JSON.isValid((byte[])object)) {
                byte[] strBytes = (byte[])object;
                contentLength = strBytes.length;
                outputMessage.getBody().write(strBytes, 0, strBytes.length);
            } else {
                contentLength = JSON.writeJSONString((OutputStream)baos, object, this.fastJsonConfig.getSerializeFilters(), this.fastJsonConfig.getSerializerFeatures());
            }
            if (headers.getContentLength() < 0L && this.fastJsonConfig.isWriteContentLength()) {
                headers.setContentLength(contentLength);
            }
            baos.writeTo(outputMessage.getBody());
        }
        catch (JSONException ex) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new HttpMessageNotWritableException("I/O error while writing output message", ex);
        }
    }

    protected Type getType(Type type, Class<?> contextClass) {
        if (Spring4TypeResolvableHelper.isSupport()) {
            return Spring4TypeResolvableHelper.getType(type, contextClass);
        }
        return type;
    }

    private static class Spring4TypeResolvableHelper {
        private static boolean hasClazzResolvableType;

        private Spring4TypeResolvableHelper() {
        }

        private static boolean isSupport() {
            return hasClazzResolvableType;
        }

        private static Type getType(Type type, Class<?> contextClass) {
            if (contextClass != null) {
                ResolvableType resolvedType = ResolvableType.forType(type);
                if (type instanceof TypeVariable) {
                    ResolvableType resolvedTypeVariable = Spring4TypeResolvableHelper.resolveVariable((TypeVariable)type, ResolvableType.forClass(contextClass));
                    if (resolvedTypeVariable != ResolvableType.NONE) {
                        return resolvedTypeVariable.resolve();
                    }
                } else if (type instanceof ParameterizedType && resolvedType.hasUnresolvableGenerics()) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                    Type[] typeArguments = parameterizedType.getActualTypeArguments();
                    for (int i2 = 0; i2 < typeArguments.length; ++i2) {
                        Type typeArgument = typeArguments[i2];
                        if (typeArgument instanceof TypeVariable) {
                            ResolvableType resolvedTypeArgument = Spring4TypeResolvableHelper.resolveVariable((TypeVariable)typeArgument, ResolvableType.forClass(contextClass));
                            if (resolvedTypeArgument != ResolvableType.NONE) {
                                generics[i2] = resolvedTypeArgument.resolve();
                                continue;
                            }
                            generics[i2] = ResolvableType.forType(typeArgument).resolve();
                            continue;
                        }
                        generics[i2] = ResolvableType.forType(typeArgument).resolve();
                    }
                    return ResolvableType.forClassWithGenerics(resolvedType.getRawClass(), generics).getType();
                }
            }
            return type;
        }

        private static ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
            ResolvableType resolvedType;
            if (contextType.hasGenerics() && (resolvedType = ResolvableType.forType(typeVariable, contextType)).resolve() != null) {
                return resolvedType;
            }
            ResolvableType superType = contextType.getSuperType();
            if (superType != ResolvableType.NONE && (resolvedType = Spring4TypeResolvableHelper.resolveVariable(typeVariable, superType)).resolve() != null) {
                return resolvedType;
            }
            for (ResolvableType ifc : contextType.getInterfaces()) {
                resolvedType = Spring4TypeResolvableHelper.resolveVariable(typeVariable, ifc);
                if (resolvedType.resolve() == null) continue;
                return resolvedType;
            }
            return ResolvableType.NONE;
        }

        static {
            try {
                Class.forName("org.springframework.core.ResolvableType");
                hasClazzResolvableType = true;
            }
            catch (ClassNotFoundException e) {
                hasClazzResolvableType = false;
            }
        }
    }
}

