/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTypedMulti;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;

class JSONPathTypedMultiNames
extends JSONPathTypedMulti {
    final JSONPath prefix;
    final JSONPath[] namePaths;
    final String[] names;
    final long[] hashCodes;
    final short[] mapping;
    final FieldReader[] fieldReaders;

    JSONPathTypedMultiNames(JSONPath[] paths, JSONPath prefix, JSONPath[] namePaths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, long features) {
        super(paths, types, formats, pathFeatures, zoneId, features);
        int i2;
        this.prefix = prefix;
        this.namePaths = namePaths;
        this.names = new String[paths.length];
        long[] hashCodes = new long[paths.length];
        this.fieldReaders = new FieldReader[paths.length];
        for (i2 = 0; i2 < paths.length; ++i2) {
            String fieldName;
            JSONPathSingleName jsonPathSingleName = (JSONPathSingleName)namePaths[i2];
            this.names[i2] = fieldName = jsonPathSingleName.name;
            hashCodes[i2] = jsonPathSingleName.nameHashCode;
            String format = formats != null ? formats[i2] : null;
            Type fieldType = types[i2];
            Class<?> fieldClass = TypeUtils.getClass(fieldType);
            long fieldFeatures = 0L;
            if (this.ignoreError(i2)) {
                fieldFeatures |= JSONReader.Feature.NullOnError.mask;
            }
            this.fieldReaders[i2] = ObjectReaderCreator.INSTANCE.createFieldReader(null, null, fieldName, fieldType, fieldClass, i2, fieldFeatures, format, null, null, null, null, null, null);
        }
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i2 = 0; i2 < hashCodes.length; ++i2) {
            long hashCode = hashCodes[i2];
            int index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i2;
        }
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public boolean contains(Object object) {
        for (JSONPath jsonPath : this.paths) {
            if (!jsonPath.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object eval(Object root) {
        Object[] array = new Object[this.paths.length];
        Object object = root;
        if (this.prefix != null) {
            object = this.prefix.eval(root);
        }
        if (object == null) {
            return new Object[this.paths.length];
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                Object result = map.get(this.names[i2]);
                Type type = this.types[i2];
                if (result != null && result.getClass() != type) {
                    result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
                }
                array[i2] = result;
            }
        } else {
            Class<?> objectClass = object.getClass();
            ObjectWriter objectReader = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(objectClass);
            for (int i3 = 0; i3 < this.names.length; ++i3) {
                FieldWriter fieldWriter = objectReader.getFieldWriter(this.names[i3]);
                if (fieldWriter == null) continue;
                Object result = fieldWriter.getFieldValue(object);
                Type type = this.types[i3];
                if (result != null && result.getClass() != type) {
                    result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
                }
                array[i3] = result;
            }
        }
        return array;
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        if (this.prefix != null) {
            Object object = jsonReader.readAny();
            return this.eval(object);
        }
        if (jsonReader.nextIfNull()) {
            return new Object[this.paths.length];
        }
        if (!jsonReader.nextIfObjectStart()) {
            throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
        }
        Object[] values = new Object[this.paths.length];
        while (!jsonReader.nextIfObjectEnd()) {
            Object fieldValue;
            long nameHashCode = jsonReader.readFieldNameHashCode();
            int m = Arrays.binarySearch(this.hashCodes, nameHashCode);
            if (m < 0) {
                jsonReader.skipValue();
                continue;
            }
            short index = this.mapping[m];
            FieldReader fieldReader = this.fieldReaders[index];
            try {
                fieldValue = fieldReader.readFieldValue(jsonReader);
            }
            catch (Exception e) {
                if (!this.ignoreError(index)) {
                    throw e;
                }
                fieldValue = null;
            }
            values[index] = fieldValue;
        }
        return values;
    }
}

