/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.internal.trove.map.hash.TLongIntHashMap;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class JSONWriterJSONB
extends JSONWriter {
    static final byte[] SHANGHAI_ZONE_ID_NAME_BYTES = JSONB.toBytes("Asia/Shanghai");
    static final byte[] OFFSET_8_ZONE_ID_NAME_BYTES = JSONB.toBytes("+08:00");
    private final JSONFactory.CacheItem cacheItem;
    private byte[] bytes;
    private TLongIntHashMap symbols;
    private int symbolIndex;
    protected long rootTypeNameHash;

    JSONWriterJSONB(JSONWriter.Context ctx, SymbolTable symbolTable) {
        super(ctx, symbolTable, true, StandardCharsets.UTF_8);
        int cachedIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cachedIndex];
        this.bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        if (this.bytes == null) {
            this.bytes = new byte[8192];
        }
    }

    @Override
    public void close() {
        if (this.bytes.length < 0x100000) {
            JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, this.bytes);
        }
    }

    @Override
    public void writeAny(Object value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        boolean fieldBased = (this.context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        Class<?> valueClass = value.getClass();
        ObjectWriter objectWriter = this.context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
        if (this.isBeanToArray()) {
            objectWriter.writeArrayMappingJSONB(this, value, null, null, 0L);
        } else {
            objectWriter.writeJSONB(this, value, null, null, 0L);
        }
    }

    @Override
    public void startObject() {
        ++this.level;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = -90;
    }

    @Override
    public void endObject() {
        --this.level;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = -91;
    }

    @Override
    public void startArray() {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void startArray(Object array, int size) {
        if (this.isWriteTypeInfo(array)) {
            this.writeTypeName(array.getClass().getName());
        }
        ++this.level;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        if (size <= 15) {
            this.bytes[this.off++] = (byte)(-108 + size);
        } else {
            this.bytes[this.off++] = -92;
            this.writeInt32(size);
        }
    }

    @Override
    public void startArray(int size) {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        if (size <= 15) {
            this.bytes[this.off++] = (byte)(-108 + size);
        } else {
            this.bytes[this.off++] = -92;
            this.writeInt32(size);
        }
    }

    @Override
    public void writeRaw(byte b) {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = b;
    }

    @Override
    public void writeChar(char ch) {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = -112;
        this.writeInt32(ch);
    }

    @Override
    public void writeName(String name) {
        this.writeString(name);
    }

    @Override
    public void writeNull() {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = -81;
    }

    @Override
    public void writeStringNull() {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = -81;
    }

    @Override
    public void endArray() {
        --this.level;
    }

    @Override
    public void writeComma() {
        throw new JSONException("unsupported operation");
    }

    @Override
    protected void write0(char ch) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeString(char[] chars, int off, int len, boolean quote) {
        int i2;
        if (chars == null) {
            this.writeNull();
            return;
        }
        boolean ascii = true;
        for (i2 = 0; i2 < len; ++i2) {
            if (chars[i2 + off] <= '\u00ff') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            if (len <= 47) {
                this.bytes[this.off++] = (byte)(len + 73);
            } else {
                this.bytes[this.off++] = 121;
                this.writeInt32(len);
            }
            for (i2 = 0; i2 < len; ++i2) {
                this.bytes[this.off++] = (byte)chars[off + i2];
            }
            return;
        }
        this.writeString(new String(chars, off, len));
    }

    @Override
    protected void writeStringLatin1(byte[] str) {
        if (str == null) {
            this.writeStringNull();
            return;
        }
        int strlen = str.length;
        int minCapacity = str.length + this.off + 5 + 1;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (strlen <= 47) {
            this.bytes[this.off++] = (byte)(strlen + 73);
        } else if (strlen >= -2048 && strlen <= 2047) {
            this.bytes[this.off++] = 121;
            this.bytes[this.off++] = (byte)(56 + (strlen >> 8));
            this.bytes[this.off++] = (byte)strlen;
        } else {
            this.bytes[this.off++] = 121;
            this.writeInt32(strlen);
        }
        System.arraycopy(str, 0, this.bytes, this.off, str.length);
        this.off += strlen;
    }

    @Override
    public void writeString(char[] chars) {
        int minCapacity;
        int i2;
        if (chars == null) {
            this.writeNull();
            return;
        }
        boolean ascii = true;
        int strlen = chars.length;
        if (chars.length < 47) {
            int mark = this.off;
            int minCapacity2 = this.off + 1 + strlen;
            if (minCapacity2 - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity2);
            }
            this.bytes[this.off++] = (byte)(strlen + 73);
            for (int i3 = 0; i3 < chars.length; ++i3) {
                char ch = chars[i3];
                if (ch > '\u00ff') {
                    ascii = false;
                    break;
                }
                this.bytes[this.off++] = (byte)ch;
            }
            if (ascii) {
                return;
            }
            this.off = mark;
        }
        int upperBound = chars.length & 0xFFFFFFFC;
        for (i2 = 0; i2 < upperBound; i2 += 4) {
            char c0 = chars[i2];
            char c1 = chars[i2 + 1];
            char c2 = chars[i2 + 2];
            char c3 = chars[i2 + 3];
            if (c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            while (i2 < chars.length) {
                if (chars[i2] > '\u00ff') {
                    ascii = false;
                    break;
                }
                ++i2;
            }
        }
        if ((minCapacity = (ascii ? strlen : strlen * 3) + this.off + 5 + 1) - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (ascii) {
            if (strlen <= 47) {
                this.bytes[this.off++] = (byte)(strlen + 73);
            } else if (strlen >= -2048 && strlen <= 2047) {
                this.bytes[this.off++] = 121;
                this.bytes[this.off++] = (byte)(56 + (strlen >> 8));
                this.bytes[this.off++] = (byte)strlen;
            } else {
                this.bytes[this.off++] = 121;
                this.writeInt32(strlen);
            }
            for (int i4 = 0; i4 < chars.length; ++i4) {
                this.bytes[this.off++] = (byte)chars[i4];
            }
        } else {
            int maxSize = chars.length * 3;
            int lenByteCnt = JSONWriterJSONB.sizeOfInt(maxSize);
            this.ensureCapacity(this.off + maxSize + lenByteCnt + 1);
            int result = IOUtils.encodeUTF8(chars, 0, chars.length, this.bytes, this.off + lenByteCnt + 1);
            int utf8len = result - this.off - lenByteCnt - 1;
            int utf8lenByteCnt = JSONWriterJSONB.sizeOfInt(utf8len);
            if (lenByteCnt != utf8lenByteCnt) {
                System.arraycopy(this.bytes, this.off + lenByteCnt + 1, this.bytes, this.off + utf8lenByteCnt + 1, utf8len);
            }
            this.bytes[this.off++] = 122;
            if (utf8len >= -16 && utf8len <= 47) {
                this.bytes[this.off++] = (byte)utf8len;
            } else if (utf8len >= -2048 && utf8len <= 2047) {
                this.bytes[this.off++] = (byte)(56 + (utf8len >> 8));
                this.bytes[this.off++] = (byte)utf8len;
            } else {
                this.writeInt32(utf8len);
            }
            this.off += utf8len;
        }
    }

    @Override
    public void writeString(char[] chars, int off, int len) {
        int minCapacity;
        int i2;
        if (chars == null) {
            this.writeNull();
            return;
        }
        boolean ascii = true;
        if (len < 47) {
            int mark = this.off;
            int minCapacity2 = this.off + 1 + len;
            if (minCapacity2 - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity2);
            }
            this.bytes[this.off++] = (byte)(len + 73);
            for (int i3 = off; i3 < len; ++i3) {
                char ch = chars[i3];
                if (ch > '\u00ff') {
                    ascii = false;
                    break;
                }
                this.bytes[this.off++] = (byte)ch;
            }
            if (ascii) {
                return;
            }
            this.off = mark;
        }
        int upperBound = chars.length & 0xFFFFFFFC;
        for (i2 = off; i2 < upperBound; i2 += 4) {
            char c0 = chars[i2];
            char c1 = chars[i2 + 1];
            char c2 = chars[i2 + 2];
            char c3 = chars[i2 + 3];
            if (c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            while (i2 < chars.length) {
                if (chars[i2] > '\u00ff') {
                    ascii = false;
                    break;
                }
                ++i2;
            }
        }
        if ((minCapacity = (ascii ? len : len * 3) + this.off + 5 + 1) - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (ascii) {
            if (len <= 47) {
                this.bytes[this.off++] = (byte)(len + 73);
            } else if (len >= -2048 && len <= 2047) {
                this.bytes[this.off++] = 121;
                this.bytes[this.off++] = (byte)(56 + (len >> 8));
                this.bytes[this.off++] = (byte)len;
            } else {
                this.bytes[this.off++] = 121;
                this.writeInt32(len);
            }
            for (int i4 = 0; i4 < chars.length; ++i4) {
                this.bytes[this.off++] = (byte)chars[i4];
            }
        } else {
            int maxSize = chars.length * 3;
            int lenByteCnt = JSONWriterJSONB.sizeOfInt(maxSize);
            this.ensureCapacity(this.off + maxSize + lenByteCnt + 1);
            int result = IOUtils.encodeUTF8(chars, 0, chars.length, this.bytes, this.off + lenByteCnt + 1);
            int utf8len = result - this.off - lenByteCnt - 1;
            int utf8lenByteCnt = JSONWriterJSONB.sizeOfInt(utf8len);
            if (lenByteCnt != utf8lenByteCnt) {
                System.arraycopy(this.bytes, this.off + lenByteCnt + 1, this.bytes, this.off + utf8lenByteCnt + 1, utf8len);
            }
            this.bytes[this.off++] = 122;
            if (utf8len >= -16 && utf8len <= 47) {
                this.bytes[this.off++] = (byte)utf8len;
            } else if (utf8len >= -2048 && utf8len <= 2047) {
                this.bytes[this.off++] = (byte)(56 + (utf8len >> 8));
                this.bytes[this.off++] = (byte)utf8len;
            } else {
                this.writeInt32(utf8len);
            }
            this.off += utf8len;
        }
    }

    @Override
    public void writeSymbol(String str) {
        int ordinal;
        if (str == null) {
            this.writeNull();
            return;
        }
        if (this.symbolTable != null && (ordinal = this.symbolTable.getOrdinal(str)) >= 0) {
            this.writeRaw((byte)127);
            this.writeInt32(-ordinal);
            return;
        }
        this.writeString(str);
    }

    @Override
    public void writeTypeName(String typeName) {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = -110;
        long hash = Fnv.hashCode64(typeName);
        int symbol = -1;
        if (this.symbolTable != null) {
            symbol = this.symbolTable.getOrdinalByHashCode(hash);
            if (symbol == -1 && this.symbols != null) {
                symbol = this.symbols.get(hash);
            }
        } else if (this.symbols != null) {
            symbol = this.symbols.get(hash);
        }
        if (symbol == -1) {
            if (this.symbols == null) {
                this.symbols = new TLongIntHashMap();
            }
        } else {
            if (this.off == this.bytes.length) {
                this.ensureCapacity(this.off + 1);
            }
            this.writeInt32(symbol);
            return;
        }
        symbol = this.symbolIndex++;
        this.symbols.put(hash, symbol);
        this.writeString(typeName);
        this.writeInt32(symbol);
    }

    @Override
    public boolean writeTypeName(byte[] typeName, long hash) {
        int symbol;
        int symbol2;
        if (this.symbolTable != null && (symbol2 = this.symbolTable.getOrdinalByHashCode(hash)) != -1) {
            if (this.off + 2 > this.bytes.length) {
                this.ensureCapacity(this.off + 2);
            }
            this.bytes[this.off++] = -110;
            this.writeInt32(-symbol2);
            return false;
        }
        boolean symbolExists = false;
        if (this.rootTypeNameHash == hash) {
            symbolExists = true;
            symbol = 0;
        } else if (this.symbols != null) {
            symbol = this.symbols.putIfAbsent(hash, this.symbolIndex);
            if (symbol != this.symbolIndex) {
                symbolExists = true;
            } else {
                ++this.symbolIndex;
            }
        } else {
            if ((symbol = this.symbolIndex++) == 0) {
                this.rootTypeNameHash = hash;
            }
            if (symbol != 0 || (this.context.features & JSONWriter.Feature.WriteNameAsSymbol.mask) != 0L) {
                this.symbols = new TLongIntHashMap(hash, symbol);
            }
        }
        if (symbolExists) {
            if (this.off == this.bytes.length) {
                this.ensureCapacity(this.off + 1);
            }
            this.bytes[this.off++] = -110;
            this.writeInt32(symbol);
            return false;
        }
        int minCapacity = this.off + 2 + typeName.length;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = -110;
        System.arraycopy(typeName, 0, this.bytes, this.off, typeName.length);
        this.off += typeName.length;
        if (symbol >= -16 && symbol <= 47) {
            this.bytes[this.off++] = (byte)symbol;
        } else {
            this.writeInt32(symbol);
        }
        return false;
    }

    static int sizeOfInt(int i2) {
        if (i2 >= -16 && i2 <= 47) {
            return 1;
        }
        if (i2 >= -2048 && i2 <= 2047) {
            return 2;
        }
        if (i2 >= -262144 && i2 <= 262143) {
            return 3;
        }
        return 5;
    }

    @Override
    public void writeString(List<String> list) {
        if (list == null) {
            this.writeArrayNull();
            return;
        }
        int size = list.size();
        this.startArray(size);
        if (JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER != null) {
            int mark = this.off;
            boolean LATIN = false;
            boolean latinAll = true;
            for (int i2 = 0; i2 < size; ++i2) {
                int coder;
                String str = list.get(i2);
                if (str == null) {
                    this.writeNull();
                }
                if ((coder = JDKUtils.STRING_CODER.applyAsInt(str)) != 0) {
                    latinAll = false;
                    this.off = mark;
                    break;
                }
                int strlen = str.length();
                if (strlen <= 47) {
                    this.bytes[this.off++] = (byte)(strlen + 73);
                } else if (strlen >= -2048 && strlen <= 2047) {
                    this.bytes[this.off++] = 121;
                    this.bytes[this.off++] = (byte)(56 + (strlen >> 8));
                    this.bytes[this.off++] = (byte)strlen;
                } else {
                    this.bytes[this.off++] = 121;
                    this.writeInt32(strlen);
                }
                byte[] value = JDKUtils.STRING_VALUE.apply(str);
                System.arraycopy(value, 0, this.bytes, this.off, value.length);
                this.off += strlen;
            }
            if (latinAll) {
                return;
            }
        }
        for (int i3 = 0; i3 < size; ++i3) {
            String str = list.get(i3);
            this.writeString(str);
        }
    }

    @Override
    public void writeString(String str) {
        int minCapacity;
        int i2;
        int i3;
        if (str == null) {
            this.writeNull();
            return;
        }
        if (JDKUtils.STRING_VALUE != null) {
            boolean utf16;
            int coder = JDKUtils.STRING_CODER.applyAsInt(str);
            byte[] value = JDKUtils.STRING_VALUE.apply(str);
            if (coder == 0) {
                this.writeStringLatin1(value);
                return;
            }
            int check_cnt = 128;
            if (check_cnt > value.length) {
                check_cnt = value.length;
            }
            if ((check_cnt & 1) == 1) {
                --check_cnt;
            }
            int asciiCount = 0;
            i3 = 0;
            while (i3 + 2 <= check_cnt) {
                byte b0 = value[i3];
                byte b1 = value[i3 + 1];
                if (b0 == 0 || b1 == 0) {
                    ++asciiCount;
                }
                i3 += 2;
            }
            boolean bl = utf16 = value.length != 0 && (asciiCount == 0 || (check_cnt >> 1) / asciiCount >= 3);
            if (!utf16) {
                int maxSize = value.length * 3;
                int lenByteCnt = JSONWriterJSONB.sizeOfInt(maxSize);
                this.ensureCapacity(this.off + maxSize + lenByteCnt + 1);
                int result = IOUtils.encodeUTF8(value, 0, value.length, this.bytes, this.off + lenByteCnt + 1);
                int utf8len = result - this.off - lenByteCnt - 1;
                if (utf8len > value.length) {
                    utf16 = true;
                } else if (result != -1) {
                    int strtype;
                    if (utf8len * 2 == value.length) {
                        if (asciiCount <= 47) {
                            this.bytes[this.off++] = (byte)(73 + utf8len);
                            System.arraycopy(this.bytes, this.off + lenByteCnt, this.bytes, this.off, utf8len);
                            this.off += utf8len;
                            return;
                        }
                        strtype = 121;
                    } else {
                        strtype = 122;
                    }
                    int utf8lenByteCnt = JSONWriterJSONB.sizeOfInt(utf8len);
                    if (lenByteCnt != utf8lenByteCnt) {
                        System.arraycopy(this.bytes, this.off + lenByteCnt + 1, this.bytes, this.off + utf8lenByteCnt + 1, utf8len);
                    }
                    this.bytes[this.off++] = strtype;
                    if (utf8len <= 47) {
                        this.bytes[this.off++] = (byte)utf8len;
                    } else if (utf8len <= 2047) {
                        this.bytes[this.off++] = (byte)(56 + (utf8len >> 8));
                        this.bytes[this.off++] = (byte)utf8len;
                    } else {
                        this.writeInt32(utf8len);
                    }
                    this.off += utf8len;
                    return;
                }
            }
            if (utf16) {
                this.ensureCapacity(this.off + 6 + value.length);
                int n = this.bytes[this.off++] = JDKUtils.BIG_ENDIAN ? 125 : 124;
                if (value.length <= 47) {
                    this.bytes[this.off++] = (byte)value.length;
                } else if (value.length <= 2047) {
                    this.bytes[this.off++] = (byte)(56 + (value.length >> 8));
                    this.bytes[this.off++] = (byte)value.length;
                } else {
                    this.writeInt32(value.length);
                }
                System.arraycopy(value, 0, this.bytes, this.off, value.length);
                this.off += value.length;
                return;
            }
        }
        char[] chars = JDKUtils.getCharArray(str);
        int strlen = chars.length;
        boolean ascii = true;
        if (chars.length < 47) {
            int mark = this.off;
            int minCapacity2 = this.off + 1 + strlen;
            if (minCapacity2 - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity2);
            }
            this.bytes[this.off++] = (byte)(strlen + 73);
            for (int i4 = 0; i4 < chars.length; ++i4) {
                char ch = chars[i4];
                if (ch > '\u00ff') {
                    ascii = false;
                    break;
                }
                this.bytes[this.off++] = (byte)ch;
            }
            if (ascii) {
                return;
            }
            this.off = mark;
        }
        int upperBound = chars.length & 0xFFFFFFFC;
        for (i2 = 0; i2 < upperBound; i2 += 4) {
            char c0 = chars[i2];
            char c1 = chars[i2 + 1];
            char c2 = chars[i2 + 2];
            char c3 = chars[i2 + 3];
            if (c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            while (i2 < chars.length) {
                if (chars[i2] > '\u00ff') {
                    ascii = false;
                    break;
                }
                ++i2;
            }
        }
        if ((minCapacity = (ascii ? strlen : strlen * 3) + this.off + 5 + 1) - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (ascii) {
            if (strlen <= 47) {
                this.bytes[this.off++] = (byte)(strlen + 73);
            } else if (strlen >= -2048 && strlen <= 2047) {
                this.bytes[this.off++] = 121;
                this.bytes[this.off++] = (byte)(56 + (strlen >> 8));
                this.bytes[this.off++] = (byte)strlen;
            } else {
                this.bytes[this.off++] = 121;
                this.writeInt32(strlen);
            }
            for (i3 = 0; i3 < chars.length; ++i3) {
                this.bytes[this.off++] = (byte)chars[i3];
            }
        } else {
            int maxSize = chars.length * 3;
            int lenByteCnt = JSONWriterJSONB.sizeOfInt(maxSize);
            this.ensureCapacity(this.off + maxSize + lenByteCnt + 1);
            int result = IOUtils.encodeUTF8(chars, 0, chars.length, this.bytes, this.off + lenByteCnt + 1);
            int utf8len = result - this.off - lenByteCnt - 1;
            int utf8lenByteCnt = JSONWriterJSONB.sizeOfInt(utf8len);
            if (lenByteCnt != utf8lenByteCnt) {
                System.arraycopy(this.bytes, this.off + lenByteCnt + 1, this.bytes, this.off + utf8lenByteCnt + 1, utf8len);
            }
            this.bytes[this.off++] = 122;
            if (utf8len >= -16 && utf8len <= 47) {
                this.bytes[this.off++] = (byte)utf8len;
            } else if (utf8len >= -2048 && utf8len <= 2047) {
                this.bytes[this.off++] = (byte)(56 + (utf8len >> 8));
                this.bytes[this.off++] = (byte)utf8len;
            } else {
                this.writeInt32(utf8len);
            }
            this.off += utf8len;
        }
    }

    void ensureCapacity(int minCapacity) {
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
    }

    @Override
    public void writeMillis(long millis) {
        int minCapacity;
        if (millis % 1000L == 0L) {
            long minutes;
            long seconds = millis / 1000L;
            if (seconds >= Integer.MIN_VALUE && seconds <= Integer.MAX_VALUE) {
                int secondsInt = (int)seconds;
                int minCapacity2 = this.off + 5;
                if (minCapacity2 - this.bytes.length > 0) {
                    this.ensureCapacity(minCapacity2);
                }
                this.bytes[this.off++] = -84;
                this.bytes[this.off++] = (byte)(secondsInt >>> 24);
                this.bytes[this.off++] = (byte)(secondsInt >>> 16);
                this.bytes[this.off++] = (byte)(secondsInt >>> 8);
                this.bytes[this.off++] = (byte)secondsInt;
                return;
            }
            if (seconds % 60L == 0L && (minutes = seconds / 60L) >= Integer.MIN_VALUE && minutes <= Integer.MAX_VALUE) {
                int minutesInt = (int)minutes;
                int minCapacity3 = this.off + 5;
                if (minCapacity3 - this.bytes.length > 0) {
                    this.ensureCapacity(minCapacity3);
                }
                this.bytes[this.off++] = -83;
                this.bytes[this.off++] = (byte)(minutesInt >>> 24);
                this.bytes[this.off++] = (byte)(minutesInt >>> 16);
                this.bytes[this.off++] = (byte)(minutesInt >>> 8);
                this.bytes[this.off++] = (byte)minutesInt;
                return;
            }
        }
        if ((minCapacity = this.off + 9) - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = -85;
        this.bytes[this.off++] = (byte)(millis >>> 56);
        this.bytes[this.off++] = (byte)(millis >>> 48);
        this.bytes[this.off++] = (byte)(millis >>> 40);
        this.bytes[this.off++] = (byte)(millis >>> 32);
        this.bytes[this.off++] = (byte)(millis >>> 24);
        this.bytes[this.off++] = (byte)(millis >>> 16);
        this.bytes[this.off++] = (byte)(millis >>> 8);
        this.bytes[this.off++] = (byte)millis;
    }

    @Override
    public void writeInt64(long val2) {
        if (val2 >= -8L && val2 <= 15L) {
            if (this.off == this.bytes.length) {
                this.ensureCapacity(this.off + 1);
            }
            this.bytes[this.off++] = (byte)(-40L + (val2 - -8L));
            return;
        }
        if (val2 >= -2048L && val2 <= 2047L) {
            int minCapacity = this.off + 2;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = (byte)(-48L + (val2 >> 8));
            this.bytes[this.off++] = (byte)val2;
            return;
        }
        if (val2 >= -262144L && val2 <= 262143L) {
            int minCapacity = this.off + 3;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = (byte)(-60L + (val2 >> 16));
            this.bytes[this.off++] = (byte)(val2 >> 8);
            this.bytes[this.off++] = (byte)val2;
            return;
        }
        if (val2 >= Integer.MIN_VALUE && val2 <= Integer.MAX_VALUE) {
            int minCapacity = this.off + 5;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = -65;
            this.bytes[this.off++] = (byte)(val2 >>> 24);
            this.bytes[this.off++] = (byte)(val2 >>> 16);
            this.bytes[this.off++] = (byte)(val2 >>> 8);
            this.bytes[this.off++] = (byte)val2;
            return;
        }
        int minCapacity = this.off + 9;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = -66;
        this.bytes[this.off++] = (byte)(val2 >>> 56);
        this.bytes[this.off++] = (byte)(val2 >>> 48);
        this.bytes[this.off++] = (byte)(val2 >>> 40);
        this.bytes[this.off++] = (byte)(val2 >>> 32);
        this.bytes[this.off++] = (byte)(val2 >>> 24);
        this.bytes[this.off++] = (byte)(val2 >>> 16);
        this.bytes[this.off++] = (byte)(val2 >>> 8);
        this.bytes[this.off++] = (byte)val2;
    }

    @Override
    public void writeInt64(long[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        int size = value.length;
        ++this.level;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        if (size <= 15) {
            this.bytes[this.off++] = (byte)(-108 + size);
        } else {
            this.bytes[this.off++] = -92;
            this.writeInt32(size);
        }
        for (int i2 = 0; i2 < value.length; ++i2) {
            int minCapacity;
            long val2 = value[i2];
            if (val2 >= -16L && val2 <= 47L) {
                if (this.off == this.bytes.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.bytes[this.off++] = (byte)val2;
                continue;
            }
            if (val2 >= -2048L && val2 <= 2047L) {
                minCapacity = this.off + 2;
                if (minCapacity - this.bytes.length > 0) {
                    this.ensureCapacity(minCapacity);
                }
                this.bytes[this.off++] = (byte)(-48L + (val2 >> 8));
                this.bytes[this.off++] = (byte)val2;
                continue;
            }
            if (val2 >= -262144L && val2 <= 262143L) {
                minCapacity = this.off + 3;
                if (minCapacity - this.bytes.length > 0) {
                    this.ensureCapacity(minCapacity);
                }
                this.bytes[this.off++] = (byte)(-60L + (val2 >> 16));
                this.bytes[this.off++] = (byte)(val2 >> 8);
                this.bytes[this.off++] = (byte)val2;
                continue;
            }
            minCapacity = this.off + 9;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = -66;
            this.bytes[this.off++] = (byte)(val2 >>> 56);
            this.bytes[this.off++] = (byte)(val2 >>> 48);
            this.bytes[this.off++] = (byte)(val2 >>> 40);
            this.bytes[this.off++] = (byte)(val2 >>> 32);
            this.bytes[this.off++] = (byte)(val2 >>> 24);
            this.bytes[this.off++] = (byte)(val2 >>> 16);
            this.bytes[this.off++] = (byte)(val2 >>> 8);
            this.bytes[this.off++] = (byte)val2;
        }
        --this.level;
    }

    @Override
    public void writeFloat(float value) {
        int int32Value;
        if (value >= -262144.0f && value <= 262143.0f && (float)(int32Value = (int)value) == value) {
            this.ensureCapacity(this.off + 1);
            this.bytes[this.off++] = -74;
            this.writeInt32(int32Value);
            return;
        }
        this.ensureCapacity(this.off + 5);
        this.bytes[this.off++] = -73;
        int i2 = Float.floatToIntBits(value);
        this.bytes[this.off++] = (byte)(i2 >>> 24);
        this.bytes[this.off++] = (byte)(i2 >>> 16);
        this.bytes[this.off++] = (byte)(i2 >>> 8);
        this.bytes[this.off++] = (byte)i2;
    }

    @Override
    public void writeFloat(float[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray(value.length);
        for (int i2 = 0; i2 < value.length; ++i2) {
            this.writeFloat(value[i2]);
        }
        this.endArray();
    }

    @Override
    public void writeDouble(double value) {
        long longValue;
        if (value == 0.0) {
            this.ensureCapacity(this.off + 1);
            this.bytes[this.off++] = -78;
            return;
        }
        if (value == 1.0) {
            this.ensureCapacity(this.off + 1);
            this.bytes[this.off++] = -77;
            return;
        }
        if (value >= -2.147483648E9 && value <= 2.147483647E9 && (double)(longValue = (long)value) == value) {
            this.ensureCapacity(this.off + 1);
            this.bytes[this.off++] = -76;
            this.writeInt64(longValue);
            return;
        }
        this.ensureCapacity(this.off + 9);
        this.bytes[this.off++] = -75;
        long i2 = Double.doubleToLongBits(value);
        this.bytes[this.off++] = (byte)(i2 >>> 56);
        this.bytes[this.off++] = (byte)(i2 >>> 48);
        this.bytes[this.off++] = (byte)(i2 >>> 40);
        this.bytes[this.off++] = (byte)(i2 >>> 32);
        this.bytes[this.off++] = (byte)(i2 >>> 24);
        this.bytes[this.off++] = (byte)(i2 >>> 16);
        this.bytes[this.off++] = (byte)(i2 >>> 8);
        this.bytes[this.off++] = (byte)i2;
    }

    @Override
    public void writeDouble(double[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray(value.length);
        for (int i2 = 0; i2 < value.length; ++i2) {
            this.writeDouble(value[i2]);
        }
        this.endArray();
    }

    @Override
    public void writeInt16(short[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray(value.length);
        for (int i2 = 0; i2 < value.length; ++i2) {
            this.writeInt32(value[i2]);
        }
        this.endArray();
    }

    @Override
    public void writeInt32(int[] values) {
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int size = values.length;
        ++this.level;
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        if (size <= 15) {
            this.bytes[this.off++] = (byte)(-108 + size);
        } else {
            this.bytes[this.off++] = -92;
            this.writeInt32(size);
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            int minCapacity;
            int val2 = values[i2];
            if (val2 >= -16 && val2 <= 47) {
                if (this.off == this.bytes.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.bytes[this.off++] = (byte)val2;
                continue;
            }
            if (val2 >= -2048 && val2 <= 2047) {
                minCapacity = this.off + 2;
                if (minCapacity - this.bytes.length > 0) {
                    this.ensureCapacity(minCapacity);
                }
                this.bytes[this.off++] = (byte)(56 + (val2 >> 8));
                this.bytes[this.off++] = (byte)val2;
                continue;
            }
            if (val2 >= -262144 && val2 <= 262143) {
                minCapacity = this.off + 3;
                if (minCapacity - this.bytes.length > 0) {
                    this.ensureCapacity(minCapacity);
                }
                this.bytes[this.off++] = (byte)(68 + (val2 >> 16));
                this.bytes[this.off++] = (byte)(val2 >> 8);
                this.bytes[this.off++] = (byte)val2;
                continue;
            }
            minCapacity = this.off + 5;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = 72;
            this.bytes[this.off++] = (byte)(val2 >>> 24);
            this.bytes[this.off++] = (byte)(val2 >>> 16);
            this.bytes[this.off++] = (byte)(val2 >>> 8);
            this.bytes[this.off++] = (byte)val2;
        }
        --this.level;
    }

    @Override
    public void writeInt8(byte val2) {
        int minCapacity = this.off + 2;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = -67;
        this.bytes[this.off++] = val2;
    }

    @Override
    public void writeInt16(short val2) {
        int minCapacity = this.off + 3;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = -68;
        this.bytes[this.off++] = (byte)(val2 >>> 8);
        this.bytes[this.off++] = (byte)val2;
    }

    @Override
    public void writeEnum(Enum e) {
        if (e == null) {
            this.writeNull();
            return;
        }
        if ((this.context.features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L) {
            this.writeString(e.toString());
        } else if ((this.context.features & JSONWriter.Feature.WriteEnumsUsingName.mask) != 0L) {
            this.writeString(e.name());
        } else {
            int val2 = e.ordinal();
            if (val2 >= -16 && val2 <= 47) {
                if (this.off == this.bytes.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.bytes[this.off++] = (byte)val2;
                return;
            }
            this.writeInt32(val2);
        }
    }

    @Override
    public void writeInt32(int val2) {
        if (val2 >= -16 && val2 <= 47) {
            if (this.off == this.bytes.length) {
                this.ensureCapacity(this.off + 1);
            }
            this.bytes[this.off++] = (byte)val2;
            return;
        }
        if (val2 >= -2048 && val2 <= 2047) {
            int minCapacity = this.off + 2;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = (byte)(56 + (val2 >> 8));
            this.bytes[this.off++] = (byte)val2;
            return;
        }
        if (val2 >= -262144 && val2 <= 262143) {
            int minCapacity = this.off + 3;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = (byte)(68 + (val2 >> 16));
            this.bytes[this.off++] = (byte)(val2 >> 8);
            this.bytes[this.off++] = (byte)val2;
            return;
        }
        int minCapacity = this.off + 5;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = 72;
        this.bytes[this.off++] = (byte)(val2 >>> 24);
        this.bytes[this.off++] = (byte)(val2 >>> 16);
        this.bytes[this.off++] = (byte)(val2 >>> 8);
        this.bytes[this.off++] = (byte)val2;
    }

    @Override
    public void writeArrayNull() {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = (this.context.features & (JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) != 0L ? -108 : -81;
    }

    @Override
    public void writeRaw(String str) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeRaw(byte[] bytes) {
        int minCapacity = this.off + bytes.length;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public void writeSymbol(int symbol) {
        int minCapacity = this.off + 3;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = 127;
        if (symbol >= -16 && symbol <= 47) {
            this.bytes[this.off++] = (byte)symbol;
            return;
        }
        if (symbol >= -2048 && symbol <= 2047) {
            this.bytes[this.off++] = (byte)(56 + (symbol >> 8));
            this.bytes[this.off++] = (byte)symbol;
            return;
        }
        this.writeInt32(symbol);
    }

    @Override
    public void writeNameRaw(byte[] name, long nameHash) {
        int symbol;
        int symbol2;
        if (this.symbolTable != null && (symbol2 = this.symbolTable.getOrdinalByHashCode(nameHash)) != -1) {
            int minCapacity = this.off + 2;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = 127;
            this.writeInt32(-symbol2);
            return;
        }
        if ((this.context.features & JSONWriter.Feature.WriteNameAsSymbol.mask) == 0L) {
            int minCapacity = this.off + name.length;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            System.arraycopy(name, 0, this.bytes, this.off, name.length);
            this.off += name.length;
            return;
        }
        boolean symbolExists = false;
        if (this.symbols != null) {
            symbol = this.symbols.putIfAbsent(nameHash, this.symbolIndex);
            if (symbol != this.symbolIndex) {
                symbolExists = true;
            } else {
                ++this.symbolIndex;
            }
        } else {
            this.symbols = new TLongIntHashMap();
            symbol = this.symbolIndex++;
            this.symbols.put(nameHash, symbol);
        }
        if (symbolExists) {
            int minCapacity = this.off + 2;
            if (minCapacity - this.bytes.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.bytes[this.off++] = 127;
            if (symbol >= -16 && symbol <= 47) {
                this.bytes[this.off++] = (byte)symbol;
            } else {
                this.writeInt32(symbol);
            }
            return;
        }
        int minCapacity = this.off + 2 + name.length;
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = 127;
        System.arraycopy(name, 0, this.bytes, this.off, name.length);
        this.off += name.length;
        if (symbol >= -16 && symbol <= 47) {
            this.bytes[this.off++] = (byte)symbol;
        } else {
            this.writeInt32(symbol);
        }
    }

    @Override
    public void writeLocalDate(LocalDate date) {
        if (date == null) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 5);
        this.bytes[this.off++] = -87;
        int year = date.getYear();
        this.bytes[this.off++] = (byte)(year >>> 8);
        this.bytes[this.off++] = (byte)year;
        this.bytes[this.off++] = (byte)date.getMonthValue();
        this.bytes[this.off++] = (byte)date.getDayOfMonth();
    }

    @Override
    public void writeLocalTime(LocalTime time) {
        if (time == null) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 4);
        this.bytes[this.off++] = -89;
        this.bytes[this.off++] = (byte)time.getHour();
        this.bytes[this.off++] = (byte)time.getMinute();
        this.bytes[this.off++] = (byte)time.getSecond();
        int nano = time.getNano();
        this.writeInt32(nano);
    }

    @Override
    public void writeLocalDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 8);
        this.bytes[this.off++] = -88;
        int year = dateTime.getYear();
        this.bytes[this.off++] = (byte)(year >>> 8);
        this.bytes[this.off++] = (byte)year;
        this.bytes[this.off++] = (byte)dateTime.getMonthValue();
        this.bytes[this.off++] = (byte)dateTime.getDayOfMonth();
        this.bytes[this.off++] = (byte)dateTime.getHour();
        this.bytes[this.off++] = (byte)dateTime.getMinute();
        this.bytes[this.off++] = (byte)dateTime.getSecond();
        int nano = dateTime.getNano();
        this.writeInt32(nano);
    }

    @Override
    public void writeZonedDateTime(ZonedDateTime dateTime) {
        String zoneIdStr;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 8);
        this.bytes[this.off++] = -86;
        int year = dateTime.getYear();
        this.bytes[this.off++] = (byte)(year >>> 8);
        this.bytes[this.off++] = (byte)year;
        this.bytes[this.off++] = (byte)dateTime.getMonthValue();
        this.bytes[this.off++] = (byte)dateTime.getDayOfMonth();
        this.bytes[this.off++] = (byte)dateTime.getHour();
        this.bytes[this.off++] = (byte)dateTime.getMinute();
        this.bytes[this.off++] = (byte)dateTime.getSecond();
        int nano = dateTime.getNano();
        this.writeInt32(nano);
        ZoneId zoneId = dateTime.getZone();
        switch (zoneIdStr = zoneId.getId()) {
            case "Asia/Shanghai": {
                this.writeRaw(SHANGHAI_ZONE_ID_NAME_BYTES);
                break;
            }
            default: {
                this.writeString(zoneIdStr);
            }
        }
    }

    @Override
    public void writeOffsetDateTime(OffsetDateTime dateTime) {
        String zoneIdStr;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 8);
        this.bytes[this.off++] = -86;
        int year = dateTime.getYear();
        this.bytes[this.off++] = (byte)(year >>> 8);
        this.bytes[this.off++] = (byte)year;
        this.bytes[this.off++] = (byte)dateTime.getMonthValue();
        this.bytes[this.off++] = (byte)dateTime.getDayOfMonth();
        this.bytes[this.off++] = (byte)dateTime.getHour();
        this.bytes[this.off++] = (byte)dateTime.getMinute();
        this.bytes[this.off++] = (byte)dateTime.getSecond();
        int nano = dateTime.getNano();
        this.writeInt32(nano);
        ZoneOffset zoneId = dateTime.getOffset();
        switch (zoneIdStr = ((ZoneId)zoneId).getId()) {
            case "+08:00": {
                this.writeRaw(OFFSET_8_ZONE_ID_NAME_BYTES);
                break;
            }
            default: {
                this.writeString(zoneIdStr);
            }
        }
    }

    @Override
    public void writeInstant(Instant instant) {
        if (instant == null) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 1);
        this.bytes[this.off++] = -82;
        long second = instant.getEpochSecond();
        int nano = instant.getNano();
        this.writeInt64(second);
        this.writeInt32(nano);
    }

    @Override
    public void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        this.ensureCapacity(this.off + 18);
        this.bytes[this.off++] = -111;
        this.bytes[this.off++] = 16;
        this.bytes[this.off++] = (byte)(msb >>> 56);
        this.bytes[this.off++] = (byte)(msb >>> 48);
        this.bytes[this.off++] = (byte)(msb >>> 40);
        this.bytes[this.off++] = (byte)(msb >>> 32);
        this.bytes[this.off++] = (byte)(msb >>> 24);
        this.bytes[this.off++] = (byte)(msb >>> 16);
        this.bytes[this.off++] = (byte)(msb >>> 8);
        this.bytes[this.off++] = (byte)msb;
        this.bytes[this.off++] = (byte)(lsb >>> 56);
        this.bytes[this.off++] = (byte)(lsb >>> 48);
        this.bytes[this.off++] = (byte)(lsb >>> 40);
        this.bytes[this.off++] = (byte)(lsb >>> 32);
        this.bytes[this.off++] = (byte)(lsb >>> 24);
        this.bytes[this.off++] = (byte)(lsb >>> 16);
        this.bytes[this.off++] = (byte)(lsb >>> 8);
        this.bytes[this.off++] = (byte)lsb;
    }

    @Override
    public void writeBigInt(BigInteger value, long features) {
        if (value == null) {
            this.writeNull();
            return;
        }
        if (TypeUtils.isInt64(value)) {
            if (this.off == this.bytes.length) {
                this.ensureCapacity(this.off + 1);
            }
            this.bytes[this.off++] = -70;
            long int64Value = value.longValue();
            this.writeInt64(int64Value);
            return;
        }
        byte[] bytes = value.toByteArray();
        this.ensureCapacity(this.off + 5 + bytes.length);
        this.bytes[this.off++] = -69;
        this.writeInt32(bytes.length);
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public void writeBinary(byte[] bytes) {
        if (bytes == null) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 6 + bytes.length);
        this.bytes[this.off++] = -111;
        this.writeInt32(bytes.length);
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public void writeDecimal(BigDecimal value, long features, DecimalFormat format) {
        if (value == null) {
            this.writeNull();
            return;
        }
        int precision = value.precision();
        int scale = value.scale();
        if (precision < 19 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L) {
            long intCompact = UnsafeUtils.getLong(value, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET);
            if (scale == 0) {
                this.ensureCapacity(this.off + 1);
                this.bytes[this.off++] = -72;
                long longValue = intCompact;
                this.writeInt64(longValue);
                return;
            }
            this.ensureCapacity(this.off + 1);
            this.bytes[this.off++] = -71;
            this.writeInt32(scale);
            if (intCompact >= Integer.MIN_VALUE && intCompact <= Integer.MAX_VALUE) {
                this.writeInt32((int)intCompact);
            } else {
                this.writeInt64(intCompact);
            }
            return;
        }
        BigInteger unscaledValue = value.unscaledValue();
        if (scale == 0 && TypeUtils.isInt64(unscaledValue)) {
            this.ensureCapacity(this.off + 1);
            this.bytes[this.off++] = -72;
            long longValue = unscaledValue.longValue();
            this.writeInt64(longValue);
            return;
        }
        this.ensureCapacity(this.off + 1);
        this.bytes[this.off++] = -71;
        this.writeInt32(scale);
        if (TypeUtils.isInt32(unscaledValue)) {
            int intValue = unscaledValue.intValue();
            this.writeInt32(intValue);
        } else if (TypeUtils.isInt64(unscaledValue)) {
            long longValue = unscaledValue.longValue();
            this.writeInt64(longValue);
        } else {
            this.writeBigInt(unscaledValue, 0L);
        }
    }

    @Override
    public void writeBool(boolean value) {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = value ? -79 : -80;
    }

    @Override
    public void writeBool(boolean[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray(value.length);
        for (int i2 = 0; i2 < value.length; ++i2) {
            this.writeBool(value[i2]);
        }
        this.endArray();
    }

    @Override
    public void writeReference(String path) {
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.bytes[this.off++] = -109;
        if (path == this.lastReference) {
            this.writeString("#-1");
        } else {
            this.writeString(path);
        }
        this.lastReference = path;
    }

    @Override
    public void writeDateTime14(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 8);
        this.bytes[this.off++] = -88;
        this.bytes[this.off++] = (byte)(year >>> 8);
        this.bytes[this.off++] = (byte)year;
        this.bytes[this.off++] = (byte)month;
        this.bytes[this.off++] = (byte)dayOfMonth;
        this.bytes[this.off++] = (byte)hour;
        this.bytes[this.off++] = (byte)minute;
        this.bytes[this.off++] = (byte)second;
        int nano = 0;
        this.writeInt32(nano);
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 8);
        this.bytes[this.off++] = -88;
        this.bytes[this.off++] = (byte)(year >>> 8);
        this.bytes[this.off++] = (byte)year;
        this.bytes[this.off++] = (byte)month;
        this.bytes[this.off++] = (byte)dayOfMonth;
        this.bytes[this.off++] = (byte)hour;
        this.bytes[this.off++] = (byte)minute;
        this.bytes[this.off++] = (byte)second;
        int nano = 0;
        this.writeInt32(nano);
    }

    @Override
    public void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds, boolean timeZone) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeDateYYYMMDD8(int year, int month, int dayOfMonth) {
        this.ensureCapacity(this.off + 5);
        this.bytes[this.off++] = -87;
        this.bytes[this.off++] = (byte)(year >>> 8);
        this.bytes[this.off++] = (byte)year;
        this.bytes[this.off++] = (byte)month;
        this.bytes[this.off++] = (byte)dayOfMonth;
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeTimeHHMMSS8(int hour, int minute, int second) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeBase64(byte[] bytes) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeHex(byte[] bytes) {
        this.writeBinary(bytes);
    }

    @Override
    public void writeRaw(char ch) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeNameRaw(byte[] bytes) {
        this.writeRaw(bytes);
    }

    @Override
    public void writeNameRaw(char[] chars) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeNameRaw(char[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeColon() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        int size = array.size();
        this.startArray(size);
        for (int i2 = 0; i2 < size; ++i2) {
            Object item = array.get(i2);
            this.writeAny(item);
        }
    }

    @Override
    public void write(Map map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        this.startObject();
        for (Map.Entry entry : map.entrySet()) {
            this.writeAny(entry.getKey());
            this.writeAny(entry.getValue());
        }
        this.endObject();
    }

    @Override
    public void write(JSONObject object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        this.startObject();
        for (Map.Entry entry : object.entrySet()) {
            this.writeAny(entry.getKey());
            this.writeAny(entry.getValue());
        }
        this.endObject();
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.off);
    }

    @Override
    public int size() {
        return this.off;
    }

    @Override
    public byte[] getBytes(Charset charset) {
        throw new JSONException("not support operator");
    }

    @Override
    public int flushTo(OutputStream to) throws IOException {
        int len = this.off;
        to.write(this.bytes, 0, this.off);
        this.off = 0;
        return len;
    }

    @Override
    public int flushTo(OutputStream out, Charset charset) throws IOException {
        throw new JSONException("UnsupportedOperation");
    }

    public String toString() {
        if (this.bytes.length == 0) {
            return "<empty>";
        }
        byte[] jsonbBytes = this.getBytes();
        JSONReader reader = JSONReader.ofJSONB(jsonbBytes);
        JSONWriter writer = JSONWriter.of();
        try {
            Object object = reader.readAny();
            writer.writeAny(object);
            return writer.toString();
        }
        catch (Exception ex) {
            return JSONB.typeName(this.bytes[0]) + ", bytes length " + this.off;
        }
    }
}

