/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.MultiType;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class TypeReference<T> {
    protected final Type type;
    protected final Class<? super T> rawType;

    public TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.rawType = BeanUtils.getRawType(this.type);
    }

    private TypeReference(Type type, boolean raw) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = BeanUtils.canonicalize(type);
        this.rawType = BeanUtils.getRawType(type);
    }

    public TypeReference(Type ... actualTypeArguments) {
        if (actualTypeArguments == null || actualTypeArguments.length == 0) {
            throw new NullPointerException();
        }
        if (actualTypeArguments.length == 1 && actualTypeArguments[0] == null) {
            actualTypeArguments = new Type[]{Object.class};
        }
        Class<?> thisClass = this.getClass();
        Type superClass = thisClass.getGenericSuperclass();
        ParameterizedType argType = (ParameterizedType)((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.type = TypeReference.canonicalize(thisClass, argType, actualTypeArguments, 0);
        this.rawType = BeanUtils.getRawType(this.type);
    }

    public final Type getType() {
        return this.type;
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public T parseObject(String text) {
        return JSON.parseObject(text, this.type);
    }

    public T parseObject(byte[] utf8Bytes) {
        return JSON.parseObject(utf8Bytes, this.type);
    }

    public List<T> parseArray(String text, JSONReader.Feature ... features) {
        return JSON.parseArray(text, this.type, features);
    }

    public List<T> parseArray(byte[] utf8Bytes, JSONReader.Feature ... features) {
        return JSON.parseArray(utf8Bytes, this.type, features);
    }

    public T to(JSONArray array) {
        return array.to(this.type);
    }

    public T to(JSONObject object, JSONReader.Feature ... features) {
        return object.to(this.type, features);
    }

    @Deprecated
    public T toJavaObject(JSONArray array) {
        return array.to(this.type);
    }

    @Deprecated
    public T toJavaObject(JSONObject object, JSONReader.Feature ... features) {
        return object.to(this.type, features);
    }

    public static TypeReference<?> get(Type type) {
        return new TypeReference<Object>(type, true){};
    }

    private static Type canonicalize(Class<?> thisClass, ParameterizedType type, Type[] actualTypeArguments, int actualIndex) {
        Type rawType = type.getRawType();
        Type[] argTypes = type.getActualTypeArguments();
        for (int i2 = 0; i2 < argTypes.length; ++i2) {
            block7: {
                int ch;
                int dimension;
                block9: {
                    Class cls;
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block8: {
                                                if (argTypes[i2] instanceof TypeVariable && actualIndex < actualTypeArguments.length) {
                                                    argTypes[i2] = actualTypeArguments[actualIndex++];
                                                }
                                                if (!(argTypes[i2] instanceof GenericArrayType)) break block7;
                                                Type componentType = argTypes[i2];
                                                dimension = 0;
                                                while (componentType instanceof GenericArrayType) {
                                                    ++dimension;
                                                    componentType = ((GenericArrayType)componentType).getGenericComponentType();
                                                }
                                                if (!(componentType instanceof Class) || !(cls = (Class)componentType).isPrimitive()) break block7;
                                                if (cls != Integer.TYPE) break block8;
                                                ch = 73;
                                                break block9;
                                            }
                                            if (cls != Long.TYPE) break block10;
                                            ch = 74;
                                            break block9;
                                        }
                                        if (cls != Float.TYPE) break block11;
                                        ch = 70;
                                        break block9;
                                    }
                                    if (cls != Double.TYPE) break block12;
                                    ch = 68;
                                    break block9;
                                }
                                if (cls != Boolean.TYPE) break block13;
                                ch = 90;
                                break block9;
                            }
                            if (cls != Character.TYPE) break block14;
                            ch = 67;
                            break block9;
                        }
                        if (cls != Byte.TYPE) break block15;
                        ch = 66;
                        break block9;
                    }
                    if (cls != Short.TYPE) break block7;
                    ch = 83;
                }
                char[] chars = new char[dimension + 1];
                for (int j = 0; j < dimension; ++j) {
                    chars[j] = 91;
                }
                chars[dimension] = ch;
                String typeName = new String(chars);
                argTypes[i2] = TypeUtils.loadClass(typeName);
            }
            if (!(argTypes[i2] instanceof ParameterizedType)) continue;
            argTypes[i2] = TypeReference.canonicalize(thisClass, (ParameterizedType)argTypes[i2], actualTypeArguments, actualIndex);
        }
        return new ParameterizedTypeImpl(argTypes, thisClass, rawType);
    }

    public static Type of(Type ... types) {
        return new MultiType(types);
    }

    public static Type collectionType(Class<? extends Collection> collectionClass, Class<?> elementClass) {
        return new ParameterizedTypeImpl(collectionClass, elementClass);
    }

    public static Type arrayType(Class<?> elementType) {
        return new BeanUtils.GenericArrayTypeImpl(elementType);
    }

    public static Type mapType(Class<? extends Map> mapClass, Class<?> keyClass, Class<?> valueClass) {
        return new ParameterizedTypeImpl(mapClass, keyClass, valueClass);
    }

    public static Type parametricType(Class<?> parametrized, Class<?> ... parameterClasses) {
        return new ParameterizedTypeImpl(parametrized, parameterClasses);
    }

    public static Type parametricType(Class<?> parametrized, Type ... parameterTypes) {
        return new ParameterizedTypeImpl(parametrized, parameterTypes);
    }
}

