/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.reader.ByteArrayValueConsumer;
import com.alibaba.fastjson2.support.csv.ArrowUtils;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedWidthVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VariableWidthVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowByteArrayConsumer
implements ByteArrayValueConsumer {
    static final int CHUNK_SIZE = 1000000;
    final Schema schema;
    final int rowCount;
    final int varcharValueSize = 128;
    final ObjIntConsumer<VectorSchemaRoot> rootConsumer;
    final Consumer<Long[]> committer;
    BufferAllocator allocator = new RootAllocator();
    VectorSchemaRoot root;
    int blockSize;
    int blockRowIndex;
    int blockIndex = -1;
    int[] valueCapacities;

    public ArrowByteArrayConsumer(Schema schema, int rowCount, ObjIntConsumer<VectorSchemaRoot> rootConsumer, Consumer<Long[]> committer) {
        this.schema = schema;
        this.rowCount = rowCount;
        this.rootConsumer = rootConsumer;
        this.committer = committer;
        int blockSize = Math.min(1000000, rowCount);
        this.allocateNew(blockSize);
    }

    @Override
    public void afterRow(int row) {
        ++this.blockRowIndex;
        if (this.blockRowIndex == this.blockSize) {
            List fields = this.root.getSchema().getFields();
            for (int i2 = 0; i2 < fields.size(); ++i2) {
                FieldVector vector = this.root.getVector(i2);
                vector.setValueCount(this.blockSize);
            }
            this.rootConsumer.accept(this.root, this.blockIndex);
            this.root.close();
            if (row + 1 == this.rowCount) {
                if (this.committer != null) {
                    Long[] blocks = new Long[this.blockIndex + 1];
                    for (int i3 = 0; i3 <= this.blockIndex; ++i3) {
                        blocks[i3] = i3;
                    }
                    this.committer.accept(blocks);
                }
            } else if (row < this.rowCount) {
                int rest = this.rowCount - row - 1;
                int blockSize = Math.min(rest, 1000000);
                this.allocateNew(blockSize);
            }
        }
    }

    public void allocateNew(int blockSize) {
        this.root = VectorSchemaRoot.create((Schema)this.schema, (BufferAllocator)this.allocator);
        this.blockSize = blockSize;
        this.blockRowIndex = 0;
        this.root.setRowCount(blockSize);
        List fields = this.root.getSchema().getFields();
        int fieldsSize = fields.size();
        this.valueCapacities = new int[fieldsSize];
        for (int i2 = 0; i2 < fieldsSize; ++i2) {
            FieldVector vector = this.root.getVector(i2);
            if (vector instanceof FixedWidthVector) {
                ((FixedWidthVector)vector).allocateNew(blockSize);
                continue;
            }
            if (vector instanceof VariableWidthVector) {
                VariableWidthVector variableWidthVector = (VariableWidthVector)vector;
                variableWidthVector.allocateNew((long)(128 * blockSize), blockSize);
                this.valueCapacities[i2] = variableWidthVector.getValueCapacity();
                continue;
            }
            throw new JSONException("TODO");
        }
        ++this.blockIndex;
    }

    @Override
    public void accept(int row, int column, byte[] bytes, int off, int len, Charset charset) {
        if (column >= this.root.getSchema().getFields().size()) {
            return;
        }
        FieldVector vector = this.root.getVector(column);
        if (len == 0) {
            return;
        }
        row = this.blockRowIndex;
        if (vector instanceof IntVector) {
            int intValue = TypeUtils.parseInt(bytes, off, len);
            ((IntVector)vector).set(row, intValue);
            return;
        }
        if (vector instanceof BigIntVector) {
            long longValue = TypeUtils.parseLong(bytes, off, len);
            ((BigIntVector)vector).set(row, longValue);
            return;
        }
        if (vector instanceof VarCharVector) {
            VarCharVector charVector = (VarCharVector)vector;
            int valueCapacity = this.valueCapacities[column];
            int startOffset = charVector.getStartOffset(row);
            if (startOffset + len >= valueCapacity) {
                int newValueCapacity = valueCapacity + Math.max(len, 128 * this.rowCount);
                charVector.reallocDataBuffer((long)newValueCapacity);
                this.valueCapacities[column] = newValueCapacity;
            }
            charVector.set(row, bytes, off, len);
            return;
        }
        if (vector instanceof DecimalVector) {
            DecimalVector decimalVector = (DecimalVector)vector;
            ArrowUtils.setDecimal(decimalVector, row, bytes, off, len);
            return;
        }
        if (vector instanceof Decimal256Vector) {
            BigDecimal decimal = TypeUtils.parseBigDecimal(bytes, off, len);
            Decimal256Vector decimalVector = (Decimal256Vector)vector;
            int scale = decimalVector.getScale();
            if (decimal.scale() != scale) {
                decimal = decimal.setScale(scale);
            }
            decimalVector.set(row, decimal);
            return;
        }
        if (vector instanceof SmallIntVector) {
            int intValue = TypeUtils.parseInt(bytes, off, len);
            ((SmallIntVector)vector).set(row, intValue);
            return;
        }
        if (vector instanceof TinyIntVector) {
            int intValue = TypeUtils.parseInt(bytes, off, len);
            ((TinyIntVector)vector).set(row, intValue);
            return;
        }
        if (vector instanceof Float4Vector) {
            float floatValue = TypeUtils.parseFloat(bytes, off, len);
            ((Float4Vector)vector).set(row, floatValue);
            return;
        }
        if (vector instanceof Float8Vector) {
            float floatValue = TypeUtils.parseFloat(bytes, off, len);
            ((Float8Vector)vector).set(row, (double)floatValue);
            return;
        }
        if (vector instanceof DateMilliVector) {
            long millis = DateUtils.parseMillis(bytes, off, len, charset);
            ((DateMilliVector)vector).set(row, millis);
            return;
        }
        if (vector instanceof TimeStampMilliVector) {
            long millis = DateUtils.parseMillis(bytes, off, len, charset);
            ((TimeStampMilliVector)vector).set(row, millis);
            return;
        }
        if (vector instanceof BitVector) {
            Boolean value = TypeUtils.parseBoolean(bytes, off, len);
            if (value != null) {
                int intValue = value != false ? 1 : 0;
                ((BitVector)vector).set(row, intValue);
            }
            return;
        }
        throw new JSONException("TODO : " + vector.getClass().getName());
    }
}

