/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ByteArrayValueConsumer;
import com.alibaba.fastjson2.reader.CharArrayValueConsumer;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.stream.StreamReader;
import com.alibaba.fastjson2.support.csv.CSVReaderUTF16;
import com.alibaba.fastjson2.support.csv.CSVReaderUTF8;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public abstract class CSVReader<T>
extends StreamReader
implements Closeable {
    boolean quote;
    protected Class<T> objectClass;

    CSVReader() {
    }

    CSVReader(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public CSVReader(Type[] types) {
        super(types);
    }

    public void config(StreamReader.Feature ... features) {
        for (StreamReader.Feature feature : features) {
            this.features |= feature.mask;
        }
    }

    public void config(StreamReader.Feature feature, boolean state) {
        this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static <T> CSVReader<T> of(Reader reader, Class<T> objectClass) {
        return new CSVReaderUTF16<T>(reader, objectClass);
    }

    public static <T> CSVReader of(String str, Class<T> objectClass) {
        if (JDKUtils.JVM_VERSION > 8 && JDKUtils.STRING_VALUE != null) {
            try {
                int coder = JDKUtils.STRING_CODER.applyAsInt(str);
                if (coder == 0) {
                    byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
                    return new CSVReaderUTF8<T>(bytes, 0, bytes.length, StandardCharsets.ISO_8859_1, objectClass);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
        }
        char[] chars = JDKUtils.getCharArray(str);
        return new CSVReaderUTF16<T>(chars, 0, chars.length, objectClass);
    }

    public static <T> CSVReader<T> of(char[] chars, Class<T> objectClass) {
        return new CSVReaderUTF16<T>(chars, 0, chars.length, objectClass);
    }

    public static <T> CSVReader<T> of(byte[] utf8Bytes, Class<T> objectClass) {
        return CSVReader.of(utf8Bytes, 0, utf8Bytes.length, StandardCharsets.UTF_8, objectClass);
    }

    public static CSVReader of(File file, Type ... types) throws IOException {
        return new CSVReaderUTF8((InputStream)new FileInputStream(file), StandardCharsets.UTF_8, types);
    }

    public static CSVReader of(File file, ByteArrayValueConsumer consumer) throws IOException {
        return CSVReader.of(file, StandardCharsets.UTF_8, consumer);
    }

    public static CSVReader of(File file, Charset charset, ByteArrayValueConsumer consumer) throws IOException {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            throw new JSONException("not support charset : " + charset);
        }
        return new CSVReaderUTF8((InputStream)new FileInputStream(file), charset, consumer);
    }

    public static CSVReader of(File file, CharArrayValueConsumer consumer) throws IOException {
        return CSVReader.of(file, StandardCharsets.UTF_8, consumer);
    }

    public static CSVReader of(File file, Charset charset, CharArrayValueConsumer consumer) throws IOException {
        return new CSVReaderUTF16((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), consumer);
    }

    public static CSVReader of(File file, Charset charset, Type ... types) throws IOException {
        if (JDKUtils.JVM_VERSION == 8 || charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVReaderUTF16((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), types);
        }
        return new CSVReaderUTF8((InputStream)new FileInputStream(file), charset, types);
    }

    public static <T> CSVReader<T> of(File file, Class<T> objectClass) throws IOException {
        return CSVReader.of(file, StandardCharsets.UTF_8, objectClass);
    }

    public static <T> CSVReader<T> of(File file, Charset charset, Class<T> objectClass) throws IOException {
        if (JDKUtils.JVM_VERSION == 8 || charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVReaderUTF16<T>((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), objectClass);
        }
        return new CSVReaderUTF8<T>((InputStream)new FileInputStream(file), charset, objectClass);
    }

    public static CSVReader of(InputStream in, Type ... types) throws IOException {
        return CSVReader.of(in, StandardCharsets.UTF_8, types);
    }

    public static <T> CSVReader<T> of(InputStream in, Class<T> objectClass) {
        return CSVReader.of(in, StandardCharsets.UTF_8, objectClass);
    }

    public static <T> CSVReader<T> of(InputStream in, Charset charset, Class<T> objectClass) {
        if (JDKUtils.JVM_VERSION == 8 || charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVReaderUTF16<T>((Reader)new InputStreamReader(in, charset), objectClass);
        }
        return new CSVReaderUTF8<T>(in, charset, objectClass);
    }

    public static CSVReader of(InputStream in, Charset charset, Type ... types) throws IOException {
        if (JDKUtils.JVM_VERSION == 8 || charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVReaderUTF16((Reader)new InputStreamReader(in, charset), types);
        }
        return new CSVReaderUTF8(in, charset, types);
    }

    public static CSVReader of(Reader in, Type ... types) throws IOException {
        return new CSVReaderUTF16(in, types);
    }

    public static CSVReader of(String str, Type ... types) {
        if (JDKUtils.JVM_VERSION > 8 && JDKUtils.STRING_VALUE != null) {
            try {
                int coder = JDKUtils.STRING_CODER.applyAsInt(str);
                if (coder == 0) {
                    byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
                    return new CSVReaderUTF8(bytes, 0, bytes.length, types);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
        }
        char[] chars = JDKUtils.getCharArray(str);
        return new CSVReaderUTF16(chars, 0, chars.length, types);
    }

    public static CSVReader of(char[] chars, Type ... types) {
        return new CSVReaderUTF16(chars, 0, chars.length, types);
    }

    public static <T> CSVReader<T> of(char[] chars, int off, int len, CharArrayValueConsumer consumer) {
        return new CSVReaderUTF16(chars, off, len, consumer);
    }

    public static CSVReader of(byte[] utf8Bytes, Type ... types) {
        return new CSVReaderUTF8(utf8Bytes, 0, utf8Bytes.length, types);
    }

    public static CSVReader of(byte[] utf8Bytes, ByteArrayValueConsumer consumer) {
        return CSVReader.of(utf8Bytes, 0, utf8Bytes.length, StandardCharsets.UTF_8, consumer);
    }

    public static <T> CSVReader<T> of(byte[] utf8Bytes, int off, int len, Charset charset, ByteArrayValueConsumer consumer) {
        return new CSVReaderUTF8(utf8Bytes, off, len, charset, consumer);
    }

    public static <T> CSVReader<T> of(byte[] utf8Bytes, Charset charset, Class<T> objectClass) {
        return CSVReader.of(utf8Bytes, 0, utf8Bytes.length, charset, objectClass);
    }

    public static <T> CSVReader<T> of(byte[] utf8Bytes, int off, int len, Class<T> objectClass) {
        return new CSVReaderUTF8<T>(utf8Bytes, off, len, StandardCharsets.UTF_8, objectClass);
    }

    public static <T> CSVReader<T> of(byte[] utf8Bytes, int off, int len, Charset charset, Class<T> objectClass) {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            char[] chars = new char[len];
            int size = IOUtils.decodeUTF8(utf8Bytes, off, len, chars);
            return new CSVReaderUTF16<T>(chars, 0, size, objectClass);
        }
        return new CSVReaderUTF8<T>(utf8Bytes, off, len, charset, objectClass);
    }

    public static <T> CSVReader<T> of(char[] utf8Bytes, int off, int len, Class<T> objectClass) {
        return new CSVReaderUTF16<T>(utf8Bytes, off, len, objectClass);
    }

    public void skipLines(int lines) throws IOException {
        if (lines < 0) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < lines; ++i2) {
            this.seekLine();
        }
    }

    public List<String> readHeader() {
        String[] columns = (String[])this.readLineValues(true);
        if (this.objectClass != null) {
            ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
            boolean fieldBased = (this.features & JSONReader.Feature.FieldBased.mask) != 0L;
            Type[] types = new Type[columns.length];
            ObjectReader[] typeReaders = new ObjectReader[columns.length];
            FieldReader[] fieldReaders = new FieldReader[columns.length];
            for (int i2 = 0; i2 < columns.length; ++i2) {
                String column = columns[i2].trim();
                FieldReader fieldReader = provider.createFieldReader(this.objectClass, column, this.features);
                if (fieldReader != null) {
                    Class fieldClass;
                    fieldReaders[i2] = fieldReader;
                    Type fieldType = fieldReader.fieldType;
                    if (fieldType instanceof Class && (fieldClass = (Class)fieldType).isPrimitive()) {
                        fieldType = TypeUtils.nonePrimitive((Class)fieldType);
                    }
                    types[i2] = fieldType;
                    typeReaders[i2] = provider.getObjectReader(fieldType, fieldBased);
                    continue;
                }
                types[i2] = String.class;
            }
            this.types = types;
            this.typeReaders = typeReaders;
            this.fieldReaders = fieldReaders;
            this.objectCreator = provider.createObjectCreator(this.objectClass, this.features);
        }
        this.columns = Arrays.asList(columns);
        this.columnStats = new ArrayList();
        for (int i3 = 0; i3 < columns.length; ++i3) {
            this.columnStats.add(new StreamReader.ColumnStat(columns[i3]));
        }
        if (this.rowCount == 1) {
            this.rowCount = this.lineTerminated ? 0 : -1;
        }
        return this.columns;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getColumn(int columnIndex) {
        if (this.columns != null && columnIndex < this.columns.size()) {
            return (String)this.columns.get(columnIndex);
        }
        return null;
    }

    public Type getColumnType(int columnIndex) {
        if (this.types != null && columnIndex < this.types.length) {
            return this.types[columnIndex];
        }
        return null;
    }

    public List<StreamReader.ColumnStat> getColumnStats() {
        return this.columnStats;
    }

    public void readLineObjectAll(Consumer<T> consumer) {
        this.readLineObjectAll(true, consumer);
    }

    public abstract void readLineObjectAll(boolean var1, Consumer<T> var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public T readLineObject() {
        if (this.inputEnd) {
            return null;
        }
        if (this.fieldReaders == null) {
            ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
            if (this.objectClass == null) throw new JSONException("not support operation, objectClass is null");
            boolean fieldBased = (this.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = provider.getObjectReader(this.objectClass, fieldBased);
            if (!(objectReader instanceof ObjectReaderAdapter)) throw new JSONException("not support operation : " + this.objectClass);
            this.fieldReaders = ((ObjectReaderAdapter)objectReader).getFieldReaders();
            this.types = new Type[this.fieldReaders.length];
            for (int i2 = 0; i2 < this.types.length; ++i2) {
                this.types[i2] = this.fieldReaders[i2].fieldType;
            }
            this.objectCreator = provider.createObjectCreator(this.objectClass, this.features);
        }
        if (this.objectCreator == null) {
            throw new JSONException("not support operation, objectClass is null");
        }
        Object[] values = this.readLineValues(false);
        if (values == null) {
            return null;
        }
        if (this.fieldReaders == null) throw new JSONException("not support operation, objectClass is null");
        Object object = this.objectCreator.get();
        for (int i3 = 0; i3 < this.fieldReaders.length; ++i3) {
            FieldReader fieldReader = this.fieldReaders[i3];
            if (fieldReader == null) continue;
            fieldReader.accept(object, values[i3]);
        }
        return object;
    }

    public abstract boolean isEnd();

    public final Object[] readLineValues() {
        return this.readLineValues(false);
    }

    protected abstract Object[] readLineValues(boolean var1);

    public final String[] readLine() {
        return (String[])this.readLineValues(true);
    }

    public static int rowCount(String str, StreamReader.Feature ... features) {
        CSVReaderUTF8 state = new CSVReaderUTF8(features);
        state.rowCount(str, str.length());
        return state.rowCount();
    }

    public static int rowCount(byte[] bytes, StreamReader.Feature ... features) {
        CSVReaderUTF8 state = new CSVReaderUTF8(features);
        state.rowCount(bytes, bytes.length);
        return state.rowCount();
    }

    public static int rowCount(char[] chars, StreamReader.Feature ... features) {
        CSVReaderUTF16 state = new CSVReaderUTF16(features);
        state.rowCount(chars, chars.length);
        return state.rowCount();
    }

    public static int rowCount(File file) throws IOException {
        if (!file.exists()) {
            return -1;
        }
        try (FileInputStream in = new FileInputStream(file);){
            int n = CSVReader.rowCount(in);
            return n;
        }
    }

    public static int rowCount(InputStream in) throws IOException {
        int cnt;
        byte[] bytes = new byte[524288];
        CSVReaderUTF8 state = new CSVReaderUTF8(new StreamReader.Feature[0]);
        while ((cnt = in.read(bytes)) != -1) {
            state.rowCount(bytes, cnt);
        }
        return state.rowCount();
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int rowCount() {
        return this.lineTerminated ? this.rowCount : this.rowCount + 1;
    }

    void rowCount(String bytes, int length) {
        this.lineTerminated = false;
        for (int i2 = 0; i2 < length; ++i2) {
            char next;
            int n;
            char ch = bytes.charAt(i2);
            if (ch == '\"') {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i2 + 1;
                if (n >= length) break;
                next = bytes.charAt(n);
                if (next == '\"') {
                    ++i2;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == '\n') {
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                    this.lineSize = 0;
                }
                this.lineTerminated = i2 + 1 == length;
                continue;
            }
            if (ch == '\r') {
                this.lineTerminated = true;
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                n = i2 + 1;
                if (n >= length) break;
                next = bytes.charAt(n);
                if (next == '\n') {
                    ++i2;
                }
                this.lineTerminated = i2 + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    void rowCount(byte[] bytes, int length) {
        this.lineTerminated = false;
        for (int i2 = 0; i2 < length; ++i2) {
            byte next;
            int n;
            byte ch;
            if (i2 + 4 < length) {
                byte b0 = bytes[i2];
                byte b1 = bytes[i2 + 1];
                byte b2 = bytes[i2 + 2];
                byte b3 = bytes[i2 + 3];
                if (b0 > 34 && b1 > 34 && b2 > 34 && b3 > 34) {
                    this.lineSize += 4;
                    i2 += 3;
                    continue;
                }
            }
            if ((ch = bytes[i2]) == 34) {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i2 + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == 34) {
                    ++i2;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == 10) {
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                this.lineTerminated = i2 + 1 == length;
                continue;
            }
            if (ch == 13) {
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineTerminated = true;
                this.lineSize = 0;
                n = i2 + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == 10) {
                    ++i2;
                }
                this.lineTerminated = i2 + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    void rowCount(char[] bytes, int length) {
        this.lineTerminated = false;
        for (int i2 = 0; i2 < length; ++i2) {
            char next;
            int n;
            char ch;
            if (i2 + 4 < length) {
                char b0 = bytes[i2];
                char b1 = bytes[i2 + 1];
                char b2 = bytes[i2 + 2];
                char b3 = bytes[i2 + 3];
                if (b0 > '\"' && b1 > '\"' && b2 > '\"' && b3 > '\"') {
                    i2 += 3;
                    this.lineSize += 4;
                    continue;
                }
            }
            if ((ch = bytes[i2]) == '\"') {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i2 + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == '\"') {
                    ++i2;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == '\n') {
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                this.lineTerminated = i2 + 1 == length;
                continue;
            }
            if (ch == '\r' || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                if (this.lineSize > 0) {
                    ++this.rowCount;
                }
                this.lineTerminated = true;
                this.lineSize = 0;
                n = i2 + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == '\n') {
                    ++i2;
                }
                this.lineTerminated = i2 + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    protected Object error(int columnIndex, Exception e) {
        ++this.errorCount;
        ++this.getColumnStat((int)columnIndex).errors;
        if ((this.features & StreamReader.Feature.ErrorAsNull.mask) != 0L) {
            return null;
        }
        String message = "read csv error, line " + this.rowCount + ", column ";
        String column = null;
        if (this.columns != null && columnIndex < this.columns.size()) {
            column = (String)this.columns.get(columnIndex);
        }
        message = column != null && !column.isEmpty() ? message + column : message + columnIndex;
        throw new JSONException(message, e);
    }

    public StreamReader.ColumnStat getColumnStat(String name) {
        if (this.columnStats != null) {
            for (StreamReader.ColumnStat stat : this.columnStats) {
                if (!name.equals(stat.name)) continue;
                return stat;
            }
        }
        return null;
    }

    public StreamReader.ColumnStat getColumnStat(int i2) {
        if (this.columnStats == null) {
            this.columnStats = new ArrayList();
        }
        StreamReader.ColumnStat stat = null;
        if (i2 >= this.columnStats.size()) {
            for (int j = this.columnStats.size(); j <= i2; ++j) {
                String column = null;
                if (this.columns != null && i2 < this.columns.size()) {
                    column = (String)this.columns.get(i2);
                }
                stat = new StreamReader.ColumnStat(column);
                this.columnStats.add(stat);
            }
        } else {
            stat = (StreamReader.ColumnStat)this.columnStats.get(i2);
        }
        return stat;
    }

    public List<String[]> readLineAll() {
        String[] line;
        ArrayList<String[]> lines = new ArrayList<String[]>();
        while ((line = this.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public List<T> readLineObjectAll() {
        T object;
        ArrayList<T> objects = new ArrayList<T>();
        while ((object = this.readLineObject()) != null) {
            objects.add(object);
        }
        return objects;
    }

    public abstract void statAll();

    public abstract void statAll(int var1);

    public abstract void readAll();

    public abstract void readAll(int var1);
}

