/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.support.csv.CSVWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;

final class CSVWriterUTF8
extends CSVWriter {
    static final byte[] BYTES_TRUE = "true".getBytes();
    static final byte[] BYTES_FALSE = "false".getBytes();
    static final byte[] BYTES_LONG_MIN = "-9223372036854775808".getBytes();
    final OutputStream out;
    final Charset charset;
    byte[] bytes;

    CSVWriterUTF8(OutputStream out, Charset charset, ZoneId zoneId, CSVWriter.Feature ... features) {
        super(zoneId, features);
        this.out = out;
        this.charset = charset;
        this.bytes = new byte[65536];
    }

    protected void writeDirect(byte[] bytes, int off, int len) {
        try {
            this.out.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    @Override
    public void writeComma() {
        if (this.off + 1 == this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = 44;
    }

    @Override
    protected void writeQuote() {
        if (this.off + 1 == this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = 34;
    }

    @Override
    public void writeLine() {
        if (this.off + 1 == this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = 10;
    }

    @Override
    public void writeBoolean(boolean booleanValue) {
        byte[] valueBytes = booleanValue ? BYTES_TRUE : BYTES_FALSE;
        this.writeRaw(valueBytes);
    }

    @Override
    public void writeInt64(long longValue) {
        if (longValue == Long.MIN_VALUE) {
            this.writeRaw(BYTES_LONG_MIN);
            return;
        }
        int size = longValue < 0L ? IOUtils.stringSize(-longValue) + 1 : IOUtils.stringSize(longValue);
        int minCapacity = this.off + size;
        if (minCapacity - this.bytes.length > 0) {
            this.flush();
        }
        IOUtils.getChars(longValue, this.off + size, this.bytes);
        this.off += size;
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        if (this.off + 10 >= this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = (byte)(year / 1000 + 48);
        this.bytes[this.off++] = (byte)(year / 100 % 10 + 48);
        this.bytes[this.off++] = (byte)(year / 10 % 10 + 48);
        this.bytes[this.off++] = (byte)(year % 10 + 48);
        this.bytes[this.off++] = 45;
        this.bytes[this.off++] = (byte)(month / 10 + 48);
        this.bytes[this.off++] = (byte)(month % 10 + 48);
        this.bytes[this.off++] = 45;
        this.bytes[this.off++] = (byte)(dayOfMonth / 10 + 48);
        this.bytes[this.off++] = (byte)(dayOfMonth % 10 + 48);
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        if (this.off + 19 >= this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = (byte)(year / 1000 + 48);
        this.bytes[this.off++] = (byte)(year / 100 % 10 + 48);
        this.bytes[this.off++] = (byte)(year / 10 % 10 + 48);
        this.bytes[this.off++] = (byte)(year % 10 + 48);
        this.bytes[this.off++] = 45;
        this.bytes[this.off++] = (byte)(month / 10 + 48);
        this.bytes[this.off++] = (byte)(month % 10 + 48);
        this.bytes[this.off++] = 45;
        this.bytes[this.off++] = (byte)(dayOfMonth / 10 + 48);
        this.bytes[this.off++] = (byte)(dayOfMonth % 10 + 48);
        this.bytes[this.off++] = 32;
        this.bytes[this.off++] = (byte)(hour / 10 + 48);
        this.bytes[this.off++] = (byte)(hour % 10 + 48);
        this.bytes[this.off++] = 58;
        this.bytes[this.off++] = (byte)(minute / 10 + 48);
        this.bytes[this.off++] = (byte)(minute % 10 + 48);
        this.bytes[this.off++] = 58;
        this.bytes[this.off++] = (byte)(second / 10 + 48);
        this.bytes[this.off++] = (byte)(second % 10 + 48);
    }

    @Override
    public void writeString(String value) {
        String str = value;
        byte[] bytes = JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == JDKUtils.LATIN1.byteValue() ? JDKUtils.STRING_VALUE.apply(str) : str.getBytes(this.charset);
        this.writeString(bytes);
    }

    @Override
    public void writeInt32(int intValue) {
        if (intValue == Integer.MIN_VALUE) {
            this.writeRaw("-2147483648");
            return;
        }
        int size = intValue < 0 ? IOUtils.stringSize(-intValue) + 1 : IOUtils.stringSize(intValue);
        int minCapacity = this.off + size;
        if (minCapacity - this.bytes.length > 0) {
            this.flush();
        }
        IOUtils.getChars(intValue, this.off + size, this.bytes);
        this.off += size;
    }

    @Override
    public void writeDouble(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return;
        }
        int minCapacity = this.off + 24;
        if (minCapacity - this.bytes.length > 0) {
            this.flush();
        }
        int size = RyuDouble.toString(value, this.bytes, this.off);
        this.off += size;
    }

    @Override
    public void writeFloat(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return;
        }
        int minCapacity = this.off + 15;
        if (minCapacity - this.bytes.length > 0) {
            this.flush();
        }
        int size = RyuDouble.toString(value, this.bytes, this.off);
        this.off += size;
    }

    @Override
    public void flush() {
        try {
            this.out.write(this.bytes, 0, this.off);
            this.off = 0;
            this.out.flush();
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    @Override
    public void writeString(byte[] utf8) {
        byte ch;
        int i2;
        if (utf8 == null || utf8.length == 0) {
            return;
        }
        int len = utf8.length;
        int escapeCount = 0;
        boolean comma = false;
        if (utf8[0] == 34) {
            for (i2 = 0; i2 < len; ++i2) {
                ch = utf8[i2];
                if (ch != 34) continue;
                ++escapeCount;
            }
        } else {
            for (i2 = 0; i2 < len; ++i2) {
                ch = utf8[i2];
                if (ch == 44) {
                    comma = true;
                    continue;
                }
                if (ch != 34) continue;
                ++escapeCount;
            }
            if (!comma) {
                escapeCount = 0;
            }
        }
        if (escapeCount == 0) {
            this.writeRaw(utf8);
            return;
        }
        if (this.off + 2 + utf8.length + escapeCount >= this.bytes.length) {
            this.flush();
        }
        this.bytes[this.off++] = 34;
        for (i2 = 0; i2 < utf8.length; ++i2) {
            ch = utf8[i2];
            if (ch == 34) {
                this.bytes[this.off++] = 34;
                this.bytes[this.off++] = 34;
                continue;
            }
            this.bytes[this.off++] = ch;
        }
        this.bytes[this.off++] = 34;
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        if (value == null) {
            return;
        }
        String str = value.toString();
        int strlen = str.length();
        str.getBytes(0, strlen, this.bytes, this.off);
        this.off += strlen;
    }

    @Override
    public void writeDecimal(long unscaledVal, int scale) {
        if (scale == 0) {
            this.writeInt64(unscaledVal);
            return;
        }
        if (unscaledVal == Long.MIN_VALUE || scale >= 20) {
            this.writeDecimal(BigDecimal.valueOf(unscaledVal, scale));
            return;
        }
        int minCapacity = this.off + 24;
        if (minCapacity - this.bytes.length > 0) {
            this.flush();
        }
        int size = IOUtils.getDecimalChars(unscaledVal, scale, this.bytes, this.off);
        this.off += size;
    }

    protected void writeRaw(byte[] strBytes) {
        if (strBytes.length + this.off < this.bytes.length) {
            System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
            this.off += strBytes.length;
        } else {
            this.flush();
            if (strBytes.length >= this.bytes.length) {
                this.writeDirect(strBytes, 0, strBytes.length);
            } else {
                System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
                this.off += strBytes.length;
            }
        }
    }

    @Override
    protected void writeRaw(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        byte[] strBytes = str.getBytes(this.charset);
        if (strBytes.length + this.off < this.bytes.length) {
            System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
            this.off += strBytes.length;
        } else {
            this.flush();
            if (strBytes.length >= this.bytes.length) {
                this.writeDirect(strBytes, 0, strBytes.length);
            } else {
                System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
                this.off += strBytes.length;
            }
        }
    }

    @Override
    public void writeLocalDateTime(LocalDateTime ldt) {
        if (ldt == null) {
            return;
        }
        this.writeDateTime19(ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        int nanoValue = ldt.getNano();
        if (nanoValue == 0) {
            return;
        }
        int value = nanoValue % 1000000 == 0 ? nanoValue / 1000000 + 1000 : (nanoValue % 1000 == 0 ? nanoValue / 1000 + 1000000 : nanoValue + 1000000000);
        int off = this.off;
        this.writeInt32(value);
        this.bytes[off] = 46;
    }

    @Override
    public void close() throws IOException {
        if (this.off > 0) {
            this.flush();
        }
        this.out.close();
    }

    public String toString() {
        if (this.out instanceof ByteArrayOutputStream) {
            this.flush();
            byte[] strBytes = ((ByteArrayOutputStream)this.out).toByteArray();
            return new String(strBytes, StandardCharsets.UTF_8);
        }
        return super.toString();
    }
}

