/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterArrayFinal;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;

final class FieldWriterObjectArrayMethod<T>
extends FieldWriter<T> {
    final Type itemType;
    final Class itemClass;
    ObjectWriter itemObjectWriter;

    protected FieldWriterObjectArrayMethod(String fieldName, Type itemType, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Method method) {
        super(fieldName, ordinal, features, format, label, fieldType, fieldClass, null, method);
        this.itemType = itemType;
        this.itemClass = itemType instanceof Class ? (Class)itemType : TypeUtils.getMapping(itemType);
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public ObjectWriter getItemWriter(JSONWriter jsonWriter, Type itemType) {
        if (itemType == null || itemType == this.itemType) {
            if (this.itemObjectWriter != null) {
                return this.itemObjectWriter;
            }
            if (itemType == Float[].class) {
                if (this.decimalFormat != null) {
                    return new ObjectWriterArrayFinal(Float.class, this.decimalFormat);
                }
                return ObjectWriterArrayFinal.FLOAT_ARRAY;
            }
            if (itemType == Double[].class) {
                if (this.decimalFormat != null) {
                    return new ObjectWriterArrayFinal(Double.class, this.decimalFormat);
                }
                return ObjectWriterArrayFinal.DOUBLE_ARRAY;
            }
            if (itemType == BigDecimal[].class) {
                if (this.decimalFormat != null) {
                    return new ObjectWriterArrayFinal(BigDecimal.class, this.decimalFormat);
                }
                return ObjectWriterArrayFinal.DECIMAL_ARRAY;
            }
            this.itemObjectWriter = jsonWriter.getObjectWriter(this.itemType, this.itemClass);
            return this.itemObjectWriter;
        }
        return jsonWriter.getObjectWriter(itemType, null);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Object[] value = (Object[])this.getFieldValue((Object)object);
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeArrayNull();
                return true;
            }
            return false;
        }
        this.writeArray(jsonWriter, true, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Object[] value = (Object[])this.getFieldValue((Object)object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        this.writeArray(jsonWriter, false, value);
    }

    public void writeArray(JSONWriter jsonWriter, boolean writeFieldName, Object[] array) {
        String path;
        boolean refDetect;
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        if (writeFieldName) {
            this.writeFieldName(jsonWriter);
        }
        boolean previousItemRefDetect = refDetect = jsonWriter.isRefDetect();
        if (refDetect && (path = jsonWriter.setPath(this.fieldName, (Object)array)) != null) {
            jsonWriter.writeReference(path);
            return;
        }
        if (jsonWriter.jsonb) {
            Class<?> arrayClass = array.getClass();
            if (arrayClass != this.fieldClass) {
                jsonWriter.writeTypeName(TypeUtils.getTypeName(arrayClass));
            }
            int size = array.length;
            jsonWriter.startArray(size);
            for (int i2 = 0; i2 < size; ++i2) {
                String refPath;
                boolean itemRefDetect;
                Object item = array[i2];
                if (item == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                Class<?> itemClass = item.getClass();
                if (itemClass != previousClass) {
                    itemRefDetect = jsonWriter.isRefDetect();
                    previousObjectWriter = this.getItemWriter(jsonWriter, itemClass);
                    previousClass = itemClass;
                    if (itemRefDetect) {
                        itemRefDetect = !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                    }
                    previousItemRefDetect = itemRefDetect;
                } else {
                    itemRefDetect = previousItemRefDetect;
                }
                ObjectWriter itemObjectWriter = previousObjectWriter;
                if (itemRefDetect && (refPath = jsonWriter.setPath(i2, item)) != null) {
                    jsonWriter.writeReference(refPath);
                    jsonWriter.popPath(item);
                    continue;
                }
                itemObjectWriter.writeJSONB(jsonWriter, item, i2, this.itemType, this.features);
                if (!itemRefDetect) continue;
                jsonWriter.popPath(item);
            }
            if (refDetect) {
                jsonWriter.popPath(array);
            }
            return;
        }
        jsonWriter.startArray();
        for (int i3 = 0; i3 < array.length; ++i3) {
            ObjectWriter itemObjectWriter;
            Object item;
            if (i3 != 0) {
                jsonWriter.writeComma();
            }
            if ((item = array[i3]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
            } else {
                itemObjectWriter = this.getItemWriter(jsonWriter, itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
            }
            itemObjectWriter.write(jsonWriter, item);
        }
        jsonWriter.endArray();
    }
}

