/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Type;

final class ObjectWriterArray
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterArray INSTANCE = new ObjectWriterArray((Type)((Object)Object.class));
    final byte[] typeNameBytes;
    final long typeNameHash;
    final Type itemType;
    volatile ObjectWriter itemObjectWriter;

    public ObjectWriterArray(Type itemType) {
        this.itemType = itemType;
        if (itemType == Object.class) {
            this.typeNameBytes = JSONB.toBytes("[O");
            this.typeNameHash = Fnv.hashCode64("[0");
        } else {
            String typeName = '[' + TypeUtils.getTypeName((Class)itemType);
            this.typeNameBytes = JSONB.toBytes(typeName);
            this.typeNameHash = Fnv.hashCode64(typeName);
        }
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.jsonb) {
            this.writeJSONB(jsonWriter, object, fieldName, fieldType, features);
            return;
        }
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        boolean refDetect = jsonWriter.isRefDetect();
        Object[] list = (Object[])object;
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        jsonWriter.startArray();
        for (int i2 = 0; i2 < list.length; ++i2) {
            String refPath;
            ObjectWriter itemObjectWriter;
            Object item;
            if (i2 != 0) {
                jsonWriter.writeComma();
            }
            if ((item = list[i2]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
            } else {
                refDetect = jsonWriter.isRefDetect();
                itemObjectWriter = jsonWriter.getObjectWriter(itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
                if (refDetect) {
                    boolean bl = refDetect = !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                }
            }
            if (refDetect && (refPath = jsonWriter.setPath(i2, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.write(jsonWriter, item, i2, this.itemType, features);
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        boolean refDetect = jsonWriter.isRefDetect();
        Object[] list = (Object[])object;
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(this.typeNameBytes, this.typeNameHash);
        }
        jsonWriter.startArray(list.length);
        for (int i2 = 0; i2 < list.length; ++i2) {
            String refPath;
            ObjectWriter itemObjectWriter;
            Object item = list[i2];
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
            } else {
                refDetect = jsonWriter.isRefDetect();
                itemObjectWriter = jsonWriter.getObjectWriter(itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
                if (refDetect) {
                    boolean bl = refDetect = !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                }
            }
            if (refDetect && (refPath = jsonWriter.setPath(i2, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.writeJSONB(jsonWriter, item, i2, this.itemType, 0L);
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
    }
}

