/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.rabbitmq.tools.jsonrpc.JsonRpcException;
import com.rabbitmq.tools.jsonrpc.JsonRpcMapper;
import com.rabbitmq.tools.jsonrpc.JsonRpcMappingException;
import com.rabbitmq.tools.jsonrpc.ProcedureDescription;
import com.rabbitmq.tools.jsonrpc.ServiceDescription;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonJsonRpcMapper
implements JsonRpcMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonJsonRpcMapper.class);
    private final ObjectMapper mapper;

    public JacksonJsonRpcMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public JacksonJsonRpcMapper() {
        this(new ObjectMapper());
    }

    @Override
    public JsonRpcMapper.JsonRpcRequest parse(String requestBody, ServiceDescription description) {
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        String method = null;
        String version = null;
        ArrayList parameters = new ArrayList();
        Object id = null;
        try (JsonParser parser = jsonFactory.createParser(requestBody);){
            while (parser.nextToken() != null) {
                JsonToken token = parser.currentToken();
                if (token != JsonToken.FIELD_NAME) continue;
                String name = parser.currentName();
                token = parser.nextToken();
                if ("method".equals(name)) {
                    method = parser.getValueAsString();
                    continue;
                }
                if ("id".equals(name)) {
                    Object node = parser.readValueAsTree();
                    if (node instanceof ValueNode) {
                        ValueNode idNode = (ValueNode)node;
                        if (idNode.isNull()) {
                            id = null;
                            continue;
                        }
                        if (idNode.isTextual()) {
                            id = idNode.asText();
                            continue;
                        }
                        if (idNode.isNumber()) {
                            id = idNode.asLong();
                            continue;
                        }
                        LOGGER.warn("ID type not null, text, or number {}, ignoring", (Object)idNode);
                        continue;
                    }
                    LOGGER.warn("ID not a scalar value {}, ignoring", node);
                    continue;
                }
                if ("version".equals(name)) {
                    version = parser.getValueAsString();
                    continue;
                }
                if (!"params".equals(name)) continue;
                if (token == JsonToken.START_ARRAY) {
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        parameters.add(parser.readValueAsTree());
                    }
                    continue;
                }
                throw new IllegalStateException("Field params must be an array");
            }
        }
        catch (IOException e) {
            throw new JsonRpcMappingException("Error during JSON parsing", e);
        }
        if (method == null) {
            throw new IllegalArgumentException("Could not find method to invoke in request");
        }
        ArrayList<Object> convertedParameters = new ArrayList<Object>(parameters.size());
        if (!parameters.isEmpty()) {
            ProcedureDescription proc = description.getProcedure(method, parameters.size());
            Method internalMethod = proc.internal_getMethod();
            for (int i2 = 0; i2 < internalMethod.getParameterCount(); ++i2) {
                TreeNode parameterNode = (TreeNode)parameters.get(i2);
                try {
                    Class<?> parameterType = internalMethod.getParameterTypes()[i2];
                    Object value = this.convert(parameterNode, parameterType);
                    convertedParameters.add(value);
                    continue;
                }
                catch (IOException e) {
                    throw new JsonRpcMappingException("Error during parameter conversion", e);
                }
            }
        }
        return new JsonRpcMapper.JsonRpcRequest(id, version, method, convertedParameters.toArray());
    }

    @Override
    public JsonRpcMapper.JsonRpcResponse parse(String responseBody, Class<?> expectedReturnType) {
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        Object result = null;
        JsonRpcException exception = null;
        Map errorMap = null;
        try (JsonParser parser = jsonFactory.createParser(responseBody);){
            while (parser.nextToken() != null) {
                JsonToken token = parser.currentToken();
                if (token != JsonToken.FIELD_NAME) continue;
                String name = parser.currentName();
                if ("result".equals(name)) {
                    parser.nextToken();
                    if (expectedReturnType == Void.TYPE) {
                        result = null;
                        continue;
                    }
                    result = this.convert((TreeNode)parser.readValueAsTree(), expectedReturnType);
                    continue;
                }
                if (!"error".equals(name)) continue;
                errorMap = (Map)this.convert((TreeNode)parser.readValueAsTree(), Map.class);
                exception = new JsonRpcException(errorMap.toString(), (String)errorMap.get("name"), errorMap.get("code") == null ? 0 : (Integer)errorMap.get("code"), (String)errorMap.get("message"), errorMap);
            }
        }
        catch (IOException e) {
            throw new JsonRpcMappingException("Error during JSON parsing", e);
        }
        return new JsonRpcMapper.JsonRpcResponse(result, errorMap, exception);
    }

    @Override
    public String write(Object input) {
        try {
            return this.mapper.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            throw new JsonRpcMappingException("Error during JSON serialization", e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convert(TreeNode node, Class<?> expectedType) throws IOException {
        void var3_13;
        if (expectedType.isPrimitive()) {
            ValueNode valueNode = (ValueNode)node;
            if (expectedType == Boolean.TYPE) {
                Boolean bl = valueNode.booleanValue();
                return var3_13;
            } else if (expectedType == Character.TYPE) {
                Character c = Character.valueOf(valueNode.textValue().charAt(0));
                return var3_13;
            } else if (expectedType == Short.TYPE) {
                Short s = valueNode.shortValue();
                return var3_13;
            } else if (expectedType == Integer.TYPE) {
                Integer n = valueNode.intValue();
                return var3_13;
            } else if (expectedType == Long.TYPE) {
                Long l = valueNode.longValue();
                return var3_13;
            } else if (expectedType == Float.TYPE) {
                Float f = Float.valueOf(valueNode.floatValue());
                return var3_13;
            } else {
                if (expectedType != Double.TYPE) throw new IllegalArgumentException("Primitive type not supported: " + expectedType);
                Double d = valueNode.doubleValue();
            }
            return var3_13;
        } else {
            Object obj = this.mapper.readValue(node.traverse(), expectedType);
        }
        return var3_13;
    }
}

