/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl.internal;

import java.util.Arrays;
import org.apache.ibatis.ognl.ClassCacheInspector;
import org.apache.ibatis.ognl.internal.ClassCache;
import org.apache.ibatis.ognl.internal.Entry;

public class ClassCacheImpl
implements ClassCache {
    private static final int TABLE_SIZE = 512;
    private static final int TABLE_SIZE_MASK = 511;
    private Entry[] _table = new Entry[512];
    private ClassCacheInspector _classInspector;
    private int _size = 0;

    public void setClassInspector(ClassCacheInspector inspector) {
        this._classInspector = inspector;
    }

    public void clear() {
        for (int i2 = 0; i2 < this._table.length; ++i2) {
            this._table[i2] = null;
        }
        this._size = 0;
    }

    public int getSize() {
        return this._size;
    }

    public final Object get(Class key) {
        Object result = null;
        int i2 = key.hashCode() & 0x1FF;
        Entry entry = this._table[i2];
        while (entry != null) {
            if (entry.key == key) {
                result = entry.value;
                break;
            }
            entry = entry.next;
        }
        return result;
    }

    public final Object put(Class key, Object value) {
        if (this._classInspector != null && !this._classInspector.shouldCache(key)) {
            return value;
        }
        Object result = null;
        int i2 = key.hashCode() & 0x1FF;
        Entry entry = this._table[i2];
        if (entry == null) {
            this._table[i2] = new Entry(key, value);
            ++this._size;
        } else if (entry.key == key) {
            result = entry.value;
            entry.value = value;
        } else {
            while (true) {
                if (entry.key == key) {
                    result = entry.value;
                    entry.value = value;
                    break;
                }
                if (entry.next == null) {
                    entry.next = new Entry(key, value);
                    break;
                }
                entry = entry.next;
            }
        }
        return result;
    }

    public String toString() {
        return "ClassCacheImpl[_table=" + (this._table == null ? null : Arrays.asList(this._table)) + '\n' + ", _classInspector=" + this._classInspector + '\n' + ", _size=" + this._size + '\n' + ']';
    }
}

