/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Base64UrlNamingStrategy;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.rabbit.annotation.Argument;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerConfigurer;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.MultiMethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistrar;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.adapter.ReplyPostProcessor;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RabbitListenerAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
BeanClassLoaderAware,
EnvironmentAware,
SmartInitializingSingleton {
    public static final String DEFAULT_RABBIT_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "rabbitListenerContainerFactory";
    public static final String RABBIT_EMPTY_STRING_ARGUMENTS_PROPERTY = "spring.rabbitmq.emptyStringArguments";
    private static final ConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Set<String> emptyStringArguments = new HashSet<String>();
    private RabbitListenerEndpointRegistry endpointRegistry;
    private String defaultContainerFactoryBeanName = "rabbitListenerContainerFactory";
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;
    private final RabbitHandlerMethodFactoryAdapter messageHandlerMethodFactory = new RabbitHandlerMethodFactoryAdapter();
    private final RabbitListenerEndpointRegistrar registrar = new RabbitListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private final ConcurrentMap<Class<?>, TypeMetadata> typeCache = new ConcurrentHashMap();
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;
    private int increment;
    private Charset charset = StandardCharsets.UTF_8;

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public RabbitListenerAnnotationBeanPostProcessor() {
        this.emptyStringArguments.add("x-dead-letter-exchange");
    }

    public void setEndpointRegistry(RabbitListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.defaultContainerFactoryBeanName = containerFactoryBeanName;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableListableBeanFactory)beanFactory, null);
        }
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void setEnvironment(Environment environment2) {
        String property = environment2.getProperty(RABBIT_EMPTY_STRING_ARGUMENTS_PROPERTY, String.class);
        if (property != null) {
            this.emptyStringArguments.addAll(StringUtils.commaDelimitedListToSet(property));
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    @Override
    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map<String, RabbitListenerConfigurer> instances = ((ListableBeanFactory)this.beanFactory).getBeansOfType(RabbitListenerConfigurer.class);
            for (RabbitListenerConfigurer configurer : instances.values()) {
                configurer.configureRabbitListeners(this.registrar);
            }
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state(this.beanFactory != null, "BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = this.beanFactory.getBean("org.springframework.amqp.rabbit.config.internalRabbitListenerEndpointRegistry", RabbitListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.defaultContainerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.defaultContainerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
        this.typeCache.clear();
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        Class<?> targetClass = AopUtils.getTargetClass(bean2);
        TypeMetadata metadata = this.typeCache.computeIfAbsent(targetClass, this::buildMetadata);
        for (ListenerMethod lm : metadata.listenerMethods) {
            for (RabbitListener rabbitListener : lm.annotations) {
                this.processAmqpListener(rabbitListener, lm.method, bean2, beanName);
            }
        }
        if (metadata.handlerMethods.length > 0) {
            this.processMultiMethodListeners(metadata.classAnnotations, metadata.handlerMethods, bean2, beanName);
        }
        return bean2;
    }

    private TypeMetadata buildMetadata(Class<?> targetClass) {
        Collection<RabbitListener> classLevelListeners = this.findListenerAnnotations(targetClass);
        boolean hasClassLevelListeners = classLevelListeners.size() > 0;
        ArrayList methods = new ArrayList();
        ArrayList multiMethods = new ArrayList();
        ReflectionUtils.doWithMethods(targetClass, method -> {
            RabbitHandler rabbitHandler;
            Collection<RabbitListener> listenerAnnotations = this.findListenerAnnotations(method);
            if (listenerAnnotations.size() > 0) {
                methods.add(new ListenerMethod(method, listenerAnnotations.toArray(new RabbitListener[listenerAnnotations.size()])));
            }
            if (hasClassLevelListeners && (rabbitHandler = AnnotationUtils.findAnnotation(method, RabbitHandler.class)) != null) {
                multiMethods.add(method);
            }
        }, ReflectionUtils.USER_DECLARED_METHODS);
        if (methods.isEmpty() && multiMethods.isEmpty()) {
            return TypeMetadata.EMPTY;
        }
        return new TypeMetadata(methods.toArray(new ListenerMethod[methods.size()]), multiMethods.toArray(new Method[multiMethods.size()]), classLevelListeners.toArray(new RabbitListener[classLevelListeners.size()]));
    }

    private Collection<RabbitListener> findListenerAnnotations(AnnotatedElement element) {
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(RabbitListener.class).map(ann -> (RabbitListener)ann.synthesize()).collect(Collectors.toList());
    }

    private void processMultiMethodListeners(RabbitListener[] classLevelListeners, Method[] multiMethods, Object bean2, String beanName) {
        ArrayList<Method> checkedMethods = new ArrayList<Method>();
        Method defaultMethod = null;
        for (Method method : multiMethods) {
            Method checked = this.checkProxy(method, bean2);
            if (AnnotationUtils.findAnnotation(method, RabbitHandler.class).isDefault()) {
                Method toAssert = defaultMethod;
                Assert.state(toAssert == null, () -> "Only one @RabbitHandler can be marked 'isDefault', found: " + toAssert.toString() + " and " + method.toString());
                defaultMethod = checked;
            }
            checkedMethods.add(checked);
        }
        for (RabbitListener classLevelListener : classLevelListeners) {
            MultiMethodRabbitListenerEndpoint endpoint = new MultiMethodRabbitListenerEndpoint(checkedMethods, defaultMethod, bean2);
            this.processListener(endpoint, classLevelListener, bean2, bean2.getClass(), beanName);
        }
    }

    protected void processAmqpListener(RabbitListener rabbitListener, Method method, Object bean2, String beanName) {
        Method methodToUse = this.checkProxy(method, bean2);
        MethodRabbitListenerEndpoint endpoint = new MethodRabbitListenerEndpoint();
        endpoint.setMethod(methodToUse);
        this.processListener(endpoint, rabbitListener, bean2, methodToUse, beanName);
    }

    private Method checkProxy(Method methodArg, Object bean2) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy(bean2)) {
            try {
                Class<?>[] proxiedInterfaces;
                method = bean2.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class<?> iface : proxiedInterfaces = ((Advised)bean2).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@RabbitListener method '%s' found on bean target class '%s', but not found in any interface(s) for a bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    protected void processListener(MethodRabbitListenerEndpoint endpoint, RabbitListener rabbitListener, Object bean2, Object target, String beanName) {
        String autoStartup;
        Object resolvedGroup;
        endpoint.setBean(bean2);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(rabbitListener));
        endpoint.setQueueNames(this.resolveQueues(rabbitListener));
        endpoint.setConcurrency(this.resolveExpressionAsStringOrInteger(rabbitListener.concurrency(), "concurrency"));
        endpoint.setBeanFactory(this.beanFactory);
        endpoint.setReturnExceptions(this.resolveExpressionAsBoolean(rabbitListener.returnExceptions()));
        Object errorHandler = this.resolveExpression(rabbitListener.errorHandler());
        if (errorHandler instanceof RabbitListenerErrorHandler) {
            endpoint.setErrorHandler((RabbitListenerErrorHandler)errorHandler);
        } else if (errorHandler instanceof String) {
            String errorHandlerBeanName = (String)errorHandler;
            if (StringUtils.hasText(errorHandlerBeanName)) {
                endpoint.setErrorHandler(this.beanFactory.getBean(errorHandlerBeanName, RabbitListenerErrorHandler.class));
            }
        } else {
            throw new IllegalStateException("error handler mut be a bean name or RabbitListenerErrorHandler, not a " + errorHandler.getClass().toString());
        }
        String group = rabbitListener.group();
        if (StringUtils.hasText(group) && (resolvedGroup = this.resolveExpression(group)) instanceof String) {
            endpoint.setGroup((String)resolvedGroup);
        }
        if (StringUtils.hasText(autoStartup = rabbitListener.autoStartup())) {
            endpoint.setAutoStartup(this.resolveExpressionAsBoolean(autoStartup));
        }
        endpoint.setExclusive(rabbitListener.exclusive());
        String priority = this.resolve(rabbitListener.priority());
        if (StringUtils.hasText(priority)) {
            try {
                endpoint.setPriority(Integer.valueOf(priority));
            }
            catch (NumberFormatException ex) {
                throw new BeanInitializationException("Invalid priority value for " + rabbitListener + " (must be an integer)", ex);
            }
        }
        this.resolveExecutor(endpoint, rabbitListener, target, beanName);
        this.resolveAdmin(endpoint, rabbitListener, target);
        this.resolveAckMode(endpoint, rabbitListener);
        this.resolvePostProcessor(endpoint, rabbitListener, target, beanName);
        RabbitListenerContainerFactory<?> factory = this.resolveContainerFactory(rabbitListener, target, beanName);
        this.registrar.registerEndpoint(endpoint, factory);
    }

    private void resolveAckMode(MethodRabbitListenerEndpoint endpoint, RabbitListener rabbitListener) {
        String ackModeAttr = rabbitListener.ackMode();
        if (StringUtils.hasText(ackModeAttr)) {
            Object ackMode = this.resolveExpression(ackModeAttr);
            if (ackMode instanceof String) {
                endpoint.setAckMode(AcknowledgeMode.valueOf((String)ackMode));
            } else if (ackMode instanceof AcknowledgeMode) {
                endpoint.setAckMode((AcknowledgeMode)((Object)ackMode));
            } else {
                Assert.isNull(ackMode, "ackMode must resolve to a String or AcknowledgeMode");
            }
        }
    }

    private void resolveAdmin(MethodRabbitListenerEndpoint endpoint, RabbitListener rabbitListener, Object adminTarget) {
        String rabbitAdmin = this.resolve(rabbitListener.admin());
        if (StringUtils.hasText(rabbitAdmin)) {
            Assert.state(this.beanFactory != null, "BeanFactory must be set to resolve RabbitAdmin by bean name");
            try {
                endpoint.setAdmin(this.beanFactory.getBean(rabbitAdmin, RabbitAdmin.class));
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register rabbit listener endpoint on [" + adminTarget + "], no " + RabbitAdmin.class.getSimpleName() + " with id '" + rabbitAdmin + "' was found in the application context", ex);
            }
        }
    }

    @Nullable
    private RabbitListenerContainerFactory<?> resolveContainerFactory(RabbitListener rabbitListener, Object factoryTarget, String beanName) {
        RabbitListenerContainerFactory factory = null;
        String containerFactoryBeanName = this.resolve(rabbitListener.containerFactory());
        if (StringUtils.hasText(containerFactoryBeanName)) {
            this.assertBeanFactory();
            try {
                factory = this.beanFactory.getBean(containerFactoryBeanName, RabbitListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(factoryTarget, beanName, containerFactoryBeanName, RabbitListenerContainerFactory.class), ex);
            }
        }
        return factory;
    }

    private void resolveExecutor(MethodRabbitListenerEndpoint endpoint, RabbitListener rabbitListener, Object execTarget, String beanName) {
        String execBeanName = this.resolve(rabbitListener.executor());
        if (StringUtils.hasText(execBeanName)) {
            this.assertBeanFactory();
            try {
                endpoint.setTaskExecutor(this.beanFactory.getBean(execBeanName, TaskExecutor.class));
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(execTarget, beanName, execBeanName, TaskExecutor.class), ex);
            }
        }
    }

    private void resolvePostProcessor(MethodRabbitListenerEndpoint endpoint, RabbitListener rabbitListener, Object target, String beanName) {
        String ppBeanName = this.resolve(rabbitListener.replyPostProcessor());
        if (StringUtils.hasText(ppBeanName)) {
            this.assertBeanFactory();
            try {
                endpoint.setReplyPostProcessor(this.beanFactory.getBean(ppBeanName, ReplyPostProcessor.class));
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(target, beanName, ppBeanName, ReplyPostProcessor.class), ex);
            }
        }
    }

    protected void assertBeanFactory() {
        Assert.state(this.beanFactory != null, "BeanFactory must be set to obtain container factory by bean name");
    }

    protected String noBeanFoundMessage(Object target, String listenerBeanName, String requestedBeanName, Class<?> expectedClass) {
        return "Could not register rabbit listener endpoint on [" + target + "] for bean " + listenerBeanName + ", no '" + expectedClass.getSimpleName() + "' with id '" + requestedBeanName + "' was found in the application context";
    }

    private String getEndpointId(RabbitListener rabbitListener) {
        if (StringUtils.hasText(rabbitListener.id())) {
            return this.resolve(rabbitListener.id());
        }
        return "org.springframework.amqp.rabbit.RabbitListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    private String[] resolveQueues(RabbitListener rabbitListener) {
        int i2;
        String[] queues = rabbitListener.queues();
        QueueBinding[] bindings = rabbitListener.bindings();
        Queue[] queuesToDeclare = rabbitListener.queuesToDeclare();
        ArrayList<String> result = new ArrayList<String>();
        if (queues.length > 0) {
            for (i2 = 0; i2 < queues.length; ++i2) {
                this.resolveAsString(this.resolveExpression(queues[i2]), result, true, "queues");
            }
        }
        if (queuesToDeclare.length > 0) {
            if (queues.length > 0) {
                throw new BeanInitializationException("@RabbitListener can have only one of 'queues', 'queuesToDeclare', or 'bindings'");
            }
            for (i2 = 0; i2 < queuesToDeclare.length; ++i2) {
                result.add(this.declareQueue(queuesToDeclare[i2]));
            }
        }
        if (bindings.length > 0) {
            if (queues.length > 0 || queuesToDeclare.length > 0) {
                throw new BeanInitializationException("@RabbitListener can have only one of 'queues', 'queuesToDeclare', or 'bindings'");
            }
            return this.registerBeansForDeclaration(rabbitListener);
        }
        return result.toArray(new String[result.size()]);
    }

    private void resolveAsString(Object resolvedValue, List<String> result, boolean canBeQueue, String what) {
        List<String> resolvedValueToUse = resolvedValue;
        if (resolvedValue instanceof String[]) {
            resolvedValueToUse = Arrays.asList((String[])resolvedValue);
        }
        if (canBeQueue && resolvedValueToUse instanceof org.springframework.amqp.core.Queue) {
            result.add(((org.springframework.amqp.core.Queue)((Object)resolvedValueToUse)).getName());
        } else if (resolvedValueToUse instanceof String) {
            result.add((String)((Object)resolvedValueToUse));
        } else if (resolvedValueToUse instanceof Iterable) {
            for (Object object : (Iterable)resolvedValueToUse) {
                this.resolveAsString(object, result, canBeQueue, what);
            }
        } else {
            throw new IllegalArgumentException(String.format("@RabbitListener." + what + " can't resolve '%s' as a String[] or a String " + (canBeQueue ? "or a Queue" : ""), resolvedValue));
        }
    }

    private String[] registerBeansForDeclaration(RabbitListener rabbitListener) {
        ArrayList<String> queues = new ArrayList<String>();
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            for (QueueBinding binding : rabbitListener.bindings()) {
                String queueName = this.declareQueue(binding.value());
                queues.add(queueName);
                this.declareExchangeAndBinding(binding, queueName);
            }
        }
        return queues.toArray(new String[queues.size()]);
    }

    private String declareQueue(Queue bindingQueue) {
        String queueName = (String)this.resolveExpression(bindingQueue.value());
        boolean isAnonymous = false;
        if (!StringUtils.hasText(queueName)) {
            queueName = Base64UrlNamingStrategy.DEFAULT.generateName();
            isAnonymous = true;
        }
        org.springframework.amqp.core.Queue queue = new org.springframework.amqp.core.Queue(queueName, this.resolveExpressionAsBoolean(bindingQueue.durable(), !isAnonymous), this.resolveExpressionAsBoolean(bindingQueue.exclusive(), isAnonymous), this.resolveExpressionAsBoolean(bindingQueue.autoDelete(), isAnonymous), this.resolveArguments(bindingQueue.arguments()));
        queue.setIgnoreDeclarationExceptions(this.resolveExpressionAsBoolean(bindingQueue.ignoreDeclarationExceptions()));
        ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(queueName + ++this.increment, queue);
        if (bindingQueue.admins().length > 0) {
            queue.setAdminsThatShouldDeclare(bindingQueue.admins());
        }
        queue.setShouldDeclare(this.resolveExpressionAsBoolean(bindingQueue.declare()));
        return queueName;
    }

    private void declareExchangeAndBinding(QueueBinding binding, String queueName) {
        Map<String, Object> arguments;
        Exchange bindingExchange = binding.exchange();
        String exchangeName = this.resolveExpressionAsString(bindingExchange.value(), "@Exchange.exchange");
        Assert.isTrue(StringUtils.hasText(exchangeName), () -> "Exchange name required; binding queue " + queueName);
        String exchangeType = this.resolveExpressionAsString(bindingExchange.type(), "@Exchange.type");
        ExchangeBuilder exchangeBuilder = new ExchangeBuilder(exchangeName, exchangeType);
        if (this.resolveExpressionAsBoolean(bindingExchange.autoDelete())) {
            exchangeBuilder.autoDelete();
        }
        if (this.resolveExpressionAsBoolean(bindingExchange.internal())) {
            exchangeBuilder.internal();
        }
        if (this.resolveExpressionAsBoolean(bindingExchange.delayed())) {
            exchangeBuilder.delayed();
        }
        if (this.resolveExpressionAsBoolean(bindingExchange.ignoreDeclarationExceptions())) {
            exchangeBuilder.ignoreDeclarationExceptions();
        }
        if (!this.resolveExpressionAsBoolean(bindingExchange.declare())) {
            exchangeBuilder.suppressDeclaration();
        }
        if (bindingExchange.admins().length > 0) {
            exchangeBuilder.admins(bindingExchange.admins());
        }
        if (!CollectionUtils.isEmpty(arguments = this.resolveArguments(bindingExchange.arguments()))) {
            exchangeBuilder.withArguments(arguments);
        }
        Object exchange2 = exchangeBuilder.durable(this.resolveExpressionAsBoolean(bindingExchange.durable())).build();
        ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(exchangeName + ++this.increment, exchange2);
        this.registerBindings(binding, queueName, exchangeName, exchangeType);
    }

    private void registerBindings(QueueBinding binding, String queueName, String exchangeName, String exchangeType) {
        List<String> routingKeys;
        if (exchangeType.equals("fanout") || binding.key().length == 0) {
            routingKeys = Collections.singletonList("");
        } else {
            int length = binding.key().length;
            routingKeys = new ArrayList<String>();
            for (int i2 = 0; i2 < length; ++i2) {
                this.resolveAsString(this.resolveExpression(binding.key()[i2]), routingKeys, false, "@QueueBinding.key");
            }
        }
        Map<String, Object> bindingArguments = this.resolveArguments(binding.arguments());
        boolean bindingIgnoreExceptions = this.resolveExpressionAsBoolean(binding.ignoreDeclarationExceptions());
        boolean declare = this.resolveExpressionAsBoolean(binding.declare());
        for (String routingKey : routingKeys) {
            Binding actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, routingKey, bindingArguments);
            actualBinding.setIgnoreDeclarationExceptions(bindingIgnoreExceptions);
            actualBinding.setShouldDeclare(declare);
            if (binding.admins().length > 0) {
                actualBinding.setAdminsThatShouldDeclare(binding.admins());
            }
            ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(exchangeName + "." + queueName + ++this.increment, actualBinding);
        }
    }

    private Map<String, Object> resolveArguments(Argument[] arguments) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Argument arg : arguments) {
            String key = this.resolveExpressionAsString(arg.name(), "@Argument.name");
            if (StringUtils.hasText(key)) {
                String typeName;
                Class<?> typeClass;
                Object value = this.resolveExpression(arg.value());
                Object type = this.resolveExpression(arg.type());
                if (type instanceof Class) {
                    typeClass = (Class<?>)type;
                    typeName = typeClass.getName();
                } else {
                    Assert.isTrue(type instanceof String, () -> "Type must resolve to a Class or String, but resolved to [" + type.getClass().getName() + "]");
                    typeName = (String)type;
                    try {
                        typeClass = ClassUtils.forName(typeName, this.beanClassLoader);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Could not load class", e);
                    }
                }
                this.addToMap(map, key, value, typeClass, typeName);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("@Argument ignored because the name resolved to an empty String");
        }
        return map.size() < 1 ? null : map;
    }

    private void addToMap(Map<String, Object> map, String key, Object value, Class<?> typeClass, String typeName) {
        if (value.getClass().getName().equals(typeName)) {
            if (typeClass.equals(String.class) && !StringUtils.hasText((String)value)) {
                this.putEmpty(map, key);
            } else {
                map.put(key, value);
            }
        } else if (value instanceof String && !StringUtils.hasText((String)value)) {
            this.putEmpty(map, key);
        } else if (CONVERSION_SERVICE.canConvert(value.getClass(), typeClass)) {
            map.put(key, CONVERSION_SERVICE.convert(value, typeClass));
        } else {
            throw new IllegalStateException("Cannot convert from " + value.getClass().getName() + " to " + typeName);
        }
    }

    private void putEmpty(Map<String, Object> map, String key) {
        if (this.emptyStringArguments.contains(key)) {
            map.put(key, "");
        } else {
            map.put(key, null);
        }
    }

    private boolean resolveExpressionAsBoolean(String value) {
        return this.resolveExpressionAsBoolean(value, false);
    }

    private boolean resolveExpressionAsBoolean(String value, boolean defaultValue) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof Boolean) {
            return (Boolean)resolved;
        }
        if (resolved instanceof String) {
            String s = (String)resolved;
            return StringUtils.hasText(s) ? Boolean.parseBoolean(s) : defaultValue;
        }
        return defaultValue;
    }

    private String resolveExpressionAsString(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        throw new IllegalStateException("The [" + attribute + "] must resolve to a String. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
    }

    private String resolveExpressionAsStringOrInteger(String value, String attribute) {
        if (!StringUtils.hasLength(value)) {
            return null;
        }
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        if (resolved instanceof Integer) {
            return resolved.toString();
        }
        throw new IllegalStateException("The [" + attribute + "] must resolve to a String. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
    }

    private Object resolveExpression(String value) {
        String resolvedValue = this.resolve(value);
        return this.resolver.evaluate(resolvedValue, this.expressionContext);
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private static class BytesToStringConverter
    implements Converter<byte[], String> {
        private final Charset charset;

        BytesToStringConverter(Charset charset) {
            this.charset = charset;
        }

        @Override
        public String convert(byte[] source) {
            return new String(source, this.charset);
        }
    }

    private static class ListenerMethod {
        final Method method;
        final RabbitListener[] annotations;

        ListenerMethod(Method method, RabbitListener[] annotations) {
            this.method = method;
            this.annotations = annotations;
        }
    }

    private static class TypeMetadata {
        final ListenerMethod[] listenerMethods;
        final Method[] handlerMethods;
        final RabbitListener[] classAnnotations;
        static final TypeMetadata EMPTY = new TypeMetadata();

        private TypeMetadata() {
            this.listenerMethods = new ListenerMethod[0];
            this.handlerMethods = new Method[0];
            this.classAnnotations = new RabbitListener[0];
        }

        TypeMetadata(ListenerMethod[] methods, Method[] multiMethods, RabbitListener[] classLevelListeners) {
            this.listenerMethods = methods;
            this.handlerMethods = multiMethods;
            this.classAnnotations = classLevelListeners;
        }
    }

    private class RabbitHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory factory;

        RabbitHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory rabbitHandlerMethodFactory1) {
            this.factory = rabbitHandlerMethodFactory1;
        }

        @Override
        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean2, Method method) {
            return this.getFactory().createInvocableHandlerMethod(bean2, method);
        }

        private MessageHandlerMethodFactory getFactory() {
            if (this.factory == null) {
                this.factory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.factory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            defaultFactory.setBeanFactory(RabbitListenerAnnotationBeanPostProcessor.this.beanFactory);
            DefaultConversionService conversionService = new DefaultConversionService();
            conversionService.addConverter(new BytesToStringConverter(RabbitListenerAnnotationBeanPostProcessor.this.charset));
            defaultFactory.setConversionService(conversionService);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

