/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.AmqpMessageReturnedException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.ReceiveAndReplyCallback;
import org.springframework.amqp.core.ReceiveAndReplyMessageCallback;
import org.springframework.amqp.core.ReplyToAddressCallback;
import org.springframework.amqp.rabbit.connection.AbstractRoutingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.ClosingRecoveryListener;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.connection.PendingConfirm;
import org.springframework.amqp.rabbit.connection.PublisherCallbackChannel;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.ConsumeOkNotReceivedException;
import org.springframework.amqp.rabbit.core.CorrelationDataPostProcessor;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.DirectReplyToMessageListenerContainer;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.Delivery;
import org.springframework.amqp.rabbit.support.ListenerContainerAware;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.rabbit.support.ValueExpression;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.amqp.support.postprocessor.MessagePostProcessorUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import org.springframework.util.StringUtils;

public class RabbitTemplate
extends RabbitAccessor
implements BeanFactoryAware,
RabbitOperations,
MessageListener,
ListenerContainerAware,
PublisherCallbackChannel.Listener,
BeanNameAware,
DisposableBean {
    private static final String UNCHECKED = "unchecked";
    private static final String RETURN_CORRELATION_KEY = "spring_request_return_correlation";
    private static final String DEFAULT_EXCHANGE = "";
    private static final String DEFAULT_ROUTING_KEY = "";
    private static final long DEFAULT_REPLY_TIMEOUT = 5000L;
    private static final long DEFAULT_CONSUME_TIMEOUT = 10000L;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final ThreadLocal<Channel> dedicatedChannels = new ThreadLocal();
    private final AtomicInteger activeTemplateCallbacks = new AtomicInteger();
    private final ConcurrentMap<Channel, RabbitTemplate> publisherConfirmChannels = new ConcurrentHashMap<Channel, RabbitTemplate>();
    private final Map<String, PendingReply> replyHolder = new ConcurrentHashMap<String, PendingReply>();
    private final String uuid = UUID.randomUUID().toString();
    private final AtomicInteger messageTagProvider = new AtomicInteger();
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private final ReplyToAddressCallback<?> defaultReplyToAddressCallback = (request, reply) -> this.getReplyToAddress(request);
    private final Map<ConnectionFactory, DirectReplyToMessageListenerContainer> directReplyToContainers = new HashMap<ConnectionFactory, DirectReplyToMessageListenerContainer>();
    private final AtomicInteger containerInstance = new AtomicInteger();
    private String exchange = "";
    private String routingKey = "";
    private String defaultReceiveQueue;
    private long receiveTimeout = 0L;
    private long replyTimeout = 5000L;
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private String encoding = "UTF-8";
    private String replyAddress;
    @Nullable
    private ConfirmCallback confirmCallback;
    private ReturnCallback returnCallback;
    private Expression mandatoryExpression = new ValueExpression<Boolean>(false);
    private String correlationKey = null;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<?> recoveryCallback;
    private Expression sendConnectionFactorySelectorExpression;
    private Expression receiveConnectionFactorySelectorExpression;
    private boolean useDirectReplyToContainer = true;
    private boolean useTemporaryReplyQueues;
    private Collection<MessagePostProcessor> beforePublishPostProcessors;
    private Collection<MessagePostProcessor> afterReceivePostProcessors;
    private CorrelationDataPostProcessor correlationDataPostProcessor;
    private Expression userIdExpression;
    private String beanName = "rabbitTemplate";
    private Executor taskExecutor;
    private boolean userCorrelationId;
    private boolean usePublisherConnection;
    private boolean noLocalReplyConsumer;
    private ErrorHandler replyErrorHandler;
    private volatile Boolean confirmsOrReturnsCapable;
    private volatile boolean publisherConfirms;
    private volatile boolean usingFastReplyTo;
    private volatile boolean evaluatedFastReplyTo;
    private volatile boolean isListener;

    public RabbitTemplate() {
        this.initDefaultStrategies();
    }

    public RabbitTemplate(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter(new SimpleMessageConverter());
    }

    public void setExchange(@Nullable String exchange2) {
        this.exchange = exchange2 != null ? exchange2 : "";
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setDefaultReceiveQueue(String queue) {
        this.defaultReceiveQueue = queue;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
        this.evaluatedFastReplyTo = false;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        Assert.notNull((Object)messagePropertiesConverter, "messagePropertiesConverter must not be null");
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    protected MessagePropertiesConverter getMessagePropertiesConverter() {
        return this.messagePropertiesConverter;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setConfirmCallback(ConfirmCallback confirmCallback) {
        Assert.state(this.confirmCallback == null || this.confirmCallback == confirmCallback, "Only one ConfirmCallback is supported by each RabbitTemplate");
        this.confirmCallback = confirmCallback;
    }

    public void setReturnCallback(ReturnCallback returnCallback) {
        Assert.state(this.returnCallback == null || this.returnCallback == returnCallback, "Only one ReturnCallback is supported by each RabbitTemplate");
        this.returnCallback = returnCallback;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatoryExpression = new ValueExpression<Boolean>(mandatory);
    }

    public void setMandatoryExpression(Expression mandatoryExpression) {
        Assert.notNull((Object)mandatoryExpression, "'mandatoryExpression' must not be null");
        this.mandatoryExpression = mandatoryExpression;
    }

    public void setMandatoryExpressionString(String mandatoryExpression) {
        Assert.notNull((Object)mandatoryExpression, "'mandatoryExpression' must not be null");
        this.mandatoryExpression = PARSER.parseExpression(mandatoryExpression);
    }

    public void setSendConnectionFactorySelectorExpression(Expression sendConnectionFactorySelectorExpression) {
        this.sendConnectionFactorySelectorExpression = sendConnectionFactorySelectorExpression;
    }

    public void setReceiveConnectionFactorySelectorExpression(Expression receiveConnectionFactorySelectorExpression) {
        this.receiveConnectionFactorySelectorExpression = receiveConnectionFactorySelectorExpression;
    }

    public void setCorrelationKey(String correlationKey) {
        Assert.hasText(correlationKey, "'correlationKey' must not be null or empty");
        if (!correlationKey.trim().equals("correlationId")) {
            this.correlationKey = correlationKey.trim();
        }
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<?> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.evaluationContext.setBeanResolver(new BeanFactoryResolver(beanFactory));
        this.evaluationContext.addPropertyAccessor(new MapAccessor());
    }

    public void setBeforePublishPostProcessors(MessagePostProcessor ... beforePublishPostProcessors) {
        Assert.notNull((Object)beforePublishPostProcessors, "'beforePublishPostProcessors' cannot be null");
        Assert.noNullElements((Object[])beforePublishPostProcessors, "'beforePublishPostProcessors' cannot have null elements");
        this.beforePublishPostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(beforePublishPostProcessors));
    }

    public void addBeforePublishPostProcessors(MessagePostProcessor ... beforePublishPostProcessors) {
        Assert.notNull((Object)beforePublishPostProcessors, "'beforePublishPostProcessors' cannot be null");
        if (this.beforePublishPostProcessors == null) {
            this.beforePublishPostProcessors = new ArrayList<MessagePostProcessor>();
        }
        this.beforePublishPostProcessors.addAll(Arrays.asList(beforePublishPostProcessors));
        this.beforePublishPostProcessors = MessagePostProcessorUtils.sort(this.beforePublishPostProcessors);
    }

    public boolean removeBeforePublishPostProcessor(MessagePostProcessor beforePublishPostProcessor) {
        Assert.notNull((Object)beforePublishPostProcessor, "'beforePublishPostProcessor' cannot be null");
        if (this.beforePublishPostProcessors != null) {
            return this.beforePublishPostProcessors.remove(beforePublishPostProcessor);
        }
        return false;
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        Assert.notNull((Object)afterReceivePostProcessors, "'afterReceivePostProcessors' cannot be null");
        Assert.noNullElements((Object[])afterReceivePostProcessors, "'afterReceivePostProcessors' cannot have null elements");
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(afterReceivePostProcessors));
    }

    @Nullable
    public Collection<MessagePostProcessor> getAfterReceivePostProcessors() {
        return this.afterReceivePostProcessors != null ? Collections.unmodifiableCollection(this.afterReceivePostProcessors) : null;
    }

    public void addAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        Assert.notNull((Object)afterReceivePostProcessors, "'afterReceivePostProcessors' cannot be null");
        if (this.afterReceivePostProcessors == null) {
            this.afterReceivePostProcessors = new ArrayList<MessagePostProcessor>();
        }
        this.afterReceivePostProcessors.addAll(Arrays.asList(afterReceivePostProcessors));
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(this.afterReceivePostProcessors);
    }

    public boolean removeAfterReceivePostProcessor(MessagePostProcessor afterReceivePostProcessor) {
        Assert.notNull((Object)afterReceivePostProcessor, "'afterReceivePostProcessor' cannot be null");
        if (this.afterReceivePostProcessors != null) {
            return this.afterReceivePostProcessors.remove(afterReceivePostProcessor);
        }
        return false;
    }

    public void setCorrelationDataPostProcessor(CorrelationDataPostProcessor correlationDataPostProcessor) {
        this.correlationDataPostProcessor = correlationDataPostProcessor;
    }

    public void setUseTemporaryReplyQueues(boolean value) {
        this.useTemporaryReplyQueues = value;
    }

    public void setUseDirectReplyToContainer(boolean useDirectReplyToContainer) {
        this.useDirectReplyToContainer = useDirectReplyToContainer;
    }

    public void setUserIdExpression(Expression userIdExpression) {
        this.userIdExpression = userIdExpression;
    }

    public void setUserIdExpressionString(String userIdExpression) {
        this.userIdExpression = PARSER.parseExpression(userIdExpression);
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setUserCorrelationId(boolean userCorrelationId) {
        this.userCorrelationId = userCorrelationId;
    }

    public boolean isUsePublisherConnection() {
        return this.usePublisherConnection;
    }

    public void setUsePublisherConnection(boolean usePublisherConnection) {
        this.usePublisherConnection = usePublisherConnection;
    }

    public void setNoLocalReplyConsumer(boolean noLocalReplyConsumer) {
        this.noLocalReplyConsumer = noLocalReplyConsumer;
    }

    public void setReplyErrorHandler(ErrorHandler replyErrorHandler) {
        this.replyErrorHandler = replyErrorHandler;
    }

    @Override
    @Nullable
    public Collection<String> expectedQueueNames() {
        this.isListener = true;
        List<String> replyQueue = null;
        if (this.replyAddress == null || this.replyAddress.equals("amq.rabbitmq.reply-to")) {
            throw new IllegalStateException("A listener container must not be provided when using direct reply-to");
        }
        Address address = new Address(this.replyAddress);
        if ("".equals(address.getExchangeName())) {
            replyQueue = Collections.singletonList(address.getRoutingKey());
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Cannot verify reply queue because 'replyAddress' is not a simple queue name: " + this.replyAddress);
        }
        return replyQueue;
    }

    @Nullable
    public Collection<CorrelationData> getUnconfirmed(long age) {
        HashSet<CorrelationData> unconfirmed = new HashSet<CorrelationData>();
        long cutoffTime = System.currentTimeMillis() - age;
        for (Channel channel : this.publisherConfirmChannels.keySet()) {
            Collection<PendingConfirm> confirms = ((PublisherCallbackChannel)channel).expire(this, cutoffTime);
            for (PendingConfirm confirm : confirms) {
                unconfirmed.add(confirm.getCorrelationData());
            }
        }
        return unconfirmed.size() > 0 ? unconfirmed : null;
    }

    public int getUnconfirmedCount() {
        return this.publisherConfirmChannels.keySet().stream().mapToInt(channel -> ((PublisherCallbackChannel)channel).getPendingConfirmsCount(this)).sum();
    }

    @Override
    public void start() {
        this.doStart();
    }

    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Map<ConnectionFactory, DirectReplyToMessageListenerContainer> map = this.directReplyToContainers;
        synchronized (map) {
            this.directReplyToContainers.values().stream().filter(AbstractMessageListenerContainer::isRunning).forEach(AbstractMessageListenerContainer::stop);
            this.directReplyToContainers.clear();
        }
        this.doStop();
    }

    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Map<ConnectionFactory, DirectReplyToMessageListenerContainer> map = this.directReplyToContainers;
        synchronized (map) {
            return this.directReplyToContainers.values().stream().anyMatch(AbstractMessageListenerContainer::isRunning);
        }
    }

    @Override
    public void destroy() {
        this.stop();
    }

    private void evaluateFastReplyTo() {
        this.usingFastReplyTo = this.useDirectReplyTo();
        this.evaluatedFastReplyTo = true;
    }

    protected boolean useDirectReplyTo() {
        block6: {
            if (this.useTemporaryReplyQueues) {
                if (this.replyAddress != null) {
                    this.logger.warn("'useTemporaryReplyQueues' is ignored when a 'replyAddress' is provided");
                } else {
                    return false;
                }
            }
            if (this.replyAddress == null || "amq.rabbitmq.reply-to".equals(this.replyAddress)) {
                try {
                    return this.execute(channel -> {
                        channel.queueDeclarePassive("amq.rabbitmq.reply-to");
                        return true;
                    });
                }
                catch (AmqpConnectException | AmqpIOException ex) {
                    if (!this.shouldRethrow(ex)) break block6;
                    throw ex;
                }
            }
        }
        return false;
    }

    private boolean shouldRethrow(AmqpException ex) {
        Throwable cause;
        for (cause = ex; cause != null && !(cause instanceof ShutdownSignalException); cause = cause.getCause()) {
        }
        if (cause != null && RabbitUtils.isPassiveDeclarationChannelClose((ShutdownSignalException)cause)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Broker does not support fast replies via 'amq.rabbitmq.reply-to', temporary queues will be used: " + cause.getMessage() + ".");
            }
            this.replyAddress = null;
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IO error, deferring directReplyTo detection: " + ex.toString());
        }
        return true;
    }

    @Override
    public void send(Message message) throws AmqpException {
        this.send(this.exchange, this.routingKey, message);
    }

    @Override
    public void send(String routingKey, Message message) throws AmqpException {
        this.send(this.exchange, routingKey, message);
    }

    @Override
    public void send(String exchange2, String routingKey, Message message) throws AmqpException {
        this.send(exchange2, routingKey, message, null);
    }

    @Override
    public void send(String exchange2, String routingKey, Message message, @Nullable CorrelationData correlationData) throws AmqpException {
        this.execute(channel -> {
            this.doSend(channel, exchange2, routingKey, message, (this.returnCallback != null || correlationData != null && StringUtils.hasText(correlationData.getId())) && this.mandatoryExpression.getValue(this.evaluationContext, message, Boolean.class) != false, correlationData);
            return null;
        }, this.obtainTargetConnectionFactory(this.sendConnectionFactorySelectorExpression, message));
    }

    private ConnectionFactory obtainTargetConnectionFactory(Expression expression, Object rootObject) {
        if (expression != null && this.getConnectionFactory() instanceof AbstractRoutingConnectionFactory) {
            AbstractRoutingConnectionFactory routingConnectionFactory = (AbstractRoutingConnectionFactory)this.getConnectionFactory();
            Object lookupKey = rootObject != null ? this.sendConnectionFactorySelectorExpression.getValue((EvaluationContext)this.evaluationContext, rootObject) : this.sendConnectionFactorySelectorExpression.getValue(this.evaluationContext);
            if (lookupKey != null) {
                ConnectionFactory connectionFactory = routingConnectionFactory.getTargetConnectionFactory(lookupKey);
                if (connectionFactory != null) {
                    return connectionFactory;
                }
                if (!routingConnectionFactory.isLenientFallback()) {
                    throw new IllegalStateException("Cannot determine target ConnectionFactory for lookup key [" + lookupKey + "]");
                }
            }
        }
        return this.getConnectionFactory();
    }

    @Override
    public void convertAndSend(Object object) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, object, (CorrelationData)null);
    }

    @Override
    public void correlationConvertAndSend(Object object, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, object, correlationData);
    }

    @Override
    public void convertAndSend(String routingKey, Object object) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, object, (CorrelationData)null);
    }

    @Override
    public void convertAndSend(String routingKey, Object object, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, object, correlationData);
    }

    @Override
    public void convertAndSend(String exchange2, String routingKey, Object object) throws AmqpException {
        this.convertAndSend(exchange2, routingKey, object, (CorrelationData)null);
    }

    @Override
    public void convertAndSend(String exchange2, String routingKey, Object object, @Nullable CorrelationData correlationData) throws AmqpException {
        this.send(exchange2, routingKey, this.convertMessageIfNecessary(object), correlationData);
    }

    @Override
    public void convertAndSend(Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, message, messagePostProcessor);
    }

    @Override
    public void convertAndSend(String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, message, messagePostProcessor, null);
    }

    @Override
    public void convertAndSend(Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, message, messagePostProcessor, correlationData);
    }

    @Override
    public void convertAndSend(String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, message, messagePostProcessor, correlationData);
    }

    @Override
    public void convertAndSend(String exchange2, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(exchange2, routingKey, message, messagePostProcessor, null);
    }

    @Override
    public void convertAndSend(String exchange2, String routingKey, Object message, MessagePostProcessor messagePostProcessor, @Nullable CorrelationData correlationData) throws AmqpException {
        Message messageToSend = this.convertMessageIfNecessary(message);
        messageToSend = messagePostProcessor.postProcessMessage(messageToSend, correlationData);
        this.send(exchange2, routingKey, messageToSend, correlationData);
    }

    @Override
    @Nullable
    public Message receive() throws AmqpException {
        return this.receive(this.getRequiredQueue());
    }

    @Override
    @Nullable
    public Message receive(String queueName) {
        if (this.receiveTimeout == 0L) {
            return this.doReceiveNoWait(queueName);
        }
        return this.receive(queueName, this.receiveTimeout);
    }

    @Nullable
    protected Message doReceiveNoWait(String queueName) {
        Message message = this.execute(channel -> {
            GetResponse response = channel.basicGet(queueName, !this.isChannelTransacted());
            if (response != null) {
                long deliveryTag = response.getEnvelope().getDeliveryTag();
                if (this.isChannelLocallyTransacted(channel)) {
                    channel.basicAck(deliveryTag, false);
                    channel.txCommit();
                } else if (this.isChannelTransacted()) {
                    ConnectionFactoryUtils.registerDeliveryTag(this.getConnectionFactory(), channel, deliveryTag);
                }
                return this.buildMessageFromResponse(response);
            }
            return null;
        }, this.obtainTargetConnectionFactory(this.receiveConnectionFactorySelectorExpression, queueName));
        this.logReceived(message);
        return message;
    }

    @Override
    @Nullable
    public Message receive(long timeoutMillis) throws AmqpException {
        String queue = this.getRequiredQueue();
        if (timeoutMillis == 0L) {
            return this.doReceiveNoWait(queue);
        }
        return this.receive(queue, timeoutMillis);
    }

    @Override
    @Nullable
    public Message receive(String queueName, long timeoutMillis) {
        Message message = this.execute(channel -> {
            Delivery delivery = this.consumeDelivery(channel, queueName, timeoutMillis);
            if (delivery == null) {
                return null;
            }
            if (this.isChannelLocallyTransacted(channel)) {
                channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                channel.txCommit();
            } else if (this.isChannelTransacted()) {
                ConnectionFactoryUtils.registerDeliveryTag(this.getConnectionFactory(), channel, delivery.getEnvelope().getDeliveryTag());
            } else {
                channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
            }
            return this.buildMessageFromDelivery(delivery);
        });
        this.logReceived(message);
        return message;
    }

    @Override
    @Nullable
    public Object receiveAndConvert() throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue());
    }

    @Override
    @Nullable
    public Object receiveAndConvert(String queueName) throws AmqpException {
        return this.receiveAndConvert(queueName, this.receiveTimeout);
    }

    @Override
    @Nullable
    public Object receiveAndConvert(long timeoutMillis) throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue(), timeoutMillis);
    }

    @Override
    @Nullable
    public Object receiveAndConvert(String queueName, long timeoutMillis) throws AmqpException {
        Message response;
        Message message = response = timeoutMillis == 0L ? this.doReceiveNoWait(queueName) : this.receive(queueName, timeoutMillis);
        if (response != null) {
            return this.getRequiredMessageConverter().fromMessage(response);
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T receiveAndConvert(ParameterizedTypeReference<T> type) throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue(), type);
    }

    @Override
    @Nullable
    public <T> T receiveAndConvert(String queueName, ParameterizedTypeReference<T> type) throws AmqpException {
        return this.receiveAndConvert(queueName, this.receiveTimeout, type);
    }

    @Override
    @Nullable
    public <T> T receiveAndConvert(long timeoutMillis, ParameterizedTypeReference<T> type) throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue(), timeoutMillis, type);
    }

    @Override
    @Nullable
    public <T> T receiveAndConvert(String queueName, long timeoutMillis, ParameterizedTypeReference<T> type) throws AmqpException {
        Message response;
        Message message = response = timeoutMillis == 0L ? this.doReceiveNoWait(queueName) : this.receive(queueName, timeoutMillis);
        if (response != null) {
            return (T)this.getRequiredSmartMessageConverter().fromMessage(response, type);
        }
        return null;
    }

    @Override
    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback);
    }

    @Override
    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback) throws AmqpException {
        return this.receiveAndReply(queueName, callback, this.defaultReplyToAddressCallback);
    }

    @Override
    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback, String exchange2, String routingKey) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback, exchange2, routingKey);
    }

    @Override
    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback, String replyExchange, String replyRoutingKey) throws AmqpException {
        return this.receiveAndReply(queueName, callback, (Message request, S reply) -> new Address(replyExchange, replyRoutingKey));
    }

    @Override
    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback, replyToAddressCallback);
    }

    @Override
    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        return this.doReceiveAndReply(queueName, callback, replyToAddressCallback);
    }

    private <R, S> boolean doReceiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        Boolean result = this.execute(channel -> {
            Message receiveMessage = this.receiveForReply(queueName, channel);
            if (receiveMessage != null) {
                return this.sendReply(callback, replyToAddressCallback, channel, receiveMessage);
            }
            return false;
        }, this.obtainTargetConnectionFactory(this.receiveConnectionFactorySelectorExpression, queueName));
        return result == null ? false : result;
    }

    @Nullable
    private Message receiveForReply(String queueName, Channel channel) throws IOException {
        boolean channelTransacted = this.isChannelTransacted();
        boolean channelLocallyTransacted = this.isChannelLocallyTransacted(channel);
        Message receiveMessage = null;
        if (this.receiveTimeout == 0L) {
            GetResponse response = channel.basicGet(queueName, !channelTransacted);
            if (response != null) {
                long deliveryTag1 = response.getEnvelope().getDeliveryTag();
                if (channelLocallyTransacted) {
                    channel.basicAck(deliveryTag1, false);
                } else if (channelTransacted) {
                    ConnectionFactoryUtils.registerDeliveryTag(this.getConnectionFactory(), channel, deliveryTag1);
                }
                receiveMessage = this.buildMessageFromResponse(response);
            }
        } else {
            Delivery delivery = this.consumeDelivery(channel, queueName, this.receiveTimeout);
            if (delivery != null) {
                long deliveryTag2 = delivery.getEnvelope().getDeliveryTag();
                if (channelTransacted && !channelLocallyTransacted) {
                    ConnectionFactoryUtils.registerDeliveryTag(this.getConnectionFactory(), channel, deliveryTag2);
                } else {
                    channel.basicAck(deliveryTag2, false);
                }
                receiveMessage = this.buildMessageFromDelivery(delivery);
            }
        }
        this.logReceived(receiveMessage);
        return receiveMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Delivery consumeDelivery(Channel channel, String queueName, long timeoutMillis) throws IOException {
        Delivery delivery = null;
        RuntimeException exception = null;
        CompletableFuture<Delivery> future = new CompletableFuture<Delivery>();
        ShutdownListener shutdownListener = c -> {
            if (!RabbitUtils.isNormalChannelClose(c)) {
                future.completeExceptionally(c);
            }
        };
        channel.addShutdownListener(shutdownListener);
        ClosingRecoveryListener.addRecoveryListenerIfNecessary(channel);
        DefaultConsumer consumer = null;
        try {
            consumer = this.createConsumer(queueName, channel, future, timeoutMillis < 0L ? 10000L : timeoutMillis);
            delivery = timeoutMillis < 0L ? future.get() : future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.logger.error("Consumer failed to receive message: " + consumer, cause);
            exception = RabbitExceptionTranslator.convertRabbitAccessException(cause);
            throw exception;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            RabbitUtils.setPhysicalCloseRequired(channel, true);
        }
        finally {
            if (consumer != null && !(exception instanceof ConsumerCancelledException) && channel.isOpen()) {
                this.cancelConsumerQuietly(channel, consumer);
            }
            try {
                channel.removeShutdownListener(shutdownListener);
            }
            catch (Exception e) {}
        }
        return delivery;
    }

    private void logReceived(Message message) {
        if (message == null) {
            this.logger.debug("Received no message");
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received: " + message);
        }
    }

    private <R, S> boolean sendReply(ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback, Channel channel, Message receiveMessage) throws IOException {
        S reply;
        Object receive = receiveMessage;
        if (!ReceiveAndReplyMessageCallback.class.isAssignableFrom(callback.getClass())) {
            receive = this.getRequiredMessageConverter().fromMessage(receiveMessage);
        }
        try {
            reply = callback.handle((Message)receive);
        }
        catch (ClassCastException e) {
            StackTraceElement[] trace = e.getStackTrace();
            if (trace[0].getMethodName().equals("handle") && trace[1].getFileName().equals("RabbitTemplate.java")) {
                throw new IllegalArgumentException("ReceiveAndReplyCallback '" + callback + "' can't handle received object '" + receive + "'", e);
            }
            throw e;
        }
        if (reply != null) {
            this.doSendReply(replyToAddressCallback, channel, receiveMessage, reply);
        } else if (this.isChannelLocallyTransacted(channel)) {
            channel.txCommit();
        }
        return true;
    }

    private <S> void doSendReply(ReplyToAddressCallback<S> replyToAddressCallback, Channel channel, Message receiveMessage, S reply) throws IOException {
        String correlation;
        Address replyTo = replyToAddressCallback.getReplyToAddress(receiveMessage, reply);
        Message replyMessage = this.convertMessageIfNecessary(reply);
        MessageProperties receiveMessageProperties = receiveMessage.getMessageProperties();
        MessageProperties replyMessageProperties = replyMessage.getMessageProperties();
        String string = correlation = this.correlationKey == null ? receiveMessageProperties.getCorrelationId() : receiveMessageProperties.getHeaders().get(this.correlationKey);
        if (this.correlationKey == null || correlation == null) {
            String messageId;
            if (correlation == null && (messageId = receiveMessageProperties.getMessageId()) != null) {
                correlation = messageId;
            }
            replyMessageProperties.setCorrelationId(correlation);
        } else {
            replyMessageProperties.setHeader(this.correlationKey, correlation);
        }
        this.doSend(channel, replyTo.getExchangeName(), replyTo.getRoutingKey(), replyMessage, this.returnCallback != null && this.isMandatoryFor(replyMessage) != false, null);
    }

    @Override
    @Nullable
    public Message sendAndReceive(Message message) throws AmqpException {
        return this.sendAndReceive(message, null);
    }

    @Nullable
    public Message sendAndReceive(Message message, @Nullable CorrelationData correlationData) throws AmqpException {
        return this.doSendAndReceive(this.exchange, this.routingKey, message, correlationData);
    }

    @Override
    @Nullable
    public Message sendAndReceive(String routingKey, Message message) throws AmqpException {
        return this.sendAndReceive(routingKey, message, null);
    }

    @Nullable
    public Message sendAndReceive(String routingKey, Message message, @Nullable CorrelationData correlationData) throws AmqpException {
        return this.doSendAndReceive(this.exchange, routingKey, message, correlationData);
    }

    @Override
    @Nullable
    public Message sendAndReceive(String exchange2, String routingKey, Message message) throws AmqpException {
        return this.sendAndReceive(exchange2, routingKey, message, null);
    }

    @Nullable
    public Message sendAndReceive(String exchange2, String routingKey, Message message, @Nullable CorrelationData correlationData) throws AmqpException {
        return this.doSendAndReceive(exchange2, routingKey, message, correlationData);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(Object message) throws AmqpException {
        return this.convertSendAndReceive(message, (CorrelationData)null);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(Object message, @Nullable CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, this.routingKey, message, null, correlationData);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(String routingKey, Object message) throws AmqpException {
        return this.convertSendAndReceive(routingKey, message, (CorrelationData)null);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(String routingKey, Object message, @Nullable CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, routingKey, message, null, correlationData);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(String exchange2, String routingKey, Object message) throws AmqpException {
        return this.convertSendAndReceive(exchange2, routingKey, message, (CorrelationData)null);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(String exchange2, String routingKey, Object message, @Nullable CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(exchange2, routingKey, message, null, correlationData);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(message, messagePostProcessor, null);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(Object message, MessagePostProcessor messagePostProcessor, @Nullable CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, this.routingKey, message, messagePostProcessor, correlationData);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(routingKey, message, messagePostProcessor, null);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(String routingKey, Object message, MessagePostProcessor messagePostProcessor, @Nullable CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, routingKey, message, messagePostProcessor, correlationData);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(String exchange2, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(exchange2, routingKey, message, messagePostProcessor, null);
    }

    @Override
    @Nullable
    public Object convertSendAndReceive(String exchange2, String routingKey, Object message, @Nullable MessagePostProcessor messagePostProcessor, @Nullable CorrelationData correlationData) throws AmqpException {
        Message replyMessage = this.convertSendAndReceiveRaw(exchange2, routingKey, message, messagePostProcessor, correlationData);
        if (replyMessage == null) {
            return null;
        }
        return this.getRequiredMessageConverter().fromMessage(replyMessage);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(Object message, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(message, (CorrelationData)null, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(Object message, @Nullable CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(this.exchange, this.routingKey, message, null, correlationData, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(String routingKey, Object message, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(routingKey, message, (CorrelationData)null, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(String routingKey, Object message, @Nullable CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(this.exchange, routingKey, message, null, correlationData, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(String exchange2, String routingKey, Object message, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(exchange2, routingKey, message, (CorrelationData)null, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(Object message, @Nullable MessagePostProcessor messagePostProcessor, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(message, messagePostProcessor, null, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(Object message, @Nullable MessagePostProcessor messagePostProcessor, @Nullable CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(this.exchange, this.routingKey, message, messagePostProcessor, correlationData, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(String routingKey, Object message, @Nullable MessagePostProcessor messagePostProcessor, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(routingKey, message, messagePostProcessor, null, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(String routingKey, Object message, @Nullable MessagePostProcessor messagePostProcessor, @Nullable CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(this.exchange, routingKey, message, messagePostProcessor, correlationData, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(String exchange2, String routingKey, Object message, MessagePostProcessor messagePostProcessor, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(exchange2, routingKey, message, messagePostProcessor, null, responseType);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceiveAsType(String exchange2, String routingKey, Object message, @Nullable MessagePostProcessor messagePostProcessor, @Nullable CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        Message replyMessage = this.convertSendAndReceiveRaw(exchange2, routingKey, message, messagePostProcessor, correlationData);
        if (replyMessage == null) {
            return null;
        }
        return (T)this.getRequiredSmartMessageConverter().fromMessage(replyMessage, responseType);
    }

    @Nullable
    protected Message convertSendAndReceiveRaw(String exchange2, String routingKey, Object message, @Nullable MessagePostProcessor messagePostProcessor, @Nullable CorrelationData correlationData) {
        Message requestMessage = this.convertMessageIfNecessary(message);
        if (messagePostProcessor != null) {
            requestMessage = messagePostProcessor.postProcessMessage(requestMessage, correlationData);
        }
        return this.doSendAndReceive(exchange2, routingKey, requestMessage, correlationData);
    }

    protected Message convertMessageIfNecessary(Object object) {
        if (object instanceof Message) {
            return (Message)object;
        }
        return this.getRequiredMessageConverter().toMessage(object, new MessageProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Message doSendAndReceive(String exchange2, String routingKey, Message message, @Nullable CorrelationData correlationData) {
        if (!this.evaluatedFastReplyTo) {
            RabbitTemplate rabbitTemplate = this;
            synchronized (rabbitTemplate) {
                if (!this.evaluatedFastReplyTo) {
                    this.evaluateFastReplyTo();
                }
            }
        }
        if (this.usingFastReplyTo && this.useDirectReplyToContainer) {
            return this.doSendAndReceiveWithDirect(exchange2, routingKey, message, correlationData);
        }
        if (this.replyAddress == null || this.usingFastReplyTo) {
            return this.doSendAndReceiveWithTemporary(exchange2, routingKey, message, correlationData);
        }
        return this.doSendAndReceiveWithFixed(exchange2, routingKey, message, correlationData);
    }

    @Nullable
    protected Message doSendAndReceiveWithTemporary(String exchange2, String routingKey, Message message, CorrelationData correlationData) {
        return this.execute(channel -> {
            String replyTo;
            final PendingReply pendingReply = new PendingReply();
            String messageTag = String.valueOf(this.messageTagProvider.incrementAndGet());
            this.replyHolder.putIfAbsent(messageTag, pendingReply);
            Assert.isNull((Object)message.getMessageProperties().getReplyTo(), "Send-and-receive methods can only be used if the Message does not already have a replyTo property.");
            if (this.usingFastReplyTo) {
                replyTo = "amq.rabbitmq.reply-to";
            } else {
                AMQP.Queue.DeclareOk queueDeclaration = channel.queueDeclare();
                replyTo = queueDeclaration.getQueue();
            }
            message.getMessageProperties().setReplyTo(replyTo);
            String consumerTag = UUID.randomUUID().toString();
            TemplateConsumer consumer = new TemplateConsumer(channel){

                @Override
                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body2) {
                    MessageProperties messageProperties = RabbitTemplate.this.messagePropertiesConverter.toMessageProperties(properties, envelope, RabbitTemplate.this.encoding);
                    Message reply = new Message(body2, messageProperties);
                    if (RabbitTemplate.this.logger.isTraceEnabled()) {
                        RabbitTemplate.this.logger.trace("Message received " + reply);
                    }
                    if (RabbitTemplate.this.afterReceivePostProcessors != null) {
                        for (MessagePostProcessor processor : RabbitTemplate.this.afterReceivePostProcessors) {
                            reply = processor.postProcessMessage(reply);
                        }
                    }
                    pendingReply.reply(reply);
                }
            };
            ClosingRecoveryListener.addRecoveryListenerIfNecessary(channel);
            ShutdownListener shutdownListener = c -> {
                if (!RabbitUtils.isNormalChannelClose(c)) {
                    pendingReply.completeExceptionally(c);
                }
            };
            channel.addShutdownListener(shutdownListener);
            channel.basicConsume(replyTo, true, consumerTag, this.noLocalReplyConsumer, true, null, consumer);
            Message reply = null;
            try {
                reply = this.exchangeMessages(exchange2, routingKey, message, correlationData, channel, pendingReply, messageTag);
            }
            finally {
                this.replyHolder.remove(messageTag);
                if (channel.isOpen()) {
                    this.cancelConsumerQuietly(channel, consumer);
                }
                try {
                    channel.removeShutdownListener(shutdownListener);
                }
                catch (Exception exception) {}
            }
            return reply;
        }, this.obtainTargetConnectionFactory(this.sendConnectionFactorySelectorExpression, message));
    }

    private void cancelConsumerQuietly(Channel channel, DefaultConsumer consumer) {
        RabbitUtils.cancel(channel, consumer.getConsumerTag());
    }

    @Nullable
    protected Message doSendAndReceiveWithFixed(String exchange2, String routingKey, Message message, CorrelationData correlationData) {
        Assert.state(this.isListener, () -> "RabbitTemplate is not configured as MessageListener - cannot use a 'replyAddress': " + this.replyAddress);
        return this.execute(channel -> this.doSendAndReceiveAsListener(exchange2, routingKey, message, correlationData, channel), this.obtainTargetConnectionFactory(this.sendConnectionFactorySelectorExpression, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Message doSendAndReceiveWithDirect(String exchange2, String routingKey, Message message, CorrelationData correlationData) {
        DirectReplyToMessageListenerContainer container;
        ConnectionFactory connectionFactory = this.obtainTargetConnectionFactory(this.sendConnectionFactorySelectorExpression, message);
        if (this.usePublisherConnection && connectionFactory.getPublisherConnectionFactory() != null) {
            connectionFactory = connectionFactory.getPublisherConnectionFactory();
        }
        if ((container = this.directReplyToContainers.get(connectionFactory)) == null) {
            Map<ConnectionFactory, DirectReplyToMessageListenerContainer> map = this.directReplyToContainers;
            synchronized (map) {
                container = this.directReplyToContainers.get(connectionFactory);
                if (container == null) {
                    container = new DirectReplyToMessageListenerContainer(connectionFactory);
                    container.setMessageListener(this);
                    container.setBeanName(this.beanName + "#" + this.containerInstance.getAndIncrement());
                    if (this.taskExecutor != null) {
                        container.setTaskExecutor(this.taskExecutor);
                    }
                    if (this.afterReceivePostProcessors != null) {
                        container.setAfterReceivePostProcessors(this.afterReceivePostProcessors.toArray(new MessagePostProcessor[this.afterReceivePostProcessors.size()]));
                    }
                    container.setNoLocal(this.noLocalReplyConsumer);
                    if (this.replyErrorHandler != null) {
                        container.setErrorHandler(this.replyErrorHandler);
                    }
                    container.start();
                    this.directReplyToContainers.put(connectionFactory, container);
                    this.replyAddress = "amq.rabbitmq.reply-to";
                }
            }
        }
        DirectReplyToMessageListenerContainer.ChannelHolder channelHolder = container.getChannelHolder();
        try {
            Channel channel = channelHolder.getChannel();
            if (this.confirmsOrReturnsCapable.booleanValue()) {
                this.addListener(channel);
            }
            Message message2 = this.doSendAndReceiveAsListener(exchange2, routingKey, message, correlationData, channel);
            return message2;
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
        finally {
            container.releaseConsumerFor(channelHolder, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Message doSendAndReceiveAsListener(String exchange2, String routingKey, Message message, CorrelationData correlationData, Channel channel) throws Exception {
        PendingReply pendingReply = new PendingReply();
        String messageTag = String.valueOf(this.messageTagProvider.incrementAndGet());
        if (this.userCorrelationId) {
            String correlationId = this.correlationKey != null ? (String)message.getMessageProperties().getHeaders().get(this.correlationKey) : message.getMessageProperties().getCorrelationId();
            if (correlationId == null) {
                this.replyHolder.put(messageTag, pendingReply);
            } else {
                this.replyHolder.put(correlationId, pendingReply);
            }
        } else {
            this.replyHolder.put(messageTag, pendingReply);
        }
        this.saveAndSetProperties(message, pendingReply, messageTag);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sending message with tag " + messageTag);
        }
        Message reply = null;
        try {
            reply = this.exchangeMessages(exchange2, routingKey, message, correlationData, channel, pendingReply, messageTag);
            if (reply != null && this.afterReceivePostProcessors != null) {
                for (MessagePostProcessor processor : this.afterReceivePostProcessors) {
                    reply = processor.postProcessMessage(reply);
                }
            }
        }
        finally {
            this.replyHolder.remove(messageTag);
        }
        return reply;
    }

    private void saveAndSetProperties(Message message, PendingReply pendingReply, String messageTag) {
        String savedReplyTo = message.getMessageProperties().getReplyTo();
        pendingReply.setSavedReplyTo(savedReplyTo);
        if (StringUtils.hasLength(savedReplyTo) && this.logger.isDebugEnabled()) {
            this.logger.debug("Replacing replyTo header: " + savedReplyTo + " in favor of template's configured reply-queue: " + this.replyAddress);
        }
        message.getMessageProperties().setReplyTo(this.replyAddress);
        if (!this.userCorrelationId) {
            String savedCorrelation = null;
            if (this.correlationKey == null) {
                String correlationId = message.getMessageProperties().getCorrelationId();
                if (correlationId != null) {
                    savedCorrelation = correlationId;
                }
            } else {
                savedCorrelation = (String)message.getMessageProperties().getHeaders().get(this.correlationKey);
            }
            pendingReply.setSavedCorrelation(savedCorrelation);
            if (this.correlationKey == null) {
                message.getMessageProperties().setCorrelationId(messageTag);
            } else {
                message.getMessageProperties().setHeader(this.correlationKey, messageTag);
            }
        }
    }

    @Nullable
    private Message exchangeMessages(String exchange2, String routingKey, Message message, CorrelationData correlationData, Channel channel, PendingReply pendingReply, String messageTag) throws IOException, InterruptedException {
        Message reply;
        boolean mandatory = this.isMandatoryFor(message);
        if (mandatory && this.returnCallback == null) {
            message.getMessageProperties().getHeaders().put(RETURN_CORRELATION_KEY, messageTag);
        }
        this.doSend(channel, exchange2, routingKey, message, mandatory, correlationData);
        Message message2 = reply = this.replyTimeout < 0L ? pendingReply.get() : pendingReply.get(this.replyTimeout, TimeUnit.MILLISECONDS);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reply: " + reply);
        }
        if (reply == null) {
            this.replyTimedOut(message.getMessageProperties().getCorrelationId());
        }
        return reply;
    }

    protected void replyTimedOut(String correlationId) {
    }

    public Boolean isMandatoryFor(Message message) {
        Boolean value = this.mandatoryExpression.getValue(this.evaluationContext, message, Boolean.class);
        return value != null ? value : Boolean.FALSE;
    }

    @Override
    @Nullable
    public <T> T execute(ChannelCallback<T> action) {
        return this.execute(action, this.getConnectionFactory());
    }

    @Nullable
    private <T> T execute(ChannelCallback<T> action, ConnectionFactory connectionFactory) {
        if (this.retryTemplate != null) {
            try {
                return (T)this.retryTemplate.execute((RetryContext context) -> this.doExecute(action, connectionFactory), this.recoveryCallback);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException(e);
            }
        }
        return this.doExecute(action, connectionFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T doExecute(ChannelCallback<T> action, ConnectionFactory connectionFactory) {
        Connection connection;
        RabbitResourceHolder resourceHolder;
        boolean invokeScope;
        Channel channel;
        block13: {
            block14: {
                Assert.notNull(action, "Callback object must not be null");
                channel = null;
                invokeScope = false;
                if (this.activeTemplateCallbacks.get() > 0) {
                    channel = this.dedicatedChannels.get();
                }
                resourceHolder = null;
                connection = null;
                if (channel != null) break block14;
                if (this.isChannelTransacted()) {
                    resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(connectionFactory, true, this.usePublisherConnection);
                    channel = resourceHolder.getChannel();
                    if (channel == null) {
                        ConnectionFactoryUtils.releaseResources(resourceHolder);
                        throw new IllegalStateException("Resource holder returned a null channel");
                    }
                    break block13;
                } else {
                    connection = ConnectionFactoryUtils.createConnection(connectionFactory, this.usePublisherConnection);
                    if (connection == null) {
                        throw new IllegalStateException("Connection factory returned a null connection");
                    }
                    try {
                        channel = connection.createChannel(false);
                        if (channel == null) {
                            throw new IllegalStateException("Connection returned a null channel");
                        }
                        break block13;
                    }
                    catch (RuntimeException e) {
                        RabbitUtils.closeConnection(connection);
                        throw e;
                    }
                }
            }
            invokeScope = true;
        }
        try {
            T e = this.invokeAction(action, connectionFactory, channel);
            return e;
        }
        catch (Exception ex) {
            if (!this.isChannelLocallyTransacted(channel)) throw this.convertRabbitAccessException(ex);
            resourceHolder.rollbackAll();
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            this.cleanUpAfterAction(channel, invokeScope, resourceHolder, connection);
        }
    }

    private void cleanUpAfterAction(Channel channel, boolean invokeScope, RabbitResourceHolder resourceHolder, Connection connection) {
        if (!invokeScope) {
            if (resourceHolder != null) {
                ConnectionFactoryUtils.releaseResources(resourceHolder);
            } else {
                RabbitUtils.closeChannel(channel);
                RabbitUtils.closeConnection(connection);
            }
        }
    }

    @Nullable
    private <T> T invokeAction(ChannelCallback<T> action, ConnectionFactory connectionFactory, Channel channel) throws Exception {
        if (this.confirmsOrReturnsCapable == null) {
            this.determineConfirmsReturnsCapability(connectionFactory);
        }
        if (this.confirmsOrReturnsCapable.booleanValue()) {
            this.addListener(channel);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing callback " + action.getClass().getSimpleName() + " on RabbitMQ Channel: " + channel);
        }
        return action.doInRabbit(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T invoke(RabbitOperations.OperationsCallback<T> action, @Nullable com.rabbitmq.client.ConfirmCallback acks, @Nullable com.rabbitmq.client.ConfirmCallback nacks) {
        Channel channel;
        Channel currentChannel = this.dedicatedChannels.get();
        Assert.state(currentChannel == null, () -> "Nested invoke() calls are not supported; channel '" + currentChannel + "' is already associated with this thread");
        this.activeTemplateCallbacks.incrementAndGet();
        RabbitResourceHolder resourceHolder = null;
        Connection connection = null;
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        if (this.isChannelTransacted()) {
            resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(connectionFactory, true, this.usePublisherConnection);
            channel = resourceHolder.getChannel();
            if (channel == null) {
                ConnectionFactoryUtils.releaseResources(resourceHolder);
                throw new IllegalStateException("Resource holder returned a null channel");
            }
        } else {
            if (this.usePublisherConnection && connectionFactory.getPublisherConnectionFactory() != null) {
                connectionFactory = connectionFactory.getPublisherConnectionFactory();
            }
            if ((connection = connectionFactory.createConnection()) == null) {
                throw new IllegalStateException("Connection factory returned a null connection");
            }
            try {
                channel = connection.createChannel(false);
                if (channel == null) {
                    throw new IllegalStateException("Connection returned a null channel");
                }
                if (!connectionFactory.isPublisherConfirms()) {
                    RabbitUtils.setPhysicalCloseRequired(channel, true);
                }
                this.dedicatedChannels.set(channel);
            }
            catch (RuntimeException e) {
                RabbitUtils.closeConnection(connection);
                throw e;
            }
        }
        ConfirmListener listener = this.addConfirmListener(acks, nacks, channel);
        try {
            T t = action.doInRabbit(this);
            return t;
        }
        finally {
            this.cleanUpAfterAction(resourceHolder, connection, channel, listener);
        }
    }

    @Nullable
    private ConfirmListener addConfirmListener(@Nullable com.rabbitmq.client.ConfirmCallback acks, @Nullable com.rabbitmq.client.ConfirmCallback nacks, Channel channel) {
        ConfirmListener listener = null;
        if (acks != null && nacks != null && channel instanceof ChannelProxy && ((ChannelProxy)channel).isConfirmSelected()) {
            listener = channel.addConfirmListener(acks, nacks);
        }
        return listener;
    }

    private void cleanUpAfterAction(RabbitResourceHolder resourceHolder, Connection connection, Channel channel, ConfirmListener listener) {
        if (listener != null) {
            channel.removeConfirmListener(listener);
        }
        this.activeTemplateCallbacks.decrementAndGet();
        this.dedicatedChannels.remove();
        if (resourceHolder != null) {
            ConnectionFactoryUtils.releaseResources(resourceHolder);
        } else {
            RabbitUtils.closeChannel(channel);
            RabbitUtils.closeConnection(connection);
        }
    }

    @Override
    public boolean waitForConfirms(long timeout) {
        Channel channel = this.dedicatedChannels.get();
        Assert.state(channel != null, "This operation is only available within the scope of an invoke operation");
        try {
            return channel.waitForConfirms(timeout);
        }
        catch (TimeoutException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public void waitForConfirmsOrDie(long timeout) {
        Channel channel = this.dedicatedChannels.get();
        Assert.state(channel != null, "This operation is only available within the scope of an invoke operation");
        try {
            channel.waitForConfirmsOrDie(timeout);
        }
        catch (IOException | TimeoutException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    public void determineConfirmsReturnsCapability(ConnectionFactory connectionFactory) {
        this.publisherConfirms = connectionFactory.isPublisherConfirms();
        this.confirmsOrReturnsCapable = this.publisherConfirms || connectionFactory.isPublisherReturns();
    }

    public void doSend(Channel channel, String exchangeArg, String routingKeyArg, Message message, boolean mandatory, @Nullable CorrelationData correlationData) throws IOException {
        String userId;
        String exch = exchangeArg;
        String rKey = routingKeyArg;
        if (exch == null) {
            exch = this.exchange;
        }
        if (rKey == null) {
            rKey = this.routingKey;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Original message to publish: " + message);
        }
        Message messageToUse = message;
        MessageProperties messageProperties = messageToUse.getMessageProperties();
        if (mandatory) {
            messageProperties.getHeaders().put("spring_listener_return_correlation", this.uuid);
        }
        if (this.beforePublishPostProcessors != null) {
            for (MessagePostProcessor processor : this.beforePublishPostProcessors) {
                messageToUse = processor.postProcessMessage(messageToUse, correlationData);
            }
        }
        this.setupConfirm(channel, messageToUse, correlationData);
        if (this.userIdExpression != null && messageProperties.getUserId() == null && (userId = this.userIdExpression.getValue(this.evaluationContext, messageToUse, String.class)) != null) {
            messageProperties.setUserId(userId);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Publishing message [" + messageToUse + "] on exchange [" + exch + "], routingKey = [" + rKey + "]");
        }
        this.sendToRabbit(channel, exch, rKey, mandatory, messageToUse);
        if (this.isChannelLocallyTransacted(channel)) {
            RabbitUtils.commitIfNecessary(channel);
        }
    }

    protected void sendToRabbit(Channel channel, String exchange2, String routingKey, boolean mandatory, Message message) throws IOException {
        AMQP.BasicProperties convertedMessageProperties = this.messagePropertiesConverter.fromMessageProperties(message.getMessageProperties(), this.encoding);
        channel.basicPublish(exchange2, routingKey, mandatory, convertedMessageProperties, message.getBody());
    }

    private void setupConfirm(Channel channel, Message message, @Nullable CorrelationData correlationDataArg) {
        if ((this.publisherConfirms || this.confirmCallback != null) && channel instanceof PublisherCallbackChannel) {
            PublisherCallbackChannel publisherCallbackChannel = (PublisherCallbackChannel)channel;
            CorrelationData correlationData = this.correlationDataPostProcessor != null ? this.correlationDataPostProcessor.postProcess(message, correlationDataArg) : correlationDataArg;
            long nextPublishSeqNo = channel.getNextPublishSeqNo();
            message.getMessageProperties().setPublishSequenceNumber(nextPublishSeqNo);
            publisherCallbackChannel.addPendingConfirm(this, nextPublishSeqNo, new PendingConfirm(correlationData, System.currentTimeMillis()));
            if (correlationData != null && StringUtils.hasText(correlationData.getId())) {
                message.getMessageProperties().setHeader("spring_returned_message_correlation", correlationData.getId());
            }
        } else if (channel instanceof ChannelProxy && ((ChannelProxy)channel).isConfirmSelected()) {
            long nextPublishSeqNo = channel.getNextPublishSeqNo();
            message.getMessageProperties().setPublishSequenceNumber(nextPublishSeqNo);
        }
    }

    protected boolean isChannelLocallyTransacted(Channel channel) {
        return this.isChannelTransacted() && !ConnectionFactoryUtils.isChannelTransactional(channel, this.getConnectionFactory());
    }

    private Message buildMessageFromDelivery(Delivery delivery) {
        return this.buildMessage(delivery.getEnvelope(), delivery.getProperties(), delivery.getBody(), -1);
    }

    private Message buildMessageFromResponse(GetResponse response) {
        return this.buildMessage(response.getEnvelope(), response.getProps(), response.getBody(), response.getMessageCount());
    }

    private Message buildMessage(Envelope envelope, AMQP.BasicProperties properties, byte[] body2, int msgCount) {
        MessageProperties messageProps = this.messagePropertiesConverter.toMessageProperties(properties, envelope, this.encoding);
        if (msgCount >= 0) {
            messageProps.setMessageCount(msgCount);
        }
        Message message = new Message(body2, messageProps);
        if (this.afterReceivePostProcessors != null) {
            for (MessagePostProcessor processor : this.afterReceivePostProcessors) {
                message = processor.postProcessMessage(message);
            }
        }
        return message;
    }

    private MessageConverter getRequiredMessageConverter() throws IllegalStateException {
        MessageConverter converter = this.getMessageConverter();
        if (converter == null) {
            throw new AmqpIllegalStateException("No 'messageConverter' specified. Check configuration of RabbitTemplate.");
        }
        return converter;
    }

    private SmartMessageConverter getRequiredSmartMessageConverter() throws IllegalStateException {
        MessageConverter converter = this.getRequiredMessageConverter();
        Assert.state(converter instanceof SmartMessageConverter, "template's message converter must be a SmartMessageConverter");
        return (SmartMessageConverter)converter;
    }

    private String getRequiredQueue() throws IllegalStateException {
        String name = this.defaultReceiveQueue;
        if (name == null) {
            throw new AmqpIllegalStateException("No 'queue' specified. Check configuration of RabbitTemplate.");
        }
        return name;
    }

    private Address getReplyToAddress(Message request) throws AmqpException {
        Address replyTo = request.getMessageProperties().getReplyToAddress();
        if (replyTo == null) {
            if (this.exchange == null) {
                throw new AmqpException("Cannot determine ReplyTo message property value: Request message does not contain reply-to property, and no default Exchange was set.");
            }
            replyTo = new Address(this.exchange, this.routingKey);
        }
        return replyTo;
    }

    public void addListener(Channel channel) {
        if (channel instanceof PublisherCallbackChannel) {
            Channel key;
            PublisherCallbackChannel publisherCallbackChannel = (PublisherCallbackChannel)channel;
            Channel channel2 = key = channel instanceof ChannelProxy ? ((ChannelProxy)channel).getTargetChannel() : channel;
            if (this.publisherConfirmChannels.putIfAbsent(key, this) == null) {
                publisherCallbackChannel.addListener(this);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Added publisher confirm channel: " + channel + " to map, size now " + this.publisherConfirmChannels.size());
                }
            }
        } else {
            throw new IllegalStateException("Channel does not support confirms or returns; is the connection factory configured for confirms or returns?");
        }
    }

    @Override
    public void handleConfirm(PendingConfirm pendingConfirm, boolean ack) {
        if (this.confirmCallback != null) {
            this.confirmCallback.confirm(pendingConfirm.getCorrelationData(), ack, pendingConfirm.getCause());
        }
    }

    @Override
    public void handleReturn(int replyCode, String replyText, String exchange2, String routingKey, AMQP.BasicProperties properties, byte[] body2) {
        ReturnCallback callback = this.returnCallback;
        if (callback == null) {
            Object messageTagHeader = properties.getHeaders().remove(RETURN_CORRELATION_KEY);
            if (messageTagHeader != null) {
                String messageTag = messageTagHeader.toString();
                PendingReply pendingReply = this.replyHolder.get(messageTag);
                if (pendingReply != null) {
                    callback = (message, replyCode1, replyText1, exchange1, routingKey1) -> pendingReply.returned(new AmqpMessageReturnedException("Message returned", message, replyCode1, replyText1, exchange1, routingKey1));
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Returned request message but caller has timed out");
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Returned message but no callback available");
            }
        }
        if (callback != null) {
            properties.getHeaders().remove("spring_listener_return_correlation");
            MessageProperties messageProperties = this.messagePropertiesConverter.toMessageProperties(properties, null, this.encoding);
            Message returnedMessage = new Message(body2, messageProperties);
            callback.returnedMessage(returnedMessage, replyCode, replyText, exchange2, routingKey);
        }
    }

    @Override
    public boolean isConfirmListener() {
        return this.confirmCallback != null;
    }

    @Override
    public boolean isReturnListener() {
        return true;
    }

    @Override
    public void revoke(Channel channel) {
        this.publisherConfirmChannels.remove(channel);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Removed publisher confirm channel: " + channel + " from map, size now " + this.publisherConfirmChannels.size());
        }
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public void onMessage(Message message) {
        String messageTag;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Message received " + message);
        }
        if ((messageTag = this.correlationKey == null ? message.getMessageProperties().getCorrelationId() : (String)message.getMessageProperties().getHeaders().get(this.correlationKey)) == null) {
            throw new AmqpRejectAndDontRequeueException("No correlation header in reply");
        }
        PendingReply pendingReply = this.replyHolder.get(messageTag);
        if (pendingReply == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Reply received after timeout for " + messageTag);
            }
            throw new AmqpRejectAndDontRequeueException("Reply received after timeout");
        }
        this.restoreProperties(message, pendingReply);
        pendingReply.reply(message);
    }

    private void restoreProperties(Message message, PendingReply pendingReply) {
        if (!this.userCorrelationId) {
            String savedCorrelation = pendingReply.getSavedCorrelation();
            if (this.correlationKey == null) {
                message.getMessageProperties().setCorrelationId(savedCorrelation);
            } else if (savedCorrelation != null) {
                message.getMessageProperties().setHeader(this.correlationKey, savedCorrelation);
            } else {
                message.getMessageProperties().getHeaders().remove(this.correlationKey);
            }
        }
        String savedReplyTo = pendingReply.getSavedReplyTo();
        message.getMessageProperties().setReplyTo(savedReplyTo);
        if (this.logger.isDebugEnabled() && savedReplyTo != null) {
            this.logger.debug("Restored replyTo to " + savedReplyTo);
        }
    }

    private DefaultConsumer createConsumer(final String queueName, Channel channel, final CompletableFuture<Delivery> future, long timeoutMillis) throws IOException, TimeoutException, InterruptedException {
        channel.basicQos(1);
        final CountDownLatch latch = new CountDownLatch(1);
        TemplateConsumer consumer = new TemplateConsumer(channel){

            @Override
            public void handleCancel(String consumerTag) {
                future.completeExceptionally(new ConsumerCancelledException());
            }

            @Override
            public void handleConsumeOk(String consumerTag) {
                super.handleConsumeOk(consumerTag);
                latch.countDown();
            }

            @Override
            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body2) {
                future.complete(new Delivery(consumerTag, envelope, properties, body2, queueName));
            }
        };
        channel.basicConsume(queueName, consumer);
        if (!latch.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
            if (channel instanceof ChannelProxy) {
                ((ChannelProxy)channel).getTargetChannel().close();
            }
            future.completeExceptionally(new ConsumeOkNotReceivedException("Blocking receive, consumer failed to consume within " + timeoutMillis + " ms: " + consumer));
        }
        return consumer;
    }

    @FunctionalInterface
    public static interface ReturnCallback {
        public void returnedMessage(Message var1, int var2, String var3, String var4, String var5);
    }

    @FunctionalInterface
    public static interface ConfirmCallback {
        public void confirm(@Nullable CorrelationData var1, boolean var2, @Nullable String var3);
    }

    protected static abstract class TemplateConsumer
    extends DefaultConsumer {
        public TemplateConsumer(Channel channel) {
            super(channel);
        }

        public String toString() {
            return "TemplateConsumer [channel=" + this.getChannel() + ", consumerTag=" + this.getConsumerTag() + "]";
        }
    }

    private static class PendingReply {
        @Nullable
        private volatile String savedReplyTo;
        @Nullable
        private volatile String savedCorrelation;
        private final CompletableFuture<Message> future = new CompletableFuture();

        private PendingReply() {
        }

        @Nullable
        public String getSavedReplyTo() {
            return this.savedReplyTo;
        }

        public void setSavedReplyTo(@Nullable String savedReplyTo) {
            this.savedReplyTo = savedReplyTo;
        }

        @Nullable
        public String getSavedCorrelation() {
            return this.savedCorrelation;
        }

        public void setSavedCorrelation(@Nullable String savedCorrelation) {
            this.savedCorrelation = savedCorrelation;
        }

        public Message get() throws InterruptedException {
            try {
                return this.future.get();
            }
            catch (ExecutionException e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException(e.getCause());
            }
        }

        @Nullable
        public Message get(long timeout, TimeUnit unit) throws InterruptedException {
            try {
                return this.future.get(timeout, unit);
            }
            catch (ExecutionException e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException(e.getCause());
            }
            catch (TimeoutException e) {
                return null;
            }
        }

        public void reply(Message reply) {
            this.future.complete(reply);
        }

        public void returned(AmqpMessageReturnedException e) {
            this.completeExceptionally(e);
        }

        public void completeExceptionally(Throwable t) {
            this.future.completeExceptionally(t);
        }
    }
}

