/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.BatchMessageListener;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.ConsumerChannelRegistry;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.SimpleResourceHolder;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.AsyncConsumerRestartedEvent;
import org.springframework.amqp.rabbit.listener.AsyncConsumerStartedEvent;
import org.springframework.amqp.rabbit.listener.AsyncConsumerStoppedEvent;
import org.springframework.amqp.rabbit.listener.BlockingQueueConsumer;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerFailedEvent;
import org.springframework.amqp.rabbit.listener.QueuesNotAvailableException;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareBatchMessageListener;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerExecutionException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerStartupException;
import org.springframework.amqp.rabbit.support.ActiveObjectCounter;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.amqp.rabbit.support.ListenerContainerAware;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.support.MetricType;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOffExecution;

public class SimpleMessageListenerContainer
extends AbstractMessageListenerContainer {
    private static final int RECOVERY_LOOP_WAIT_TIME = 200;
    private static final long DEFAULT_START_CONSUMER_MIN_INTERVAL = 10000L;
    private static final long DEFAULT_STOP_CONSUMER_MIN_INTERVAL = 60000L;
    private static final long DEFAULT_CONSUMER_START_TIMEOUT = 60000L;
    private static final int DEFAULT_CONSECUTIVE_ACTIVE_TRIGGER = 10;
    private static final int DEFAULT_CONSECUTIVE_IDLE_TRIGGER = 10;
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    private final AtomicLong lastNoMessageAlert = new AtomicLong();
    private final AtomicReference<Thread> containerStoppingForAbort = new AtomicReference();
    private final BlockingQueue<ListenerContainerConsumerFailedEvent> abortEvents = new LinkedBlockingQueue<ListenerContainerConsumerFailedEvent>();
    private long startConsumerMinInterval = 10000L;
    private long stopConsumerMinInterval = 60000L;
    private int consecutiveActiveTrigger = 10;
    private int consecutiveIdleTrigger = 10;
    private int batchSize = 1;
    private boolean consumerBatchEnabled;
    private long receiveTimeout = 1000L;
    private Set<BlockingQueueConsumer> consumers;
    private final ActiveObjectCounter<BlockingQueueConsumer> cancellationLock = new ActiveObjectCounter();
    private Integer declarationRetries;
    private Long retryDeclarationInterval;
    private TransactionTemplate transactionTemplate;
    private long consumerStartTimeout = 60000L;
    private volatile int concurrentConsumers = 1;
    private volatile Integer maxConcurrentConsumers;
    private volatile long lastConsumerStarted;
    private volatile long lastConsumerStopped;

    public SimpleMessageListenerContainer() {
    }

    public SimpleMessageListenerContainer(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue(concurrentConsumers > 0, "'concurrentConsumers' value must be at least 1 (one)");
        Assert.isTrue(!this.isExclusive() || concurrentConsumers == 1, "When the consumer is exclusive, the concurrency must be 1");
        if (this.maxConcurrentConsumers != null) {
            Assert.isTrue(concurrentConsumers <= this.maxConcurrentConsumers, "'concurrentConsumers' cannot be more than 'maxConcurrentConsumers'");
        }
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Changing consumers from " + this.concurrentConsumers + " to " + concurrentConsumers);
            }
            int delta = this.concurrentConsumers - concurrentConsumers;
            this.concurrentConsumers = concurrentConsumers;
            if (this.isActive()) {
                this.adjustConsumers(delta);
            }
        }
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        int delta;
        Assert.isTrue(maxConcurrentConsumers >= this.concurrentConsumers, "'maxConcurrentConsumers' value must be at least 'concurrentConsumers'");
        Assert.isTrue(!this.isExclusive() || maxConcurrentConsumers == 1, "When the consumer is exclusive, the concurrency must be 1");
        Integer oldMax = this.maxConcurrentConsumers;
        this.maxConcurrentConsumers = maxConcurrentConsumers;
        if (oldMax != null && this.isActive() && (delta = oldMax - maxConcurrentConsumers) > 0) {
            this.adjustConsumers(delta);
        }
    }

    public void setConcurrency(String concurrency) {
        try {
            int separatorIndex = concurrency.indexOf(45);
            if (separatorIndex != -1) {
                int consumersToSet = Integer.parseInt(concurrency.substring(0, separatorIndex));
                int maxConsumersToSet = Integer.parseInt(concurrency.substring(separatorIndex + 1));
                Assert.isTrue(maxConsumersToSet >= consumersToSet, "'maxConcurrentConsumers' value must be at least 'concurrentConsumers'");
                this.concurrentConsumers = 1;
                this.maxConcurrentConsumers = null;
                this.setConcurrentConsumers(consumersToSet);
                this.setMaxConcurrentConsumers(maxConsumersToSet);
            } else {
                this.setConcurrentConsumers(Integer.parseInt(concurrency));
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid concurrency value [" + concurrency + "]: only single fixed integer (e.g. \"5\") and minimum-maximum combo (e.g. \"3-5\") supported.", ex);
        }
    }

    @Override
    public final void setExclusive(boolean exclusive) {
        Assert.isTrue(!exclusive || this.concurrentConsumers == 1 && (this.maxConcurrentConsumers == null || this.maxConcurrentConsumers == 1), "When the consumer is exclusive, the concurrency must be 1");
        super.setExclusive(exclusive);
    }

    public final void setStartConsumerMinInterval(long startConsumerMinInterval) {
        Assert.isTrue(startConsumerMinInterval > 0L, "'startConsumerMinInterval' must be > 0");
        this.startConsumerMinInterval = startConsumerMinInterval;
    }

    public final void setStopConsumerMinInterval(long stopConsumerMinInterval) {
        Assert.isTrue(stopConsumerMinInterval > 0L, "'stopConsumerMinInterval' must be > 0");
        this.stopConsumerMinInterval = stopConsumerMinInterval;
    }

    public final void setConsecutiveActiveTrigger(int consecutiveActiveTrigger) {
        Assert.isTrue(consecutiveActiveTrigger > 0, "'consecutiveActiveTrigger' must be > 0");
        this.consecutiveActiveTrigger = consecutiveActiveTrigger;
    }

    public final void setConsecutiveIdleTrigger(int consecutiveIdleTrigger) {
        Assert.isTrue(consecutiveIdleTrigger > 0, "'consecutiveIdleTrigger' must be > 0");
        this.consecutiveIdleTrigger = consecutiveIdleTrigger;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setBatchSize(int batchSize) {
        Assert.isTrue(batchSize > 0, "'batchSize' must be > 0");
        this.batchSize = batchSize;
    }

    @Deprecated
    public void setTxSize(int txSize) {
        this.setBatchSize(txSize);
    }

    public void setConsumerBatchEnabled(boolean consumerBatchEnabled) {
        this.consumerBatchEnabled = consumerBatchEnabled;
    }

    @Override
    public boolean isConsumerBatchEnabled() {
        return this.consumerBatchEnabled;
    }

    @Override
    public void setMissingQueuesFatal(boolean missingQueuesFatal) {
        super.setMissingQueuesFatal(missingQueuesFatal);
    }

    @Override
    public void setQueueNames(String ... queueName) {
        super.setQueueNames(queueName);
        this.queuesChanged();
    }

    @Override
    public void addQueueNames(String ... queueName) {
        super.addQueueNames(queueName);
        this.queuesChanged();
    }

    @Override
    public boolean removeQueueNames(String ... queueName) {
        if (super.removeQueueNames(queueName)) {
            this.queuesChanged();
            return true;
        }
        return false;
    }

    @Override
    public void addQueues(Queue ... queue) {
        super.addQueues(queue);
        this.queuesChanged();
    }

    @Override
    public boolean removeQueues(Queue ... queue) {
        if (super.removeQueues(queue)) {
            this.queuesChanged();
            return true;
        }
        return false;
    }

    public void setDeclarationRetries(int declarationRetries) {
        this.declarationRetries = declarationRetries;
    }

    public void setRetryDeclarationInterval(long retryDeclarationInterval) {
        this.retryDeclarationInterval = retryDeclarationInterval;
    }

    public void setConsumerStartTimeout(long consumerStartTimeout) {
        this.consumerStartTimeout = consumerStartTimeout;
    }

    @Override
    protected void validateConfiguration() {
        super.validateConfiguration();
        Assert.state(!this.getAcknowledgeMode().isAutoAck() || this.getTransactionManager() == null, "The acknowledgeMode is NONE (autoack in Rabbit terms) which is not consistent with having an external transaction manager. Either use a different AcknowledgeMode or make sure the transactionManager is null.");
    }

    protected final boolean sharedConnectionEnabled() {
        return true;
    }

    @Override
    protected void doInitialize() {
        Assert.state(!this.consumerBatchEnabled || this.isDeBatchingEnabled(), "When setting 'consumerBatchEnabled' to true, 'deBatchingEnabled' must also be true");
    }

    @ManagedMetric(metricType=MetricType.GAUGE)
    public int getActiveConsumerCount() {
        return this.cancellationLock.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        Assert.state(!this.consumerBatchEnabled || this.getMessageListener() instanceof BatchMessageListener || this.getMessageListener() instanceof ChannelAwareBatchMessageListener, "When setting 'consumerBatchEnabled' to true, the listener must support batching");
        this.checkListenerContainerAware();
        super.doStart();
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers != null) {
                throw new IllegalStateException("A stopped container should not have consumers");
            }
            int newConsumers = this.initializeConsumers();
            if (this.consumers == null) {
                this.logger.info("Consumers were initialized and then cleared (presumably the container was stopped concurrently)");
                return;
            }
            if (newConsumers <= 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Consumers are already running");
                }
                return;
            }
            HashSet<AsyncMessageProcessingConsumer> processors = new HashSet<AsyncMessageProcessingConsumer>();
            for (BlockingQueueConsumer consumer : this.consumers) {
                AsyncMessageProcessingConsumer processor = new AsyncMessageProcessingConsumer(consumer);
                processors.add(processor);
                this.getTaskExecutor().execute(processor);
                if (this.getApplicationEventPublisher() == null) continue;
                this.getApplicationEventPublisher().publishEvent(new AsyncConsumerStartedEvent(this, consumer));
            }
            this.waitForConsumersToStart(processors);
        }
    }

    private void checkListenerContainerAware() {
        Collection<String> expectedQueueNames;
        if (this.getMessageListener() instanceof ListenerContainerAware && (expectedQueueNames = ((ListenerContainerAware)this.getMessageListener()).expectedQueueNames()) != null) {
            String[] queueNames = this.getQueueNames();
            Assert.state(expectedQueueNames.size() == queueNames.length, "Listener expects us to be listening on '" + expectedQueueNames + "'; our queues: " + Arrays.asList(queueNames));
            boolean found = false;
            for (String queueName : queueNames) {
                if (!expectedQueueNames.contains(queueName)) {
                    found = false;
                    break;
                }
                found = true;
            }
            Assert.state(found, () -> "Listener expects us to be listening on '" + expectedQueueNames + "'; our queues: " + Arrays.asList(queueNames));
        }
    }

    private void waitForConsumersToStart(Set<AsyncMessageProcessingConsumer> processors) {
        for (AsyncMessageProcessingConsumer processor : processors) {
            FatalListenerStartupException startupException = null;
            try {
                startupException = processor.getStartupException();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw RabbitExceptionTranslator.convertRabbitAccessException(e);
            }
            if (startupException == null) continue;
            throw new AmqpIllegalStateException("Fatal exception on listener startup", startupException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doShutdown() {
        Thread thread = this.containerStoppingForAbort.get();
        if (thread != null && !thread.equals(Thread.currentThread())) {
            this.logger.info("Shutdown ignored - container is stopping due to an aborted consumer");
            return;
        }
        try {
            ArrayList<BlockingQueueConsumer> canceledConsumers = new ArrayList<BlockingQueueConsumer>();
            Object object = this.consumersMonitor;
            synchronized (object) {
                if (this.consumers != null) {
                    Iterator<BlockingQueueConsumer> consumerIterator = this.consumers.iterator();
                    while (consumerIterator.hasNext()) {
                        BlockingQueueConsumer consumer2 = consumerIterator.next();
                        consumer2.basicCancel(true);
                        canceledConsumers.add(consumer2);
                        consumerIterator.remove();
                        if (!consumer2.declaring) continue;
                        consumer2.thread.interrupt();
                    }
                } else {
                    this.logger.info("Shutdown ignored - container is already stopped");
                    return;
                }
            }
            this.logger.info("Waiting for workers to finish.");
            boolean finished = this.cancellationLock.await(this.getShutdownTimeout(), TimeUnit.MILLISECONDS);
            if (finished) {
                this.logger.info("Successfully waited for workers to finish.");
            } else {
                this.logger.info("Workers not finished.");
                if (this.isForceCloseChannel()) {
                    canceledConsumers.forEach(consumer -> {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Closing channel for unresponsive consumer: " + consumer);
                        }
                        consumer.stop();
                    });
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Interrupted waiting for workers.  Continuing with shutdown.");
        }
        Object object = this.consumersMonitor;
        synchronized (object) {
            this.consumers = null;
            this.cancellationLock.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActive(BlockingQueueConsumer consumer) {
        boolean consumerActive;
        Object object = this.consumersMonitor;
        synchronized (object) {
            consumerActive = this.consumers != null && this.consumers.contains(consumer);
        }
        return consumerActive && this.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int initializeConsumers() {
        int count = 0;
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers == null) {
                this.cancellationLock.reset();
                this.consumers = new HashSet<BlockingQueueConsumer>(this.concurrentConsumers);
                for (int i2 = 0; i2 < this.concurrentConsumers; ++i2) {
                    BlockingQueueConsumer consumer = this.createBlockingQueueConsumer();
                    this.consumers.add(consumer);
                    ++count;
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustConsumers(int deltaArg) {
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.isActive() && this.consumers != null) {
                int delta;
                if (delta > 0) {
                    Iterator<BlockingQueueConsumer> consumerIterator = this.consumers.iterator();
                    for (delta = deltaArg; consumerIterator.hasNext() && delta > 0 && (this.maxConcurrentConsumers == null || this.consumers.size() > this.maxConcurrentConsumers); --delta) {
                        BlockingQueueConsumer consumer = consumerIterator.next();
                        consumer.basicCancel(true);
                        consumerIterator.remove();
                    }
                } else {
                    this.addAndStartConsumers(-delta);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAndStartConsumers(int delta) {
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers != null) {
                for (int i2 = 0; i2 < delta && (this.maxConcurrentConsumers == null || this.consumers.size() < this.maxConcurrentConsumers); ++i2) {
                    BlockingQueueConsumer consumer = this.createBlockingQueueConsumer();
                    this.consumers.add(consumer);
                    AsyncMessageProcessingConsumer processor = new AsyncMessageProcessingConsumer(consumer);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Starting a new consumer: " + consumer);
                    }
                    this.getTaskExecutor().execute(processor);
                    if (this.getApplicationEventPublisher() != null) {
                        this.getApplicationEventPublisher().publishEvent(new AsyncConsumerStartedEvent(this, consumer));
                    }
                    try {
                        FatalListenerStartupException startupException = processor.getStartupException();
                        if (startupException != null) {
                            this.consumers.remove(consumer);
                            throw new AmqpIllegalStateException("Fatal exception on listener startup", startupException);
                        }
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    catch (Exception e) {
                        consumer.stop();
                        this.logger.error("Error starting new consumer", e);
                        this.cancellationLock.release(consumer);
                        this.consumers.remove(consumer);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void considerAddingAConsumer() {
        Object object = this.consumersMonitor;
        synchronized (object) {
            long now;
            if (this.consumers != null && this.maxConcurrentConsumers != null && this.consumers.size() < this.maxConcurrentConsumers && this.lastConsumerStarted + this.startConsumerMinInterval < (now = System.currentTimeMillis())) {
                this.addAndStartConsumers(1);
                this.lastConsumerStarted = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void considerStoppingAConsumer(BlockingQueueConsumer consumer) {
        Object object = this.consumersMonitor;
        synchronized (object) {
            long now;
            if (this.consumers != null && this.consumers.size() > this.concurrentConsumers && this.lastConsumerStopped + this.stopConsumerMinInterval < (now = System.currentTimeMillis())) {
                consumer.basicCancel(true);
                this.consumers.remove(consumer);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Idle consumer terminating: " + consumer);
                }
                this.lastConsumerStopped = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuesChanged() {
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers != null) {
                int count = 0;
                Iterator<BlockingQueueConsumer> consumerIterator = this.consumers.iterator();
                while (consumerIterator.hasNext()) {
                    BlockingQueueConsumer consumer = consumerIterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Queues changed; stopping consumer: " + consumer);
                    }
                    consumer.basicCancel(true);
                    consumerIterator.remove();
                    ++count;
                }
                this.addAndStartConsumers(count);
            }
        }
    }

    protected BlockingQueueConsumer createBlockingQueueConsumer() {
        String[] queues = this.getQueueNames();
        int actualPrefetchCount = this.getPrefetchCount() > this.batchSize ? this.getPrefetchCount() : this.batchSize;
        BlockingQueueConsumer consumer = new BlockingQueueConsumer(this.getConnectionFactory(), this.getMessagePropertiesConverter(), this.cancellationLock, this.getAcknowledgeMode(), this.isChannelTransacted(), actualPrefetchCount, this.isDefaultRequeueRejected(), this.getConsumerArguments(), this.isNoLocal(), this.isExclusive(), queues);
        if (this.declarationRetries != null) {
            consumer.setDeclarationRetries(this.declarationRetries);
        }
        if (this.getFailedDeclarationRetryInterval() > 0L) {
            consumer.setFailedDeclarationRetryInterval(this.getFailedDeclarationRetryInterval());
        }
        if (this.retryDeclarationInterval != null) {
            consumer.setRetryDeclarationInterval(this.retryDeclarationInterval);
        }
        if (this.getConsumerTagStrategy() != null) {
            consumer.setTagStrategy(this.getConsumerTagStrategy());
        }
        consumer.setBackOffExecution(this.getRecoveryBackOff().start());
        consumer.setShutdownTimeout(this.getShutdownTimeout());
        consumer.setApplicationEventPublisher(this.getApplicationEventPublisher());
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart(BlockingQueueConsumer oldConsumer) {
        BlockingQueueConsumer consumer = oldConsumer;
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers != null) {
                try {
                    consumer.stop();
                    this.cancellationLock.release(consumer);
                    this.consumers.remove(consumer);
                    if (!this.isActive()) {
                        return;
                    }
                    BlockingQueueConsumer newConsumer = this.createBlockingQueueConsumer();
                    newConsumer.setBackOffExecution(consumer.getBackOffExecution());
                    consumer = newConsumer;
                    this.consumers.add(consumer);
                    if (this.getApplicationEventPublisher() != null) {
                        this.getApplicationEventPublisher().publishEvent(new AsyncConsumerRestartedEvent(this, oldConsumer, newConsumer));
                    }
                }
                catch (RuntimeException e) {
                    this.logger.warn("Consumer failed irretrievably on restart. " + e.getClass() + ": " + e.getMessage());
                    throw e;
                }
                this.getTaskExecutor().execute(new AsyncMessageProcessingConsumer(consumer));
            }
        }
    }

    private boolean receiveAndExecute(BlockingQueueConsumer consumer) throws Exception {
        PlatformTransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager != null) {
            try {
                if (this.transactionTemplate == null) {
                    this.transactionTemplate = new TransactionTemplate(transactionManager, this.getTransactionAttribute());
                }
                return this.transactionTemplate.execute(status -> {
                    RabbitResourceHolder resourceHolder = ConnectionFactoryUtils.bindResourceToTransaction(new RabbitResourceHolder(consumer.getChannel(), false), this.getConnectionFactory(), true);
                    try {
                        return this.doReceiveAndExecute(consumer);
                    }
                    catch (RuntimeException e1) {
                        this.prepareHolderForRollback(resourceHolder, e1);
                        throw e1;
                    }
                    catch (Exception e2) {
                        throw new AbstractMessageListenerContainer.WrappedTransactionException(e2);
                    }
                });
            }
            catch (AbstractMessageListenerContainer.WrappedTransactionException e) {
                throw (Exception)e.getCause();
            }
        }
        return this.doReceiveAndExecute(consumer);
    }

    private boolean doReceiveAndExecute(BlockingQueueConsumer consumer) throws Exception {
        Channel channel = consumer.getChannel();
        ArrayList<Message> messages = null;
        long deliveryTag = 0L;
        for (int i2 = 0; i2 < this.batchSize; ++i2) {
            this.logger.trace("Waiting for message from consumer.");
            Message message = consumer.nextMessage(this.receiveTimeout);
            if (message == null) break;
            if (this.consumerBatchEnabled) {
                Collection<MessagePostProcessor> afterReceivePostProcessors = this.getAfterReceivePostProcessors();
                if (afterReceivePostProcessors != null) {
                    Message original = message;
                    deliveryTag = message.getMessageProperties().getDeliveryTag();
                    for (MessagePostProcessor processor : this.getAfterReceivePostProcessors()) {
                        message = processor.postProcessMessage(message);
                        if (message != null) continue;
                        channel.basicAck(deliveryTag, false);
                        if (!this.logger.isDebugEnabled()) break;
                        this.logger.debug("Message Post Processor returned 'null', discarding message " + original);
                        break;
                    }
                }
                if (message == null) continue;
                if (messages == null) {
                    messages = new ArrayList<Message>(this.batchSize);
                }
                if (this.isDeBatchingEnabled() && this.getBatchingStrategy().canDebatch(message.getMessageProperties())) {
                    ArrayList<Message> messageList = messages;
                    this.getBatchingStrategy().deBatch(message, fragment -> messageList.add((Message)fragment));
                    continue;
                }
                messages.add(message);
                continue;
            }
            try {
                this.executeListener(channel, message);
                continue;
            }
            catch (ImmediateAcknowledgeAmqpException e) {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug("User requested ack for failed delivery '" + e.getMessage() + "': " + message.getMessageProperties().getDeliveryTag());
                break;
            }
            catch (Exception ex) {
                if (this.causeChainHasImmediateAcknowledgeAmqpException(ex)) {
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("User requested ack for failed delivery: " + message.getMessageProperties().getDeliveryTag());
                    break;
                }
                if (this.getTransactionManager() != null) {
                    if (this.getTransactionAttribute().rollbackOn(ex)) {
                        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)TransactionSynchronizationManager.getResource(this.getConnectionFactory());
                        if (resourceHolder != null) {
                            consumer.clearDeliveryTags();
                        } else {
                            consumer.rollbackOnExceptionIfNecessary(ex);
                        }
                        throw ex;
                    }
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("No rollback for " + ex);
                    break;
                }
                consumer.rollbackOnExceptionIfNecessary(ex);
                throw ex;
            }
        }
        if (this.consumerBatchEnabled && messages != null) {
            this.executeWithList(channel, messages, deliveryTag, consumer);
        }
        return consumer.commitIfNecessary(this.isChannelLocallyTransacted());
    }

    private void executeWithList(Channel channel, List<Message> messages, long deliveryTag, BlockingQueueConsumer consumer) {
        try {
            this.executeListener(channel, messages);
        }
        catch (ImmediateAcknowledgeAmqpException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("User requested ack for failed delivery '" + e.getMessage() + "' (last in batch): " + deliveryTag);
            }
            return;
        }
        catch (Exception ex) {
            if (this.causeChainHasImmediateAcknowledgeAmqpException(ex)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("User requested ack for failed delivery (last in batch): " + deliveryTag);
                }
                return;
            }
            if (this.getTransactionManager() != null) {
                if (this.getTransactionAttribute().rollbackOn(ex)) {
                    RabbitResourceHolder resourceHolder = (RabbitResourceHolder)TransactionSynchronizationManager.getResource(this.getConnectionFactory());
                    if (resourceHolder != null) {
                        consumer.clearDeliveryTags();
                    } else {
                        consumer.rollbackOnExceptionIfNecessary(ex);
                    }
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No rollback for " + ex);
                }
            }
            consumer.rollbackOnExceptionIfNecessary(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStartupFailure(BackOffExecution backOffExecution) {
        long recoveryInterval = backOffExecution.nextBackOff();
        if (-1L == recoveryInterval) {
            SimpleMessageListenerContainer simpleMessageListenerContainer = this;
            synchronized (simpleMessageListenerContainer) {
                if (this.isActive()) {
                    this.logger.warn("stopping container - restart recovery attempts exhausted");
                    this.stop();
                }
            }
            return;
        }
        try {
            if (this.logger.isDebugEnabled() && this.isActive()) {
                this.logger.debug("Recovering consumer in " + recoveryInterval + " ms.");
            }
            long timeout = System.currentTimeMillis() + recoveryInterval;
            while (this.isActive() && System.currentTimeMillis() < timeout) {
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Irrecoverable interruption on consumer restart", e);
        }
    }

    @Override
    protected void publishConsumerFailedEvent(String reason, boolean fatal, Throwable t) {
        if (!fatal || !this.isRunning()) {
            super.publishConsumerFailedEvent(reason, fatal, t);
        } else {
            try {
                this.abortEvents.put(new ListenerContainerConsumerFailedEvent(this, reason, t, fatal));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return "SimpleMessageListenerContainer " + (this.getBeanName() != null ? "(" + this.getBeanName() + ") " : "") + "[concurrentConsumers=" + this.concurrentConsumers + (this.maxConcurrentConsumers != null ? ", maxConcurrentConsumers=" + this.maxConcurrentConsumers : "") + ", queueNames=" + Arrays.toString(this.getQueueNames()) + "]";
    }

    private final class AsyncMessageProcessingConsumer
    implements Runnable {
        private static final int ABORT_EVENT_WAIT_SECONDS = 5;
        private final BlockingQueueConsumer consumer;
        private final CountDownLatch start;
        private volatile FatalListenerStartupException startupException;
        private int consecutiveIdles;
        private int consecutiveMessages;

        AsyncMessageProcessingConsumer(BlockingQueueConsumer consumer) {
            this.consumer = consumer;
            this.start = new CountDownLatch(1);
        }

        private FatalListenerStartupException getStartupException() throws InterruptedException {
            if (!this.start.await(SimpleMessageListenerContainer.this.consumerStartTimeout, TimeUnit.MILLISECONDS)) {
                SimpleMessageListenerContainer.this.logger.error("Consumer failed to start in " + SimpleMessageListenerContainer.this.consumerStartTimeout + " milliseconds; does the task executor have enough threads to support the container concurrency?");
            }
            return this.startupException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!SimpleMessageListenerContainer.this.isActive()) {
                return;
            }
            boolean aborted = false;
            this.consumer.setLocallyTransacted(SimpleMessageListenerContainer.this.isChannelLocallyTransacted());
            String routingLookupKey = SimpleMessageListenerContainer.this.getRoutingLookupKey();
            if (routingLookupKey != null) {
                SimpleResourceHolder.bind(SimpleMessageListenerContainer.this.getRoutingConnectionFactory(), routingLookupKey);
            }
            if (this.consumer.getQueueCount() < 1) {
                if (SimpleMessageListenerContainer.this.logger.isDebugEnabled()) {
                    SimpleMessageListenerContainer.this.logger.debug("Consumer stopping; no queues for " + this.consumer);
                }
                SimpleMessageListenerContainer.this.cancellationLock.release(this.consumer);
                if (SimpleMessageListenerContainer.this.getApplicationEventPublisher() != null) {
                    SimpleMessageListenerContainer.this.getApplicationEventPublisher().publishEvent(new AsyncConsumerStoppedEvent(SimpleMessageListenerContainer.this, this.consumer));
                }
                this.start.countDown();
                return;
            }
            try {
                this.initialize();
                while (SimpleMessageListenerContainer.this.isActive(this.consumer) || this.consumer.hasDelivery() || !this.consumer.cancelled()) {
                    this.mainLoop();
                }
            }
            catch (InterruptedException e) {
                SimpleMessageListenerContainer.this.logger.debug("Consumer thread interrupted, processing stopped.");
                Thread.currentThread().interrupt();
                aborted = true;
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer thread interrupted, processing stopped", true, e);
            }
            catch (QueuesNotAvailableException ex) {
                SimpleMessageListenerContainer.this.logger.error("Consumer threw missing queues exception, fatal=" + SimpleMessageListenerContainer.this.isMissingQueuesFatal(), ex);
                if (SimpleMessageListenerContainer.this.isMissingQueuesFatal()) {
                    this.startupException = ex;
                    aborted = true;
                }
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer queue(s) not available", aborted, ex);
            }
            catch (FatalListenerStartupException ex) {
                SimpleMessageListenerContainer.this.logger.error("Consumer received fatal exception on startup", ex);
                this.startupException = ex;
                aborted = true;
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer received fatal exception on startup", true, ex);
            }
            catch (FatalListenerExecutionException ex) {
                SimpleMessageListenerContainer.this.logger.error("Consumer received fatal exception during processing", ex);
                aborted = true;
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer received fatal exception during processing", true, ex);
            }
            catch (PossibleAuthenticationFailureException ex) {
                SimpleMessageListenerContainer.this.logger.error("Consumer received fatal=" + SimpleMessageListenerContainer.this.isPossibleAuthenticationFailureFatal() + " exception during processing", ex);
                if (SimpleMessageListenerContainer.this.isPossibleAuthenticationFailureFatal()) {
                    this.startupException = new FatalListenerStartupException("Authentication failure", new AmqpAuthenticationException(ex));
                    aborted = true;
                }
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer received PossibleAuthenticationFailure during startup", aborted, ex);
            }
            catch (ShutdownSignalException e) {
                if (RabbitUtils.isNormalShutdown(e)) {
                    if (SimpleMessageListenerContainer.this.logger.isDebugEnabled()) {
                        SimpleMessageListenerContainer.this.logger.debug("Consumer received Shutdown Signal, processing stopped: " + e.getMessage());
                    }
                } else {
                    this.logConsumerException(e);
                }
            }
            catch (AmqpIOException e) {
                if (e.getCause() instanceof IOException && e.getCause().getCause() instanceof ShutdownSignalException && e.getCause().getCause().getMessage().contains("in exclusive use")) {
                    SimpleMessageListenerContainer.this.getExclusiveConsumerExceptionLogger().log(SimpleMessageListenerContainer.this.logger, "Exclusive consumer failure", e.getCause().getCause());
                    SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer raised exception, attempting restart", false, e);
                } else {
                    this.logConsumerException(e);
                }
            }
            catch (Error e) {
                SimpleMessageListenerContainer.this.logger.error("Consumer thread error, thread abort.", e);
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer threw an Error", true, e);
                aborted = true;
            }
            catch (Throwable t) {
                if (SimpleMessageListenerContainer.this.isActive()) {
                    this.logConsumerException(t);
                }
            }
            finally {
                if (SimpleMessageListenerContainer.this.getTransactionManager() != null) {
                    ConsumerChannelRegistry.unRegisterConsumerChannel();
                }
            }
            this.start.countDown();
            this.killOrRestart(aborted);
            if (routingLookupKey != null) {
                SimpleResourceHolder.unbind(SimpleMessageListenerContainer.this.getRoutingConnectionFactory());
            }
        }

        private void mainLoop() throws Exception {
            try {
                long idleEventInterval;
                boolean receivedOk = SimpleMessageListenerContainer.this.receiveAndExecute(this.consumer);
                if (SimpleMessageListenerContainer.this.maxConcurrentConsumers != null) {
                    this.checkAdjust(receivedOk);
                }
                if ((idleEventInterval = SimpleMessageListenerContainer.this.getIdleEventInterval()) > 0L) {
                    if (receivedOk) {
                        SimpleMessageListenerContainer.this.updateLastReceive();
                    } else {
                        long now = System.currentTimeMillis();
                        long lastAlertAt = SimpleMessageListenerContainer.this.lastNoMessageAlert.get();
                        long lastReceive = SimpleMessageListenerContainer.this.getLastReceive();
                        if (now > lastReceive + idleEventInterval && now > lastAlertAt + idleEventInterval && SimpleMessageListenerContainer.this.lastNoMessageAlert.compareAndSet(lastAlertAt, now)) {
                            SimpleMessageListenerContainer.this.publishIdleContainerEvent(now - lastReceive);
                        }
                    }
                }
            }
            catch (ListenerExecutionFailedException ex) {
                if (ex.getCause() instanceof NoSuchMethodException) {
                    throw new FatalListenerExecutionException("Invalid listener", ex);
                }
            }
            catch (AmqpRejectAndDontRequeueException amqpRejectAndDontRequeueException) {
                // empty catch block
            }
        }

        private void checkAdjust(boolean receivedOk) {
            if (receivedOk) {
                if (SimpleMessageListenerContainer.this.isActive(this.consumer)) {
                    this.consecutiveIdles = 0;
                    if (this.consecutiveMessages++ > SimpleMessageListenerContainer.this.consecutiveActiveTrigger) {
                        SimpleMessageListenerContainer.this.considerAddingAConsumer();
                        this.consecutiveMessages = 0;
                    }
                }
            } else {
                this.consecutiveMessages = 0;
                if (this.consecutiveIdles++ > SimpleMessageListenerContainer.this.consecutiveIdleTrigger) {
                    SimpleMessageListenerContainer.this.considerStoppingAConsumer(this.consumer);
                    this.consecutiveIdles = 0;
                }
            }
        }

        private void initialize() throws Throwable {
            try {
                SimpleMessageListenerContainer.this.redeclareElementsIfNecessary();
                this.consumer.start();
                this.start.countDown();
            }
            catch (QueuesNotAvailableException e) {
                if (SimpleMessageListenerContainer.this.isMissingQueuesFatal()) {
                    throw e;
                }
                this.start.countDown();
                SimpleMessageListenerContainer.this.handleStartupFailure(this.consumer.getBackOffExecution());
                throw e;
            }
            catch (FatalListenerStartupException ex) {
                if (SimpleMessageListenerContainer.this.isPossibleAuthenticationFailureFatal()) {
                    throw ex;
                }
                Throwable possibleAuthException = ex.getCause().getCause();
                if (!(possibleAuthException instanceof PossibleAuthenticationFailureException)) {
                    throw ex;
                }
                this.start.countDown();
                SimpleMessageListenerContainer.this.handleStartupFailure(this.consumer.getBackOffExecution());
                throw possibleAuthException;
            }
            catch (Throwable t) {
                this.start.countDown();
                SimpleMessageListenerContainer.this.handleStartupFailure(this.consumer.getBackOffExecution());
                throw t;
            }
            if (SimpleMessageListenerContainer.this.getTransactionManager() != null) {
                ConsumerChannelRegistry.registerConsumerChannel(this.consumer.getChannel(), SimpleMessageListenerContainer.this.getConnectionFactory());
            }
        }

        private void killOrRestart(boolean aborted) {
            if (!SimpleMessageListenerContainer.this.isActive(this.consumer) || aborted) {
                SimpleMessageListenerContainer.this.logger.debug("Cancelling " + this.consumer);
                try {
                    this.consumer.stop();
                    SimpleMessageListenerContainer.this.cancellationLock.release(this.consumer);
                    if (SimpleMessageListenerContainer.this.getApplicationEventPublisher() != null) {
                        SimpleMessageListenerContainer.this.getApplicationEventPublisher().publishEvent(new AsyncConsumerStoppedEvent(SimpleMessageListenerContainer.this, this.consumer));
                    }
                }
                catch (AmqpException e) {
                    SimpleMessageListenerContainer.this.logger.info("Could not cancel message consumer", e);
                }
                if (aborted && SimpleMessageListenerContainer.this.containerStoppingForAbort.compareAndSet(null, Thread.currentThread())) {
                    SimpleMessageListenerContainer.this.logger.error("Stopping container from aborted consumer");
                    SimpleMessageListenerContainer.this.stop();
                    SimpleMessageListenerContainer.this.containerStoppingForAbort.set(null);
                    ListenerContainerConsumerFailedEvent event = null;
                    do {
                        try {
                            event = (ListenerContainerConsumerFailedEvent)SimpleMessageListenerContainer.this.abortEvents.poll(5L, TimeUnit.SECONDS);
                            if (event == null) continue;
                            SimpleMessageListenerContainer.this.publishConsumerFailedEvent(event.getReason(), event.isFatal(), event.getThrowable());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    } while (event != null);
                }
            } else {
                SimpleMessageListenerContainer.this.logger.info("Restarting " + this.consumer);
                SimpleMessageListenerContainer.this.restart(this.consumer);
            }
        }

        private void logConsumerException(Throwable t) {
            if (SimpleMessageListenerContainer.this.logger.isDebugEnabled() || !(t instanceof AmqpConnectException) && !(t instanceof ConsumerCancelledException)) {
                SimpleMessageListenerContainer.this.logger.debug("Consumer raised exception, processing can restart if the connection factory supports it", t);
            } else if (t instanceof ConsumerCancelledException && this.consumer.isNormalCancel()) {
                if (SimpleMessageListenerContainer.this.logger.isDebugEnabled()) {
                    SimpleMessageListenerContainer.this.logger.debug("Consumer raised exception, processing can restart if the connection factory supports it. Exception summary: " + t);
                }
            } else if (SimpleMessageListenerContainer.this.logger.isWarnEnabled()) {
                SimpleMessageListenerContainer.this.logger.warn("Consumer raised exception, processing can restart if the connection factory supports it. Exception summary: " + t);
            }
            SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer raised exception, attempting restart", false, t);
        }
    }
}

