/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support;

import com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpTimeoutException;
import org.springframework.amqp.AmqpUnsupportedEncodingException;
import org.springframework.amqp.UncategorizedAmqpException;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.util.Assert;

public final class RabbitExceptionTranslator {
    private RabbitExceptionTranslator() {
    }

    public static RuntimeException convertRabbitAccessException(Throwable ex) {
        Assert.notNull((Object)ex, "Exception must not be null");
        if (ex instanceof AmqpException) {
            return (AmqpException)ex;
        }
        if (ex instanceof ShutdownSignalException) {
            return new AmqpConnectException((ShutdownSignalException)ex);
        }
        if (ex instanceof ConnectException) {
            return new AmqpConnectException((ConnectException)ex);
        }
        if (ex instanceof PossibleAuthenticationFailureException) {
            return new AmqpAuthenticationException(ex);
        }
        if (ex instanceof UnsupportedEncodingException) {
            return new AmqpUnsupportedEncodingException(ex);
        }
        if (ex instanceof IOException) {
            return new AmqpIOException((IOException)ex);
        }
        if (ex instanceof TimeoutException) {
            return new AmqpTimeoutException(ex);
        }
        if (ex instanceof com.rabbitmq.client.ConsumerCancelledException) {
            return new ConsumerCancelledException(ex);
        }
        if (ex instanceof ConsumerCancelledException) {
            throw (ConsumerCancelledException)ex;
        }
        return new UncategorizedAmqpException(ex);
    }
}

