/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RetryTemplateFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public abstract class AbstractRabbitListenerContainerFactoryConfigurer<T extends AbstractRabbitListenerContainerFactory<?>> {
    private MessageConverter messageConverter;
    private MessageRecoverer messageRecoverer;
    private List<RabbitRetryTemplateCustomizer> retryTemplateCustomizers;
    private RabbitProperties rabbitProperties;

    protected void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected void setMessageRecoverer(MessageRecoverer messageRecoverer) {
        this.messageRecoverer = messageRecoverer;
    }

    protected void setRetryTemplateCustomizers(List<RabbitRetryTemplateCustomizer> retryTemplateCustomizers) {
        this.retryTemplateCustomizers = retryTemplateCustomizers;
    }

    protected void setRabbitProperties(RabbitProperties rabbitProperties) {
        this.rabbitProperties = rabbitProperties;
    }

    protected final RabbitProperties getRabbitProperties() {
        return this.rabbitProperties;
    }

    public abstract void configure(T var1, ConnectionFactory var2);

    protected void configure(T factory, ConnectionFactory connectionFactory, RabbitProperties.AmqpContainer configuration) {
        Assert.notNull(factory, "Factory must not be null");
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
        Assert.notNull((Object)configuration, "Configuration must not be null");
        ((AbstractRabbitListenerContainerFactory)factory).setConnectionFactory(connectionFactory);
        if (this.messageConverter != null) {
            ((AbstractRabbitListenerContainerFactory)factory).setMessageConverter(this.messageConverter);
        }
        ((AbstractRabbitListenerContainerFactory)factory).setAutoStartup(configuration.isAutoStartup());
        if (configuration.getAcknowledgeMode() != null) {
            ((AbstractRabbitListenerContainerFactory)factory).setAcknowledgeMode(configuration.getAcknowledgeMode());
        }
        if (configuration.getPrefetch() != null) {
            ((AbstractRabbitListenerContainerFactory)factory).setPrefetchCount(configuration.getPrefetch());
        }
        if (configuration.getDefaultRequeueRejected() != null) {
            ((AbstractRabbitListenerContainerFactory)factory).setDefaultRequeueRejected(configuration.getDefaultRequeueRejected());
        }
        if (configuration.getIdleEventInterval() != null) {
            ((AbstractRabbitListenerContainerFactory)factory).setIdleEventInterval(configuration.getIdleEventInterval().toMillis());
        }
        ((AbstractRabbitListenerContainerFactory)factory).setMissingQueuesFatal(configuration.isMissingQueuesFatal());
        RabbitProperties.ListenerRetry retryConfig = configuration.getRetry();
        if (retryConfig.isEnabled()) {
            RetryInterceptorBuilder builder = retryConfig.isStateless() ? RetryInterceptorBuilder.stateless() : RetryInterceptorBuilder.stateful();
            RetryTemplate retryTemplate = new RetryTemplateFactory(this.retryTemplateCustomizers).createRetryTemplate(retryConfig, RabbitRetryTemplateCustomizer.Target.LISTENER);
            builder.retryOperations(retryTemplate);
            MessageRecoverer recoverer = this.messageRecoverer != null ? this.messageRecoverer : new RejectAndDontRequeueRecoverer();
            builder.recoverer(recoverer);
            ((AbstractRabbitListenerContainerFactory)factory).setAdviceChain(new Advice[]{builder.build()});
        }
    }
}

