/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.CollectionElementFacetBuilder;
import springfox.documentation.builders.ElementFacetBuilder;
import springfox.documentation.builders.ElementFacets;
import springfox.documentation.builders.EnumerationElementFacetBuilder;
import springfox.documentation.builders.StringElementFacetBuilder;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.NumericElementFacetBuilder;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.VendorExtension;

public class PropertySpecificationBuilder {
    private final String name;
    private String description;
    private ModelSpecification type;
    private Boolean nullable;
    private Boolean required;
    private Boolean readOnly;
    private Boolean writeOnly;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private Boolean isHidden;
    private int position;
    private Object example;
    private Object defaultValue;
    private Xml xml;
    private final Map<Class<?>, ElementFacetBuilder> facetBuilders = new HashMap();
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();

    public PropertySpecificationBuilder(String name) {
        this.name = name;
    }

    public PropertySpecificationBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(BuilderDefaults.emptyToNull(description), this.description);
        return this;
    }

    public PropertySpecificationBuilder type(ModelSpecification type) {
        this.type = BuilderDefaults.defaultIfAbsent(type, this.type);
        return this;
    }

    public <T extends ElementFacetBuilder> T facetBuilder(Class<T> clazz) {
        this.facetBuilders.computeIfAbsent(clazz, ElementFacets.builderFactory(clazz));
        return (T)this.facetBuilders.get(clazz);
    }

    public PropertySpecificationBuilder collectionFacet(@NonNull Consumer<CollectionElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(CollectionElementFacetBuilder.class));
        return this;
    }

    public PropertySpecificationBuilder stringFacet(@NonNull Consumer<StringElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(StringElementFacetBuilder.class));
        return this;
    }

    public PropertySpecificationBuilder numericFacet(@NonNull Consumer<NumericElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(NumericElementFacetBuilder.class));
        return this;
    }

    public PropertySpecificationBuilder enumerationFacet(@NonNull Consumer<EnumerationElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(EnumerationElementFacetBuilder.class));
        return this;
    }

    public PropertySpecificationBuilder nullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public PropertySpecificationBuilder required(Boolean required) {
        this.required = required;
        return this;
    }

    public PropertySpecificationBuilder readOnly(Boolean readOnly) {
        this.readOnly = BuilderDefaults.defaultIfAbsent(Boolean.TRUE.equals(readOnly) ? Boolean.valueOf(true) : null, this.readOnly);
        return this;
    }

    public PropertySpecificationBuilder writeOnly(Boolean writeOnly) {
        this.writeOnly = BuilderDefaults.defaultIfAbsent(Boolean.TRUE.equals(writeOnly) ? Boolean.valueOf(true) : null, this.writeOnly);
        return this;
    }

    public PropertySpecificationBuilder deprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public PropertySpecificationBuilder allowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        return this;
    }

    public PropertySpecificationBuilder isHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public PropertySpecificationBuilder position(int position) {
        this.position = position;
        return this;
    }

    public PropertySpecificationBuilder example(Object example) {
        this.example = example;
        return this;
    }

    public PropertySpecificationBuilder defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public PropertySpecificationBuilder xml(Xml xml) {
        this.xml = xml;
        return this;
    }

    public PropertySpecificationBuilder vendorExtensions(List<VendorExtension> vendorExtensions) {
        this.vendorExtensions.addAll(vendorExtensions);
        return this;
    }

    public PropertySpecification build() {
        List<ElementFacet> facets = this.facetBuilders.values().stream().filter(Objects::nonNull).map(ElementFacetBuilder::build).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.xml != null && StringUtils.isEmpty(this.xml.getName())) {
            this.xml.setName(this.name);
        }
        return new PropertySpecification(this.name, this.description, this.type, facets, this.nullable, this.required, this.readOnly, this.writeOnly, this.deprecated, this.allowEmptyValue, this.isHidden, this.position, this.example, this.defaultValue, this.xml, this.vendorExtensions);
    }
}

