/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.common;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

public abstract class ClassNotPresentInClassPathCondition
implements Condition {
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return !ClassNotPresentInClassPathCondition.isPresent(this.getClassName(), context.getClassLoader());
    }

    protected abstract String getClassName();

    private static boolean isPresent(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        try {
            ClassUtils.forName(className, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

