/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.web;

import java.util.Enumeration;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.util.UrlPathHelper;

class ForwardedPrefixExtractor {
    private final Supplier<HttpServletRequest> delegate;
    private final UrlPathHelper pathHelper;
    private final String baseUrl;
    private String actualRequestUri;
    private final String forwardedPrefix;
    private String requestUri;
    private String requestUrl;

    ForwardedPrefixExtractor(Supplier<HttpServletRequest> delegateRequest, UrlPathHelper pathHelper, String baseUrl) {
        this.delegate = delegateRequest;
        this.pathHelper = pathHelper;
        this.baseUrl = baseUrl;
        this.actualRequestUri = delegateRequest.get().getRequestURI();
        this.forwardedPrefix = ForwardedPrefixExtractor.initForwardedPrefix(delegateRequest.get());
        this.requestUri = this.initRequestUri();
        this.requestUrl = this.initRequestUrl();
    }

    private static String initForwardedPrefix(HttpServletRequest request) {
        String result = null;
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (!"X-Forwarded-Prefix".equalsIgnoreCase(name)) continue;
            result = request.getHeader(name);
        }
        if (result != null) {
            while (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    private String initRequestUri() {
        if (this.forwardedPrefix != null) {
            return this.forwardedPrefix + this.pathHelper.getPathWithinApplication(this.delegate.get());
        }
        return null;
    }

    private String initRequestUrl() {
        return this.baseUrl + (this.requestUri != null ? this.requestUri : this.delegate.get().getRequestURI());
    }

    public String getContextPath() {
        return this.forwardedPrefix == null ? this.delegate.get().getContextPath() : this.forwardedPrefix;
    }

    public String getRequestUri() {
        if (this.requestUri == null) {
            return this.delegate.get().getRequestURI();
        }
        this.recalculatePathsIfNecessary();
        return this.requestUri;
    }

    public StringBuffer getRequestUrl() {
        this.recalculatePathsIfNecessary();
        return new StringBuffer(this.requestUrl);
    }

    private void recalculatePathsIfNecessary() {
        if (!this.actualRequestUri.equals(this.delegate.get().getRequestURI())) {
            this.actualRequestUri = this.delegate.get().getRequestURI();
            this.requestUri = this.initRequestUri();
            this.requestUrl = this.initRequestUrl();
        }
    }
}

