/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.web;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.oas.mappers.ServiceModelToOpenApiMapper;
import springfox.documentation.oas.web.OpenApiTransformationContext;
import springfox.documentation.oas.web.WebMvcOpenApiTransformationFilter;
import springfox.documentation.service.Documentation;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.OnServletBasedWebApplication;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;

@ApiIgnore
@RestController
@RequestMapping(value={"${springfox.documentation.open-api.v3.path:/v3/api-docs}"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Conditional(value={OnServletBasedWebApplication.class})
public class OpenApiControllerWebMvc {
    private final DocumentationCache documentationCache;
    private final ServiceModelToOpenApiMapper mapper;
    private final JsonSerializer jsonSerializer;
    private final PluginRegistry<WebMvcOpenApiTransformationFilter, DocumentationType> transformations;

    @Autowired
    public OpenApiControllerWebMvc(DocumentationCache documentationCache, ServiceModelToOpenApiMapper mapper, JsonSerializer jsonSerializer, @Qualifier(value="webMvcOpenApiTransformationFilterRegistry") PluginRegistry<WebMvcOpenApiTransformationFilter, DocumentationType> transformations) {
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.jsonSerializer = jsonSerializer;
        this.transformations = transformations;
    }

    @GetMapping(produces={"application/json", "application/hal+json"})
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String group, HttpServletRequest servletRequest) {
        String groupName = Optional.ofNullable(group).orElse("default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity<Json>(HttpStatus.NOT_FOUND);
        }
        OpenAPI oas = this.mapper.mapDocumentation(documentation);
        OpenApiTransformationContext<HttpServletRequest> context = new OpenApiTransformationContext<HttpServletRequest>(oas, servletRequest);
        List<WebMvcOpenApiTransformationFilter> filters = this.transformations.getPluginsFor(DocumentationType.OAS_30);
        for (WebMvcOpenApiTransformationFilter each : filters) {
            context = context.next(each.transform(context));
        }
        return new ResponseEntity<Json>(this.jsonSerializer.toJson(oas), HttpStatus.OK);
    }
}

