/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.classmate.members.ResolvedParameterizedMember;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.service.ResolvedMethodParameter;

public class HandlerMethodResolver {
    private static final String SPRING4_DISCOVERER = "org.springframework.core.DefaultParameterNameDiscoverer";
    private final ParameterNameDiscoverer parameterNameDiscover = this.parameterNameDiscoverer();
    private final TypeResolver typeResolver;
    private Map<Class, List<ResolvedMethod>> methodsResolvedForHostClasses = new HashMap<Class, List<ResolvedMethod>>();

    public HandlerMethodResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public ResolvedType methodReturnType(HandlerMethod handlerMethod) {
        return this.resolvedMethod(handlerMethod).map(HandlerMethodResolver.toReturnType(this.typeResolver)).orElse(this.typeResolver.resolve(Void.TYPE, new Type[0]));
    }

    public static Optional<Class> useType(Class beanType) {
        if (Proxy.class.isAssignableFrom(beanType)) {
            return Optional.empty();
        }
        if (Class.class.getName().equals(beanType.getName())) {
            return Optional.empty();
        }
        return Optional.ofNullable(beanType);
    }

    public List<ResolvedMethodParameter> methodParameters(HandlerMethod methodToResolve) {
        return this.resolvedMethod(methodToResolve).map(this.toParameters(methodToResolve)).orElse(new ArrayList());
    }

    private boolean contravariant(ResolvedType candidateMethodReturnValue, Type returnValueOnMethod) {
        return this.isSubClass(candidateMethodReturnValue, returnValueOnMethod) || this.isGenericTypeSubclass(candidateMethodReturnValue, returnValueOnMethod);
    }

    static Comparator<ResolvedMethod> byArgumentCount() {
        return Comparator.comparingInt(ResolvedParameterizedMember::getArgumentCount);
    }

    boolean bothAreVoids(ResolvedType candidateMethodReturnValue, Type returnType) {
        return !(Void.class != candidateMethodReturnValue.getErasedType() && Void.TYPE != candidateMethodReturnValue.getErasedType() || Void.TYPE != returnType && Void.class != returnType);
    }

    boolean isGenericTypeSubclass(ResolvedType candidateMethodReturnValue, Type returnValueOnMethod) {
        return returnValueOnMethod instanceof ParameterizedType && candidateMethodReturnValue.getErasedType().isAssignableFrom((Class)((ParameterizedType)returnValueOnMethod).getRawType());
    }

    boolean isSubClass(ResolvedType candidateMethodReturnValue, Type returnValueOnMethod) {
        return returnValueOnMethod instanceof Class && candidateMethodReturnValue.getErasedType().isAssignableFrom((Class)returnValueOnMethod);
    }

    boolean covariant(ResolvedType candidateMethodArgument, Type argumentOnMethod) {
        return this.isSuperClass(candidateMethodArgument, argumentOnMethod) || this.isGenericTypeSuperClass(candidateMethodArgument, argumentOnMethod);
    }

    boolean isGenericTypeSuperClass(ResolvedType candidateMethodArgument, Type argumentOnMethod) {
        return argumentOnMethod instanceof ParameterizedType && ((Class)((ParameterizedType)argumentOnMethod).getRawType()).isAssignableFrom(candidateMethodArgument.getErasedType());
    }

    boolean isSuperClass(ResolvedType candidateMethodArgument, Type argumentOnMethod) {
        return argumentOnMethod instanceof Class && ((Class)argumentOnMethod).isAssignableFrom(candidateMethodArgument.getErasedType());
    }

    private Optional<ResolvedMethod> resolvedMethod(HandlerMethod handlerMethod) {
        if (handlerMethod == null) {
            return Optional.empty();
        }
        Class<?> hostClass = HandlerMethodResolver.useType(handlerMethod.getBeanType()).orElse(handlerMethod.getMethod().getDeclaringClass());
        Iterable filtered = this.getMemberMethods(hostClass).stream().filter(HandlerMethodResolver.methodNamesAreSame(handlerMethod.getMethod())).collect(Collectors.toList());
        return this.resolveToMethodWithMaxResolvedTypes(filtered, handlerMethod.getMethod());
    }

    private List<ResolvedMethod> getMemberMethods(Class hostClass) {
        if (!this.methodsResolvedForHostClasses.containsKey(hostClass)) {
            ResolvedType beanType = this.typeResolver.resolve(hostClass, new Type[0]);
            MemberResolver resolver = new MemberResolver(this.typeResolver);
            resolver.setIncludeLangObject(false);
            ResolvedTypeWithMembers typeWithMembers = resolver.resolve(beanType, null, null);
            this.methodsResolvedForHostClasses.put(hostClass, Stream.of(typeWithMembers.getMemberMethods()).collect(Collectors.toList()));
        }
        return this.methodsResolvedForHostClasses.get(hostClass);
    }

    private static Function<ResolvedMethod, ResolvedType> toReturnType(TypeResolver resolver) {
        return input -> Optional.ofNullable(input.getReturnType()).orElse(resolver.resolve(Void.TYPE, new Type[0]));
    }

    private Function<ResolvedMethod, List<ResolvedMethodParameter>> toParameters(HandlerMethod methodToResolve) {
        return input -> {
            ArrayList<ResolvedMethodParameter> parameters = new ArrayList<ResolvedMethodParameter>();
            MethodParameter[] methodParameters = methodToResolve.getMethodParameters();
            for (int i2 = 0; i2 < input.getArgumentCount(); ++i2) {
                parameters.add(new ResolvedMethodParameter(this.discoveredName(methodParameters[i2]).orElse(String.format("param%s", i2)), methodParameters[i2], input.getArgumentType(i2)));
            }
            return parameters;
        };
    }

    private static Iterable<ResolvedMethod> methodsWithSameNumberOfParams(Iterable<ResolvedMethod> filtered, Method methodToResolve) {
        return StreamSupport.stream(filtered.spliterator(), false).filter(input -> input.getArgumentCount() == methodToResolve.getParameterTypes().length).collect(Collectors.toList());
    }

    private static Predicate<ResolvedMethod> methodNamesAreSame(Method methodToResolve) {
        return input -> ((Method)input.getRawMember()).getName().equals(methodToResolve.getName());
    }

    private Optional<ResolvedMethod> resolveToMethodWithMaxResolvedTypes(Iterable<ResolvedMethod> filtered, Method methodToResolve) {
        if (StreamSupport.stream(filtered.spliterator(), false).count() > 1L) {
            Iterable<ResolvedMethod> covariantMethods = this.covariantMethods(filtered, methodToResolve);
            if (StreamSupport.stream(covariantMethods.spliterator(), false).count() == 0L) {
                return StreamSupport.stream(filtered.spliterator(), false).filter(this.sameMethod(methodToResolve)).findFirst();
            }
            if (StreamSupport.stream(covariantMethods.spliterator(), false).count() == 1L) {
                return StreamSupport.stream(covariantMethods.spliterator(), false).findFirst();
            }
            return StreamSupport.stream(covariantMethods.spliterator(), false).max(HandlerMethodResolver.byArgumentCount());
        }
        return StreamSupport.stream(filtered.spliterator(), false).findFirst();
    }

    private Predicate<ResolvedMethod> sameMethod(Method methodToResolve) {
        return input -> methodToResolve.equals(input.getRawMember());
    }

    private Iterable<ResolvedMethod> covariantMethods(Iterable<ResolvedMethod> filtered, Method methodToResolve) {
        return StreamSupport.stream(HandlerMethodResolver.methodsWithSameNumberOfParams(filtered, methodToResolve).spliterator(), false).filter(this.onlyCovariantMethods(methodToResolve)).collect(Collectors.toList());
    }

    private Predicate<ResolvedMethod> onlyCovariantMethods(Method methodToResolve) {
        return input -> {
            for (int index = 0; index < input.getArgumentCount(); ++index) {
                if (this.covariant(input.getArgumentType(index), methodToResolve.getGenericParameterTypes()[index])) continue;
                return false;
            }
            ResolvedType candidateMethodReturnValue = this.returnTypeOrVoid((ResolvedMethod)input);
            return this.bothAreVoids(candidateMethodReturnValue, methodToResolve.getGenericReturnType()) || this.contravariant(candidateMethodReturnValue, methodToResolve.getGenericReturnType());
        };
    }

    private ResolvedType returnTypeOrVoid(ResolvedMethod input) {
        ResolvedType returnType = input.getReturnType();
        if (returnType == null) {
            returnType = this.typeResolver.resolve((Type)((Object)Void.class), new Type[0]);
        }
        return returnType;
    }

    private Optional<String> discoveredName(MethodParameter methodParameter) {
        String[] discoveredNames = this.parameterNameDiscover.getParameterNames(methodParameter.getMethod());
        int discoveredNameCount = Optional.ofNullable(discoveredNames).orElse(new String[0]).length;
        return methodParameter.getParameterIndex() < discoveredNameCount ? Optional.ofNullable(discoveredNames[methodParameter.getParameterIndex()]).filter(((Predicate<String>)String::isEmpty).negate()) : Optional.ofNullable(methodParameter.getParameterName());
    }

    private ParameterNameDiscoverer parameterNameDiscoverer() {
        ParameterNameDiscoverer discoverer;
        try {
            discoverer = (ParameterNameDiscoverer)Class.forName(SPRING4_DISCOVERER).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            discoverer = new LocalVariableTableParameterNameDiscoverer();
        }
        return discoverer;
    }
}

