/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ExampleProperty;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ExampleBuilder;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.service.Header;
import springfox.documentation.service.Response;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ResponseContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.operation.ResponseMessagesReader;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.ResponseHeaders;

@Component
@Order(value=-2147482648)
public class SwaggerResponseMessageReader
implements OperationBuilderPlugin {
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final TypeNameExtractor typeNameExtractor;
    private final TypeResolver typeResolver;
    private final ModelSpecificationFactory modelSpecifications;
    private final DocumentationPluginsManager documentationPlugins;

    @Autowired
    public SwaggerResponseMessageReader(EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor, TypeResolver typeResolver, ModelSpecificationFactory modelSpecifications, DocumentationPluginsManager documentationPlugins) {
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.typeNameExtractor = typeNameExtractor;
        this.typeResolver = typeResolver;
        this.modelSpecifications = modelSpecifications;
        this.documentationPlugins = documentationPlugins;
    }

    @Override
    public void apply(OperationContext context) {
        Compatibility<Set<ResponseMessage>, Set<Response>> read = this.read(context);
        context.operationBuilder().responseMessages(read.getLegacy().orElse(new HashSet()));
        context.operationBuilder().responses(read.getModern().orElse(new HashSet()));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    protected Compatibility<Set<ResponseMessage>, Set<Response>> read(OperationContext context) {
        Optional<ModelReference> responseModel;
        ResolvedType defaultResponse = context.getReturnType();
        Optional<ApiOperation> operationAnnotation = context.findAnnotation(ApiOperation.class);
        Optional<ResolvedType> operationResponse = operationAnnotation.map(Annotations.resolvedTypeFromApiOperation(this.typeResolver, defaultResponse)).map(context::alternateFor);
        List operationHeaders = operationAnnotation.map(ApiOperation::responseHeaders).map(headers -> Stream.of(headers).collect(Collectors.toList())).orElse(new ArrayList());
        HashMap<String, Header> defaultHeaders = new HashMap<String, Header>(ResponseHeaders.headers(operationHeaders));
        List allApiResponses = Stream.concat(context.findAllAnnotations(ApiResponses.class).stream().flatMap(responses -> Stream.of(responses.value())), context.findAllAnnotations(ApiResponse.class).stream()).collect(Collectors.toList());
        HashSet<ResponseMessage> responseMessages = new HashSet<ResponseMessage>();
        HashSet<Response> responses2 = new HashSet<Response>();
        HashMap<Integer, ApiResponse> seenResponsesByCode = new HashMap<Integer, ApiResponse>();
        for (ApiResponse apiResponse : allApiResponses) {
            if (seenResponsesByCode.containsKey(apiResponse.code())) continue;
            ResponseContext responseContext = new ResponseContext(context.getDocumentationContext(), context);
            seenResponsesByCode.put(apiResponse.code(), apiResponse);
            responseModel = Optional.empty();
            ModelContext modelContext = context.operationModelsBuilder().addReturn(this.typeResolver.resolve(apiResponse.response(), new Type[0]), Optional.empty());
            Optional<ResolvedType> type = this.resolvedType(apiResponse);
            if (SwaggerResponseMessageReader.isSuccessful(apiResponse.code())) {
                type = type.map(Optional::of).orElse(operationResponse);
            }
            if (type.isPresent()) {
                HashMap<String, String> knownNames = new HashMap<String, String>();
                ((Set)Optional.ofNullable(context.getKnownModels().get(modelContext.getParameterId())).orElse(new HashSet())).forEach(model -> knownNames.put(model.getId(), model.getName()));
                responseModel = Optional.of(ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor, knownNames).apply(context.alternateFor(type.get())));
            }
            ArrayList<Example> examples = new ArrayList<Example>();
            int index = 0;
            for (ExampleProperty exampleProperty : apiResponse.examples().value()) {
                if (StringUtils.isEmpty(exampleProperty.value())) continue;
                String mediaType2 = StringUtils.isEmpty(exampleProperty.mediaType()) ? null : exampleProperty.mediaType();
                examples.add(new ExampleBuilder().mediaType(mediaType2).id("example-" + index++).value(exampleProperty.value()).build());
            }
            HashMap<String, Header> headers2 = new HashMap<String, Header>(defaultHeaders);
            headers2.putAll(ResponseHeaders.headers(apiResponse.responseHeaders()));
            responseMessages.add(new ResponseMessageBuilder().code(apiResponse.code()).message(apiResponse.message()).responseModel(responseModel.orElse(null)).examples(examples).headersWithDescription(headers2).build());
            Optional<ResolvedType> finalType = type;
            context.produces().forEach(mediaType -> finalType.map(t -> this.modelSpecifications.create(modelContext, (ResolvedType)t)).ifPresent(model -> responseContext.responseBuilder().representation((MediaType)mediaType).apply(r -> r.model(m -> m.copyOf((ModelSpecification)model)))));
            responseContext.responseBuilder().examples(examples).description(apiResponse.message()).headers(headers2.values()).code(String.valueOf(apiResponse.code()));
            responses2.add(this.documentationPlugins.response(responseContext));
        }
        if (operationResponse.isPresent()) {
            ModelContext modelContext = context.operationModelsBuilder().addReturn(operationResponse.get(), Optional.empty());
            ResolvedType resolvedType = context.alternateFor(operationResponse.get());
            HashMap<String, String> knownNames = new HashMap<String, String>();
            ((Set)Optional.ofNullable(context.getKnownModels().get(modelContext.getParameterId())).orElse(new HashSet())).forEach(model -> knownNames.put(model.getId(), model.getName()));
            responseModel = ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor, knownNames).apply(resolvedType);
            context.operationBuilder().responseModel((ModelReference)((Object)responseModel));
            ResponseMessage defaultMessage = new ResponseMessageBuilder().code(ResponseMessagesReader.httpStatusCode(context)).message(ResponseMessagesReader.message(context)).responseModel((ModelReference)((Object)responseModel)).build();
            if (!responseMessages.contains(defaultMessage) && !"void".equals(responseModel.getType())) {
                responseMessages.add(defaultMessage);
            }
            ResponseContext responseContext = new ResponseContext(context.getDocumentationContext(), context);
            context.consumes().forEach(mediaType -> responseContext.responseBuilder().representation((MediaType)mediaType).apply(r -> r.model(m -> m.copyOf(this.modelSpecifications.create(modelContext, resolvedType)))));
            responseContext.responseBuilder().description(ResponseMessagesReader.message(context)).code(String.valueOf(ResponseMessagesReader.httpStatusCode(context)));
            responses2.add(this.documentationPlugins.response(responseContext));
        }
        return new Compatibility<Set<ResponseMessage>, Set<Response>>(responseMessages, responses2);
    }

    static boolean isSuccessful(int code) {
        try {
            return HttpStatus.Series.SUCCESSFUL.equals((Object)HttpStatus.Series.valueOf(code));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private Optional<ResolvedType> resolvedType(ApiResponse apiResponse) {
        return Optional.ofNullable(Annotations.resolvedTypeFromResponse(this.typeResolver, null).apply(apiResponse));
    }
}

