/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import io.swagger.models.Swagger;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.OnReactiveWebApplication;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.web.SwaggerTransformationContext;
import springfox.documentation.swagger2.web.WebFluxSwaggerTransformationFilter;

@RestController
@ApiIgnore
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@RequestMapping(value={"${springfox.documentation.swagger.v2.path:/v2/api-docs}"})
@Conditional(value={OnReactiveWebApplication.class})
public class Swagger2ControllerWebFlux {
    private static final Logger LOGGER = LoggerFactory.getLogger(Swagger2ControllerWebFlux.class);
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private final DocumentationCache documentationCache;
    private final ServiceModelToSwagger2Mapper mapper;
    private final JsonSerializer jsonSerializer;
    private final PluginRegistry<WebFluxSwaggerTransformationFilter, DocumentationType> transformations;

    @Autowired
    public Swagger2ControllerWebFlux(DocumentationCache documentationCache, ServiceModelToSwagger2Mapper mapper, JsonSerializer jsonSerializer, @Qualifier(value="webFluxSwaggerTransformationFilterRegistry") PluginRegistry<WebFluxSwaggerTransformationFilter, DocumentationType> transformations) {
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.jsonSerializer = jsonSerializer;
        this.transformations = transformations;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @ResponseBody
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, ServerHttpRequest request) {
        String groupName = Optional.ofNullable(swaggerGroup).orElse("default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            LOGGER.warn("Unable to find specification for group {}", (Object)groupName);
            return new ResponseEntity<Json>(HttpStatus.NOT_FOUND);
        }
        Swagger swagger = this.mapper.mapDocumentation(documentation);
        SwaggerTransformationContext<ServerHttpRequest> context = new SwaggerTransformationContext<ServerHttpRequest>(swagger, request);
        List<WebFluxSwaggerTransformationFilter> filters = this.transformations.getPluginsFor(DocumentationType.SWAGGER_2);
        for (WebFluxSwaggerTransformationFilter each : filters) {
            context = context.next(each.transform(context));
        }
        return new ResponseEntity<Json>(this.jsonSerializer.toJson(context.getSpecification()), HttpStatus.OK);
    }
}

