package com.aiup.api.controller;


import com.aiup.service.domain.R;
import com.aiup.service.domain.query.PrePayQuery;
import com.aiup.service.domain.response.WxPrePayResponse;
import com.aiup.service.entity.UserInfo;
import com.aiup.service.service.WxPayService;
import com.aiup.service.utils.LoginUserUtils;
import com.alibaba.fastjson.util.IOUtils;
import com.wechat.pay.java.core.notification.NotificationParser;
import com.wechat.pay.java.core.notification.RequestParam;
import com.wechat.pay.java.service.partnerpayments.jsapi.model.Transaction;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;

@Api(tags = "微信支付回调")
@Controller
@RequestMapping("/v1/callback")
@RequiredArgsConstructor
public class PayCallBackController {

    @Autowired
    private WxPayService wxPayService;

    @ApiOperation(value = "创建支付单")
    @PostMapping("/notify")
    @GetMapping("/notify")
    public Map<String,Object> notify(HttpServletRequest request, HttpServletResponse response) throws Exception{
        return  wxPayService.payNotify( request,  response);
    }
}
