package com.aiup.api.controller;


import com.aiup.service.domain.R;
import com.aiup.service.domain.openai.ChatResponse;
import com.aiup.service.domain.query.GptChatQuery;
import com.aiup.service.domain.query.ProductListQuery;
import com.aiup.service.domain.response.GptChatResponse;
import com.aiup.service.domain.response.ProductListResponse;
import com.aiup.service.entity.Product;
import com.aiup.service.service.OpenAiService;
import com.aiup.service.service.ProductService;
import com.aiup.service.service.WxPayService;
import com.aiup.service.utils.LoginUserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "商品相关接口")
@RestController
@RequestMapping("/v1/product")
@RequiredArgsConstructor
public class ProductController {

    @Autowired
    private WxPayService wxPayService;

    @ApiOperation(value = "获取商品列表")
    @PostMapping("/getList")
    public R<List<ProductListResponse>> getProductList(@RequestBody ProductListQuery query) {
        query.setUserId(LoginUserUtils.getLoginUser().getUserId());
        return R.ok(wxPayService.getProductList(query));
    }
}
