package com.aiup.api.controller;


import com.aiup.service.domain.R;
import com.aiup.service.domain.openai.ChatResponse;
import com.aiup.service.domain.query.GptChatQuery;
import com.aiup.service.domain.query.IdQuery;
import com.aiup.service.domain.query.TemplateListQuery;
import com.aiup.service.domain.response.GptChatResponse;
import com.aiup.service.entity.TemplateInfo;
import com.aiup.service.service.OpenAiService;
import com.aiup.service.service.TemplateInfoService;
import com.aiup.service.utils.LoginUserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import sun.rmi.runtime.Log;

import java.util.Date;
import java.util.List;

@Api(tags = "模板相关接口")
@RestController
@RequestMapping("/v1/template")
@RequiredArgsConstructor
public class TemplateController {

    @Autowired
    private TemplateInfoService templateInfoService;

    @ApiOperation(value = "创建一个模板")
    @PostMapping("/create")
    public R<TemplateInfo> create(@RequestBody TemplateInfo query) {
        query.setUserId(LoginUserUtils.getLoginUser().getUserId());
        query.setIsDeleted(0);
        query.setCreateTime(new Date());
        TemplateInfo insert = templateInfoService.insert(query);
        return R.ok(insert);
    }
    @ApiOperation(value = "修改一个模板")
    @PostMapping("/update")
    public R<TemplateInfo> update(@RequestBody TemplateInfo query) {
        if(query.getId() == null || query.getId()<=0){
            return R.error("模板ID不合法");
        }
        TemplateInfo oldTemp  = templateInfoService.queryById(query.getId());
        if(oldTemp.getUserId() != LoginUserUtils.getLoginUser().getUserId()){
            return R.error("修改失败，只能修改自己的模板");
        }
        query.setUpdateTime(new Date());
        TemplateInfo update = templateInfoService.update(query);
        return R.ok(update);
    }

    @ApiOperation(value = "获取模板列表")
    @PostMapping("/list")
    public R<List<TemplateInfo>> list(@RequestBody TemplateListQuery query) {
        query.setUserId(LoginUserUtils.getLoginUser().getUserId());
        PageRequest pageRequest = PageRequest.of(0,200);
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setIsDeleted(0);
        templateInfo.setUserId(query.getUserId());
        return R.ok(templateInfoService.queryByPage(templateInfo,pageRequest).getContent());
    }

    @ApiOperation(value = "删除模板")
    @PostMapping("/remove")
    public R<Boolean> remove(@RequestBody IdQuery query) {
        query.setUserId(LoginUserUtils.getLoginUser().getUserId());
        PageRequest pageRequest = PageRequest.of(0,200);
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setIsDeleted(0);
        templateInfo.setUserId(query.getUserId());
        templateInfo.setId(query.getRecordId());
        List<TemplateInfo> list = templateInfoService.queryByPage(templateInfo, pageRequest).getContent();
        if(list == null || list.size()<=0){
            return R.error("模板不存在");
        }
        TemplateInfo temp = list.get(0);
        temp.setIsDeleted(1);
        temp.setUpdateTime(new Date());
        templateInfoService.update(temp);
        return R.ok(true);
    }

    @ApiOperation(value = "获取模板详情")
    @PostMapping("/detail")
    public R<TemplateInfo> detail(@RequestBody IdQuery query) {
        query.setUserId(LoginUserUtils.getLoginUser().getUserId());
        PageRequest pageRequest = PageRequest.of(0,200);
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setIsDeleted(0);
        templateInfo.setUserId(query.getUserId());
        templateInfo.setId(query.getRecordId());
        List<TemplateInfo> list = templateInfoService.queryByPage(templateInfo, pageRequest).getContent();
        if(list == null || list.size()<=0){
            return R.error("模板不存在");
        }
        return R.ok(list.get(0));
    }
}
