package com.aiup.chatgptserver.service;

import lombok.Data;

@Data
public class R<T> {
    private static final long serialVersionUID = 1L;

    private Integer result;
    private String errorCode;
    private String title;
    private String description;
    private T retValue;

    public R() {
        //执行结果。1=成功，-1=失败
        this(1, "success", "", null);
    }

    public R(Integer result, String title, String description) {
        this(result, title, description, null);
    }

    public R(Integer result, String title, String description, T retValue) {
        this.result = result;
        this.title = title;
        this.description = description;
        this.retValue = retValue;
    }

    /**
     * @return R
     */
    public static R error() {
        return error(-1, "未知异常，请联系管理员");
    }

    /**
     * @param msg msg
     * @return R
     */
    public static R error(String msg) {
        return error(-1, msg);
    }

    /**
     * @param code code
     * @param msg  msg
     * @return R
     */
    public static R error(int code, String msg) {
        R r = new R(code, "fail", msg);
        return r;
    }

    /**
     * @param code code
     * @param
     * @return R
     */
    public static R titleError(int code, String titleMsg) {
        R r = new R(code, titleMsg, "未知异常，请联系管理员");
        return r;
    }

    /**
     * @param msg msg
     * @param map map
     * @return R
     */
    public static R error(String msg, Object map) {
        R r = new R(-1, "fail", msg, map);
        return r;
    }

    /**
     * @param msg msg
     * @return R
     */
    public static R ok(String msg) {
        R r = new R();
        r.setRetValue(msg);
        return r;
    }

    /**
     * @param map map
     * @return R
     */
    public static R ok(Object map) {
        R r = new R();
        r.setRetValue(map);
        return r;
    }

    /**
     * @return R
     */
    public static R ok() {
        return new R();
    }
}
