package com.aiup.service.dao;

import com.aiup.service.entity.UserLoginLog;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;

/**
 * 用户登录日志(UserLoginLog)表数据库访问层
 *
 * @author makejava
 * @since 2023-08-22 12:54:45
 */
 @Mapper
public interface UserLoginLogDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserLoginLog queryById(Long id);

    /**
     * 查询指定行数据
     *
     * @param userLoginLog 查询条件
     * @param pageable         分页对象
     * @return 对象列表
     */
    List<UserLoginLog> queryAllByLimit(@Param("bean") UserLoginLog userLoginLog, @Param("pageable") Pageable pageable);

    /**
     * 统计总行数
     *
     * @param userLoginLog 查询条件
     * @return 总行数
     */
    long count(UserLoginLog userLoginLog);

    /**
     * 新增数据
     *
     * @param userLoginLog 实例对象
     * @return 影响行数
     */
    int insert(UserLoginLog userLoginLog);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserLoginLog> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<UserLoginLog> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserLoginLog> 实例对象列表
     * @return 影响行数
     * @throws org.springframework.jdbc.BadSqlGrammarException 入参是空List的时候会抛SQL语句错误的异常，请自行校验入参
     */
    int insertOrUpdateBatch(@Param("entities") List<UserLoginLog> entities);

    /**
     * 修改数据
     *
     * @param userLoginLog 实例对象
     * @return 影响行数
     */
    int update(UserLoginLog userLoginLog);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

}

