package com.aiup.service.entity;

import java.util.Date;
import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 用户配置信息(UserConfig)实体类
 *
 * @author makejava
 * @since 2023-08-29 16:49:47
 */

@ApiModel("用户配置信息")
public class UserConfig implements Serializable {
    private static final long serialVersionUID = -64704212792981845L;
    /**
     * 配置ID
     */
    @ApiModelProperty(value = "配置ID")
    private Integer configId;
    /**
     * 配置值
     */
    @ApiModelProperty(value = "配置值")
    @NotNull(message = "配置值不能为空")
    private String configValue;
    /**
     * 用户ID，0-代表公共配置；大于0用户配置
     */
    @ApiModelProperty(value = "用户ID，0-代表公共配置；大于0用户配置")
    private Integer userId;
    /**
     * 一级分类
     */
    @ApiModelProperty(value = "一级分类")
    @NotNull(message = "一级分类不能为空")
    private String typeFirst;
    /**
     * 二级分类
     */
    @ApiModelProperty(value = "二级分类")
    @NotNull(message = "二级分类不能为空")
    private String typeSecond;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 是否删除
     */
    @ApiModelProperty(value = "是否删除")
    private Integer isDeleted;
    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;


    public Integer getConfigId() {
        return configId;
    }

    public void setConfigId(Integer configId) {
        this.configId = configId;
    }

    public String getConfigValue() {
        return configValue;
    }

    public void setConfigValue(String configValue) {
        this.configValue = configValue;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getTypeFirst() {
        return typeFirst;
    }

    public void setTypeFirst(String typeFirst) {
        this.typeFirst = typeFirst;
    }

    public String getTypeSecond() {
        return typeSecond;
    }

    public void setTypeSecond(String typeSecond) {
        this.typeSecond = typeSecond;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}

