package com.aiup.service.service;

import com.aiup.service.entity.UserLicense;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

/**
 * 用户许可表(UserLicense)表服务接口
 *
 * @author makejava
 * @since 2023-08-15 13:58:35
 */
public interface UserLicenseService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserLicense queryById(Integer id);

    /**
     * 分页查询
     *
     * @param userLicense 筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    Page<UserLicense> queryByPage(UserLicense userLicense, PageRequest pageRequest);

    /**
     * 新增数据
     *
     * @param userLicense 实例对象
     * @return 实例对象
     */
    UserLicense insert(UserLicense userLicense);

    /**
     * 修改数据
     *
     * @param userLicense 实例对象
     * @return 实例对象
     */
    UserLicense update(UserLicense userLicense);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(Integer id);

}
