package com.aiup.service.service;

import com.aiup.service.entity.UserLoginLog;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

/**
 * 用户登录日志(UserLoginLog)表服务接口
 *
 * @author makejava
 * @since 2023-08-19 22:39:44
 */
public interface UserLoginLogService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserLoginLog queryById(Long id);

    /**
     * 分页查询
     *
     * @param userLoginLog 筛选条件
     * @param pageRequest  分页对象
     * @return 查询结果
     */
    Page<UserLoginLog> queryByPage(UserLoginLog userLoginLog, PageRequest pageRequest);

    /**
     * 新增数据
     *
     * @param userLoginLog 实例对象
     * @return 实例对象
     */
    UserLoginLog insert(UserLoginLog userLoginLog);

    /**
     * 修改数据
     *
     * @param userLoginLog 实例对象
     * @return 实例对象
     */
    UserLoginLog update(UserLoginLog userLoginLog);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(Long id);

}
