package com.aiup.service.service.impl;

import com.aiup.service.dao.XhsNotesBaseExtDao;
import com.aiup.service.domain.openai.ChatResponse;
import com.aiup.service.domain.query.CreateNodesQuery;
import com.aiup.service.domain.query.GptChatQuery;
import com.aiup.service.domain.query.NotesListQuery;
import com.aiup.service.domain.query.PageBaseQuery;
import com.aiup.service.domain.response.ListBaseResponse;
import com.aiup.service.entity.TemplateInfo;
import com.aiup.service.entity.XhsNotesBase;
import com.aiup.service.service.NoteService;
import com.aiup.service.service.OpenAiService;
import com.aiup.service.service.TemplateInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class NoteServiceImpl  implements NoteService {

    @Autowired
    private  XhsNotesBaseExtDao xhsNotesBaseExtDao;
    @Autowired
    private OpenAiService openAiService;
    @Autowired
    private TemplateInfoService templateInfoService;

    @Override
    public ListBaseResponse<XhsNotesBase> getNotesList(PageBaseQuery<NotesListQuery> query) {
        if(query.getIndex() <0)
        {
            query.setIndex(0);
        }
        if(query.getPageSize() <=0){
            query.setPageSize(10);
        }
        Integer offSet = query.getIndex() * query.getPageSize();
        Integer total = xhsNotesBaseExtDao.getNotesCount(query.getQueryParam().getCategory());
        List<XhsNotesBase> list = xhsNotesBaseExtDao.getNotesList(query.getQueryParam().getCategory(),query.getPageSize(),offSet);
        return new ListBaseResponse<XhsNotesBase>().ofList(list,total,query.getIndex(),query.getPageSize());
    }

    @Override
    public List<String>  createNotes(CreateNodesQuery query){
        String url =query.getPostUrl();
//        String promptFormat ="你现在是一个资深的自媒体人，这是2篇相似内容，点赞量都很高，请帮忙总结出这2篇内容之所以点赞高的相同之处，"+
//                "总结框架为：【主题介绍、故事描述、叙事方式、表达技巧、风格、高潮部分描述、总结描述】。内容如下：\r\n"+
//                "1、%{content1}s \r\n"+
//                "2、%{content2}s \r\n"+
//                "再根据你总结出来的相同之处这个框架，帮我生成一篇专业的自媒体内容，我会给你我的内容信息，" +
//                "内容属性：%{templateContent}s、内容领域：%{templateArea}s、内容字数${number}d、内容主题：%{templateTopic}s" +
//                "内容风格：%{templateStyle}s，生成条数：%{templateCount}d条；\r\n"+
//                "把我给你的这些信息和相同之处框架结合在一起，生成一篇专业自媒体内容；并抽取3-6个seo关键词，生成#标签并放在文章最后。";
//
        String promptFormat ="你现在是一个资深的自媒体人，这是2篇相似内容，点赞量都很高，请帮忙总结出这2篇内容之所以点赞高的相同之处，"+
                "总结框架为：【主题介绍、故事描述、叙事方式、表达技巧、风格、高潮部分描述、总结描述】。内容如下：\r\n"+
                "1、%s \r\n"+
                "2、%s \r\n"+
                "再根据你总结出来的相同之处这个框架，帮我生成一篇专业的自媒体内容，我会给你我的内容信息，" +
                "内容属性：%s、内容领域：%s、内容字数%d、内容主题：%s" +
                "内容风格：%s，生成条数：%d条；\r\n"+
                "把我给你的这些信息和相同之处框架结合在一起，生成一篇专业自媒体内容；并抽取3-6个seo关键词，生成#标签并放在文章最后。";

        //1.根据URl获取内容
        XhsNotesBase base = getContentByUrl(url);
        String content = base.getContent();
        TemplateInfo templateInfo = templateInfoService.queryById(query.getTemplateId());
        //2.获取本地数据库中相同分类的2篇文章
        List<String> contentList = getTop3ContentByKeyWord(base.getCategory());
        //2.把内容给到gpt，生成文案
//        Object[] params={"content1",contentList.get(0),"content2",contentList.get(1),
//        "templateContent",templateInfo.getTemplateContent(),"templateArea",templateInfo.getTemplateArea(),
//        "number",templateInfo.getTemplateCount(),"templateTopic",templateInfo.getTemplateTopic(),
//        "templateStyle",templateInfo.getTemplateStyle()==null?"":templateInfo.getTemplateStyle(),"templateCount",query.getCount()};
        Object[] params={contentList.get(0),contentList.get(1),
                templateInfo.getTemplateContent(),templateInfo.getTemplateDomain(),templateInfo.getTemplateArea(),
               templateInfo.getTemplateCount(),templateInfo.getTemplateTopic(),
               templateInfo.getTemplateStyle()==null?"":templateInfo.getTemplateStyle(),query.getCount()};

        String prompt = String.format(promptFormat,params);
        log.info(prompt);
        //TODO:需要提取关键词的模板
        GptChatQuery keyWordQuery = new GptChatQuery();
        keyWordQuery.setPrompt(prompt);
        String keyWord = openAiService.chat(keyWordQuery);
        List<String> result = new ArrayList<>();
        result.add(prompt);
        result.add(keyWord);
        return result;
    }

    /**
     * 根据URL获取内容
     * @param url
     * @return
     */
    private XhsNotesBase getContentByUrl(String url){
        //通过本地数据库查询
        return xhsNotesBaseExtDao.getContentByUrl(url);
    }

    /**
     * 更具关键词获取3篇文章的内容
     * @param keyWord
     * @return
     */
    private List<String> getTop3ContentByKeyWord(String keyWord){
        List<XhsNotesBase> notesList = xhsNotesBaseExtDao.getNotesList2(keyWord, 2, 0);
        List<String> list  = new ArrayList<>();
        for(XhsNotesBase note: notesList){
            list.add(note.getContent());
        }
        return list;
    }
}
