package com.aiup.service.service.impl;

import com.aiup.service.domain.query.UserInfoQuery;
import com.aiup.service.domain.response.OrderListResponse;
import com.aiup.service.entity.PrepayOrder;
import com.aiup.service.dao.PrepayOrderDao;
import com.aiup.service.service.PrepayOrderService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;
import java.util.List;

/**
 * 商品支付单(PrepayOrder)表服务实现类
 *
 * @author makejava
 * @since 2023-08-08 14:57:59
 */
@Service("prepayOrderService")
public class PrepayOrderServiceImpl implements PrepayOrderService {
    @Resource
    private PrepayOrderDao prepayOrderDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public PrepayOrder queryById(Integer id) {
        return this.prepayOrderDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param prepayOrder 筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    @Override
    public Page<PrepayOrder> queryByPage(PrepayOrder prepayOrder, PageRequest pageRequest) {
        long total = this.prepayOrderDao.count(prepayOrder);
        return new PageImpl<>(this.prepayOrderDao.queryAllByLimit(prepayOrder, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param prepayOrder 实例对象
     * @return 实例对象
     */
    @Override
    public PrepayOrder insert(PrepayOrder prepayOrder) {
        this.prepayOrderDao.insert(prepayOrder);
        return prepayOrder;
    }

    /**
     * 修改数据
     *
     * @param prepayOrder 实例对象
     * @return 实例对象
     */
    @Override
    public PrepayOrder update(PrepayOrder prepayOrder) {
        this.prepayOrderDao.update(prepayOrder);
        return this.queryById(prepayOrder.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.prepayOrderDao.deleteById(id) > 0;
    }

    @Override
    public List<OrderListResponse> getOrderList(UserInfoQuery query) {
        return this.prepayOrderDao.getOrderList(query);
    }
}
