package com.aiup.service.service.impl;

import com.aiup.service.entity.TemplateInfo;
import com.aiup.service.dao.TemplateInfoDao;
import com.aiup.service.service.TemplateInfoService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;

/**
 * 模板信息表(TemplateInfo)表服务实现类
 *
 * @author makejava
 * @since 2023-08-15 11:18:44
 */
@Service("templateInfoService")
public class TemplateInfoServiceImpl implements TemplateInfoService {
    @Resource
    private TemplateInfoDao templateInfoDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public TemplateInfo queryById(Integer id) {
        return this.templateInfoDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param templateInfo 筛选条件
     * @param pageRequest  分页对象
     * @return 查询结果
     */
    @Override
    public Page<TemplateInfo> queryByPage(TemplateInfo templateInfo, PageRequest pageRequest) {
        long total = this.templateInfoDao.count(templateInfo);
        return new PageImpl<>(this.templateInfoDao.queryAllByLimit(templateInfo, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param templateInfo 实例对象
     * @return 实例对象
     */
    @Override
    public TemplateInfo insert(TemplateInfo templateInfo) {
        this.templateInfoDao.insert(templateInfo);
        return templateInfo;
    }

    /**
     * 修改数据
     *
     * @param templateInfo 实例对象
     * @return 实例对象
     */
    @Override
    public TemplateInfo update(TemplateInfo templateInfo) {
        this.templateInfoDao.update(templateInfo);
        return this.queryById(templateInfo.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.templateInfoDao.deleteById(id) > 0;
    }
}
