package com.aiup.service.service.impl;

import com.aiup.service.entity.UserAdvice;
import com.aiup.service.dao.UserAdviceDao;
import com.aiup.service.service.UserAdviceService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;

/**
 * 用户问题表(UserAdvice)表服务实现类
 *
 * @author makejava
 * @since 2023-09-05 19:28:46
 */
@Service("userAdviceService")
public class UserAdviceServiceImpl implements UserAdviceService {
    @Resource
    private UserAdviceDao userAdviceDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public UserAdvice queryById(Integer id) {
        return this.userAdviceDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param userAdvice 筛选条件
     * @param pageRequest      分页对象
     * @return 查询结果
     */
    @Override
    public Page<UserAdvice> queryByPage(UserAdvice userAdvice, PageRequest pageRequest) {
        long total = this.userAdviceDao.count(userAdvice);
        return new PageImpl<>(this.userAdviceDao.queryAllByLimit(userAdvice, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param userAdvice 实例对象
     * @return 实例对象
     */
    @Override
    public UserAdvice insert(UserAdvice userAdvice) {
        this.userAdviceDao.insert(userAdvice);
        return userAdvice;
    }

    /**
     * 修改数据
     *
     * @param userAdvice 实例对象
     * @return 实例对象
     */
    @Override
    public UserAdvice update(UserAdvice userAdvice) {
        this.userAdviceDao.update(userAdvice);
        return this.queryById(userAdvice.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.userAdviceDao.deleteById(id) > 0;
    }
}
