package com.aiup.service.service.impl;

import com.aiup.service.entity.UserLicense;
import com.aiup.service.dao.UserLicenseDao;
import com.aiup.service.service.UserLicenseService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;

/**
 * 用户许可表(UserLicense)表服务实现类
 *
 * @author makejava
 * @since 2023-08-15 13:58:35
 */
@Service("userLicenseService")
public class UserLicenseServiceImpl implements UserLicenseService {
    @Resource
    private UserLicenseDao userLicenseDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public UserLicense queryById(Integer id) {
        return this.userLicenseDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param userLicense 筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    @Override
    public Page<UserLicense> queryByPage(UserLicense userLicense, PageRequest pageRequest) {
        long total = this.userLicenseDao.count(userLicense);
        return new PageImpl<>(this.userLicenseDao.queryAllByLimit(userLicense, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param userLicense 实例对象
     * @return 实例对象
     */
    @Override
    public UserLicense insert(UserLicense userLicense) {
        this.userLicenseDao.insert(userLicense);
        return userLicense;
    }

    /**
     * 修改数据
     *
     * @param userLicense 实例对象
     * @return 实例对象
     */
    @Override
    public UserLicense update(UserLicense userLicense) {
        this.userLicenseDao.update(userLicense);
        return this.queryById(userLicense.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.userLicenseDao.deleteById(id) > 0;
    }
}
