package com.aiup.service.service.impl;

import com.aiup.service.entity.XhsNotesBase;
import com.aiup.service.dao.XhsNotesBaseDao;
import com.aiup.service.service.XhsNotesBaseService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;

/**
 * (XhsNotesBase)表服务实现类
 *
 * @author makejava
 * @since 2023-08-18 13:14:24
 */
@Service("xhsNotesBaseService")
public class XhsNotesBaseServiceImpl implements XhsNotesBaseService {
    @Resource
    private XhsNotesBaseDao xhsNotesBaseDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public XhsNotesBase queryById(Integer id) {
        return this.xhsNotesBaseDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param xhsNotesBase 筛选条件
     * @param pageRequest  分页对象
     * @return 查询结果
     */
    @Override
    public Page<XhsNotesBase> queryByPage(XhsNotesBase xhsNotesBase, PageRequest pageRequest) {
        long total = this.xhsNotesBaseDao.count(xhsNotesBase);
        return new PageImpl<>(this.xhsNotesBaseDao.queryAllByLimit(xhsNotesBase, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param xhsNotesBase 实例对象
     * @return 实例对象
     */
    @Override
    public XhsNotesBase insert(XhsNotesBase xhsNotesBase) {
        this.xhsNotesBaseDao.insert(xhsNotesBase);
        return xhsNotesBase;
    }

    /**
     * 修改数据
     *
     * @param xhsNotesBase 实例对象
     * @return 实例对象
     */
    @Override
    public XhsNotesBase update(XhsNotesBase xhsNotesBase) {
        this.xhsNotesBaseDao.update(xhsNotesBase);
        return this.queryById(xhsNotesBase.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.xhsNotesBaseDao.deleteById(id) > 0;
    }
}
