package com.aiup.service.service.impl;

import com.aiup.service.entity.XhsUserBase;
import com.aiup.service.dao.XhsUserBaseDao;
import com.aiup.service.service.XhsUserBaseService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;

/**
 * (XhsUserBase)表服务实现类
 *
 * @author makejava
 * @since 2023-08-19 18:21:14
 */
@Service("xhsUserBaseService")
public class XhsUserBaseServiceImpl implements XhsUserBaseService {
    @Resource
    private XhsUserBaseDao xhsUserBaseDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public XhsUserBase queryById(Integer id) {
        return this.xhsUserBaseDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param xhsUserBase 筛选条件
     * @param pageRequest      分页对象
     * @return 查询结果
     */
    @Override
    public Page<XhsUserBase> queryByPage(XhsUserBase xhsUserBase, PageRequest pageRequest) {
        long total = this.xhsUserBaseDao.count(xhsUserBase);
        return new PageImpl<>(this.xhsUserBaseDao.queryAllByLimit(xhsUserBase, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param xhsUserBase 实例对象
     * @return 实例对象
     */
    @Override
    public XhsUserBase insert(XhsUserBase xhsUserBase) {
        this.xhsUserBaseDao.insert(xhsUserBase);
        return xhsUserBase;
    }

    /**
     * 修改数据
     *
     * @param xhsUserBase 实例对象
     * @return 实例对象
     */
    @Override
    public XhsUserBase update(XhsUserBase xhsUserBase) {
        this.xhsUserBaseDao.update(xhsUserBase);
        return this.queryById(xhsUserBase.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.xhsUserBaseDao.deleteById(id) > 0;
    }
}
