/*
 * Decompiled with CFR 0.152.
 */
package com.aiup.service.config;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class OpenAIRestTemplateConfig {
    @Value(value="${openai.api.key}")
    private String openaiApiKey;
    @Value(value="${openai.proxy.enable}")
    private Boolean proxyEnable;
    @Value(value="${openai.proxy.host}")
    private String proxyHost;
    @Value(value="${openai.proxy.port}")
    private Integer proxyPort;

    @Bean
    @Qualifier(value="openaiRestTemplate")
    public RestTemplate openaiRestTemplate() {
        RestTemplate restTemplate = null;
        if (this.proxyEnable.booleanValue()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort));
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            requestFactory.setProxy(proxy);
            restTemplate = new RestTemplate(requestFactory);
        } else {
            restTemplate = new RestTemplate();
        }
        restTemplate.getInterceptors().add((request, body2, execution) -> {
            request.getHeaders().add("Authorization", "Bearer " + this.openaiApiKey);
            return execution.execute(request, body2);
        });
        return restTemplate;
    }
}

