/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor.functions;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import com.alibaba.druid.sql.visitor.functions.Function;
import com.alibaba.druid.util.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;

public class OneParamFunctions
implements Function {
    public static final OneParamFunctions instance = new OneParamFunctions();

    @Override
    public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
        if (x.getArguments().size() == 0) {
            return SQLEvalVisitor.EVAL_ERROR;
        }
        SQLExpr param = x.getArguments().get(0);
        param.accept(visitor);
        Object paramValue = param.getAttributes().get("eval.value");
        if (paramValue == null) {
            return SQLEvalVisitor.EVAL_ERROR;
        }
        if (paramValue == SQLEvalVisitor.EVAL_VALUE_NULL) {
            return SQLEvalVisitor.EVAL_VALUE_NULL;
        }
        String method = x.getMethodName();
        if ("md5".equalsIgnoreCase(method)) {
            String text = paramValue.toString();
            return Utils.md5(text);
        }
        if ("bit_count".equalsIgnoreCase(method)) {
            if (paramValue instanceof BigInteger) {
                return ((BigInteger)paramValue).bitCount();
            }
            if (paramValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)paramValue;
                BigInteger bigInt = decimal.setScale(0, 4).toBigInteger();
                return bigInt.bitCount();
            }
            Long val2 = SQLEvalVisitorUtils.castToLong(paramValue);
            return Long.bitCount(val2);
        }
        if ("soundex".equalsIgnoreCase(method)) {
            String text = paramValue.toString();
            return OneParamFunctions.soundex(text);
        }
        if ("space".equalsIgnoreCase(method)) {
            int intVal = SQLEvalVisitorUtils.castToInteger(paramValue);
            char[] chars = new char[intVal];
            for (int i2 = 0; i2 < chars.length; ++i2) {
                chars[i2] = 32;
            }
            return new String(chars);
        }
        throw new UnsupportedOperationException(method);
    }

    public static String soundex(String str) {
        if (str == null) {
            return null;
        }
        if ((str = OneParamFunctions.clean(str)).length() == 0) {
            return str;
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count = 1;
        out[0] = str.charAt(0);
        char last = OneParamFunctions.getMappingCode(str, 0);
        while (incount < str.length() && count < out.length) {
            char mapped;
            if ((mapped = OneParamFunctions.getMappingCode(str, incount++)) == '\u0000') continue;
            if (mapped != '0' && mapped != last) {
                out[count++] = mapped;
            }
            last = mapped;
        }
        return new String(out);
    }

    static String clean(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int len = str.length();
        char[] chars = new char[len];
        int count = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!Character.isLetter(str.charAt(i2))) continue;
            chars[count++] = str.charAt(i2);
        }
        if (count == len) {
            return str.toUpperCase(Locale.ENGLISH);
        }
        return new String(chars, 0, count).toUpperCase(Locale.ENGLISH);
    }

    private static char getMappingCode(String str, int index) {
        char preHWChar;
        char firstCode;
        char hwChar;
        char mappedChar = OneParamFunctions.map(str.charAt(index));
        if (!(index <= 1 || mappedChar == '0' || 'H' != (hwChar = str.charAt(index - 1)) && 'W' != hwChar || (firstCode = OneParamFunctions.map(preHWChar = str.charAt(index - 2))) != mappedChar && 'H' != preHWChar && 'W' != preHWChar)) {
            return '\u0000';
        }
        return mappedChar;
    }

    private static char map(char ch) {
        String soundexMapping = "01230120022455012623010202";
        int index = ch - 65;
        if (index < 0 || index >= soundexMapping.length()) {
            throw new IllegalArgumentException("The character is not mapped: " + ch);
        }
        return soundexMapping.charAt(index);
    }
}

