/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http;

import com.alibaba.druid.support.http.util.IPAddress;
import com.alibaba.druid.support.http.util.IPRange;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class ResourceServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(ResourceServlet.class);
    public static final String SESSION_USER_KEY = "druid-user";
    public static final String PARAM_NAME_USERNAME = "loginUsername";
    public static final String PARAM_NAME_PASSWORD = "loginPassword";
    public static final String PARAM_NAME_ALLOW = "allow";
    public static final String PARAM_NAME_DENY = "deny";
    public static final String PARAM_REMOTE_ADDR = "remoteAddress";
    protected final ResourceHandler handler;

    public ResourceServlet(String resourcePath) {
        this.handler = new ResourceHandler(resourcePath);
    }

    @Override
    public void init() throws ServletException {
        this.initAuthEnv();
    }

    private void initAuthEnv() {
        String msg;
        IPRange ipRange;
        String[] items;
        String param;
        String paramRemoteAddressHeader;
        String paramPassword;
        String paramUserName = this.getInitParameter(PARAM_NAME_USERNAME);
        if (!StringUtils.isEmpty(paramUserName)) {
            this.handler.username = paramUserName;
        }
        if (!StringUtils.isEmpty(paramPassword = this.getInitParameter(PARAM_NAME_PASSWORD))) {
            this.handler.password = paramPassword;
        }
        if (!StringUtils.isEmpty(paramRemoteAddressHeader = this.getInitParameter(PARAM_REMOTE_ADDR))) {
            this.handler.remoteAddressHeader = paramRemoteAddressHeader;
        }
        try {
            param = this.getInitParameter(PARAM_NAME_ALLOW);
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                for (String item : items = param.split(",")) {
                    if (item == null || item.length() == 0) continue;
                    ipRange = new IPRange(item);
                    this.handler.allowList.add(ipRange);
                }
            }
        }
        catch (Exception e) {
            msg = "initParameter config error, allow : " + this.getInitParameter(PARAM_NAME_ALLOW);
            LOG.error(msg, e);
        }
        try {
            param = this.getInitParameter(PARAM_NAME_DENY);
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                for (String item : items = param.split(",")) {
                    if (item == null || item.length() == 0) continue;
                    ipRange = new IPRange(item);
                    this.handler.denyList.add(ipRange);
                }
            }
        }
        catch (Exception e) {
            msg = "initParameter config error, deny : " + this.getInitParameter(PARAM_NAME_DENY);
            LOG.error(msg, e);
        }
    }

    public boolean isPermittedRequest(String remoteAddress) {
        return this.handler.isPermittedRequest(remoteAddress);
    }

    protected String getFilePath(String fileName) {
        return this.handler.resourcePath + fileName;
    }

    protected void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
        this.handler.returnResourceFile(fileName, uri, response);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        this.handler.service(request, response, servletPath, new ProcessCallback(){

            @Override
            public String process(String url) {
                return ResourceServlet.this.process(url);
            }
        });
    }

    public boolean ContainsUser(HttpServletRequest request) {
        return this.handler.containsUser(request);
    }

    public boolean checkLoginParam(HttpServletRequest request) {
        return this.handler.checkLoginParam(request);
    }

    public boolean isRequireAuth() {
        return this.handler.isRequireAuth();
    }

    public boolean isPermittedRequest(HttpServletRequest request) {
        return this.handler.isPermittedRequest(request);
    }

    protected String getRemoteAddress(HttpServletRequest request) {
        return this.handler.getRemoteAddress(request);
    }

    protected abstract String process(String var1);

    public static class ResourceHandler {
        protected String username = null;
        protected String password = null;
        protected List<IPRange> allowList = new ArrayList<IPRange>();
        protected List<IPRange> denyList = new ArrayList<IPRange>();
        protected String resourcePath;
        protected String remoteAddressHeader = null;

        public ResourceHandler(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        protected void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
            String filePath = this.getFilePath(fileName);
            if (filePath.endsWith(".html")) {
                response.setContentType("text/html; charset=utf-8");
            }
            if (fileName.endsWith(".jpg")) {
                byte[] bytes = Utils.readByteArrayFromResource(filePath);
                if (bytes != null) {
                    response.getOutputStream().write(bytes);
                }
                return;
            }
            String text = Utils.readFromResource(filePath);
            if (text == null) {
                return;
            }
            if (fileName.endsWith(".css")) {
                response.setContentType("text/css;charset=utf-8");
            } else if (fileName.endsWith(".js")) {
                response.setContentType("text/javascript;charset=utf-8");
            }
            response.getWriter().write(text);
        }

        protected String getFilePath(String fileName) {
            return this.resourcePath + fileName;
        }

        public boolean checkLoginParam(HttpServletRequest request) {
            String usernameParam = request.getParameter(ResourceServlet.PARAM_NAME_USERNAME);
            String passwordParam = request.getParameter(ResourceServlet.PARAM_NAME_PASSWORD);
            if (null == this.username || null == this.password) {
                return false;
            }
            return this.username.equals(usernameParam) && this.password.equals(passwordParam);
        }

        protected String getRemoteAddress(HttpServletRequest request) {
            String remoteAddress = null;
            if (this.remoteAddressHeader != null) {
                remoteAddress = request.getHeader(this.remoteAddressHeader);
            }
            if (remoteAddress == null) {
                remoteAddress = request.getRemoteAddr();
            }
            return remoteAddress;
        }

        public boolean containsUser(HttpServletRequest request) {
            HttpSession session = request.getSession(false);
            return session != null && session.getAttribute(ResourceServlet.SESSION_USER_KEY) != null;
        }

        public boolean isRequireAuth() {
            return this.username != null;
        }

        public boolean isPermittedRequest(HttpServletRequest request) {
            String remoteAddress = this.getRemoteAddress(request);
            return this.isPermittedRequest(remoteAddress);
        }

        public boolean isPermittedRequest(String remoteAddress) {
            boolean ipV6;
            boolean bl = ipV6 = remoteAddress != null && remoteAddress.indexOf(58) != -1;
            if (ipV6) {
                return "0:0:0:0:0:0:0:1".equals(remoteAddress) || this.denyList.size() == 0 && this.allowList.size() == 0;
            }
            IPAddress ipAddress = new IPAddress(remoteAddress);
            for (IPRange range : this.denyList) {
                if (!range.isIPAddressInRange(ipAddress)) continue;
                return false;
            }
            if (this.allowList.size() > 0) {
                for (IPRange range : this.allowList) {
                    if (!range.isIPAddressInRange(ipAddress)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public void service(HttpServletRequest request, HttpServletResponse response, String servletPath, ProcessCallback processCallback) throws ServletException, IOException {
            String contextPath = request.getContextPath();
            String requestURI = request.getRequestURI();
            response.setCharacterEncoding("utf-8");
            if (contextPath == null) {
                contextPath = "";
            }
            String uri = contextPath + servletPath;
            String path = requestURI.substring(contextPath.length() + servletPath.length());
            if (!this.isPermittedRequest(request)) {
                path = "/nopermit.html";
                this.returnResourceFile(path, uri, response);
                return;
            }
            if ("/submitLogin".equals(path)) {
                String usernameParam = request.getParameter(ResourceServlet.PARAM_NAME_USERNAME);
                String passwordParam = request.getParameter(ResourceServlet.PARAM_NAME_PASSWORD);
                if (this.username.equals(usernameParam) && this.password.equals(passwordParam)) {
                    request.getSession().setAttribute(ResourceServlet.SESSION_USER_KEY, this.username);
                    response.getWriter().print("success");
                } else {
                    response.getWriter().print("error");
                }
                return;
            }
            if (!(!this.isRequireAuth() || this.containsUser(request) || this.checkLoginParam(request) || "/login.html".equals(path) || path.startsWith("/css") || path.startsWith("/js") || path.startsWith("/img"))) {
                if (contextPath.equals("") || contextPath.equals("/")) {
                    response.sendRedirect("/druid/login.html");
                } else if ("".equals(path)) {
                    response.sendRedirect("druid/login.html");
                } else {
                    response.sendRedirect("login.html");
                }
                return;
            }
            if ("".equals(path) || "/".equals(path)) {
                this.returnResourceFile("/index.html", uri, response);
                return;
            }
            if (path.contains(".json")) {
                String fullUrl = path;
                if (request.getQueryString() != null && request.getQueryString().length() > 0) {
                    fullUrl = fullUrl + "?" + request.getQueryString();
                }
                response.getWriter().print(processCallback.process(fullUrl));
                return;
            }
            this.returnResourceFile(path, uri, response);
        }
    }

    public static interface ProcessCallback {
        public String process(String var1);
    }
}

