/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.spring;

import com.alibaba.druid.support.spring.DruidLobCreator;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.support.lob.AbstractLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;

public class DruidLobHandler
extends AbstractLobHandler {
    @Override
    public byte[] getBlobAsBytes(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        if (blob == null) {
            return null;
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    @Override
    public InputStream getBlobAsBinaryStream(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    @Override
    public String getClobAsString(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        if (clob == null) {
            return null;
        }
        return clob.getSubString(1L, (int)clob.length());
    }

    @Override
    public InputStream getClobAsAsciiStream(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        if (clob == null) {
            return null;
        }
        return clob.getAsciiStream();
    }

    @Override
    public Reader getClobAsCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        if (clob == null) {
            return null;
        }
        return clob.getCharacterStream();
    }

    @Override
    public LobCreator getLobCreator() {
        return new DruidLobCreator();
    }
}

