/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.spring;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import java.io.InputStream;
import org.springframework.web.socket.sockjs.frame.AbstractSockJsMessageCodec;

public class FastjsonSockJsMessageCodec
extends AbstractSockJsMessageCodec {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public String[] decode(String content) {
        return JSON.parseObject(content, String[].class);
    }

    public String[] decodeInputStream(InputStream content) {
        return (String[])JSON.parseObject(content, String[].class, new JSONReader.Feature[0]);
    }

    protected char[] applyJsonQuoting(String content) {
        return content.toCharArray();
    }

    public String encode(String ... messages) {
        JSONWriter jsonWriter = JSONWriter.of(this.fastJsonConfig.getWriterFeatures());
        if (jsonWriter.utf8) {
            jsonWriter.writeRaw(new byte[]{97});
        } else {
            jsonWriter.writeRaw(new char[]{'a'});
        }
        jsonWriter.startArray();
        for (int i2 = 0; i2 < messages.length; ++i2) {
            if (i2 != 0) {
                jsonWriter.writeComma();
            }
            String message = messages[i2];
            jsonWriter.writeString(message);
        }
        jsonWriter.endArray();
        return jsonWriter.toString();
    }
}

