/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.spring.messaging;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import java.nio.charset.StandardCharsets;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class MappingFastJsonMessageConverter
extends AbstractMessageConverter {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public MappingFastJsonMessageConverter() {
        super(new MimeType("application", "json", StandardCharsets.UTF_8));
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return this.supports(targetClass);
    }

    @Override
    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        return this.supports(payload.getClass());
    }

    @Override
    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object payload = message.getPayload();
        Object obj = null;
        if (payload instanceof byte[]) {
            obj = JSON.parseObject((byte[])payload, targetClass, this.fastJsonConfig.getFeatures());
        } else if (payload instanceof String) {
            obj = JSON.parseObject((String)payload, targetClass, this.fastJsonConfig.getFeatures());
        }
        return obj;
    }

    @Override
    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        Object obj = byte[].class == this.getSerializedPayloadClass() ? (payload instanceof String && JSON.isValid((String)payload) ? (Object)((String)payload).getBytes(this.fastJsonConfig.getCharset()) : (Object)JSON.toJSONBytes(payload, this.fastJsonConfig.getSerializeFilters(), this.fastJsonConfig.getSerializerFeatures())) : (payload instanceof String && JSON.isValid((String)payload) ? payload : JSON.toJSONString(payload, this.fastJsonConfig.getSerializeFilters(), this.fastJsonConfig.getSerializerFeatures()));
        return obj;
    }
}

