/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSingleIndex;
import com.alibaba.fastjson2.JSONPathTypedMultiNames;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.util.Arrays;

public class JSONPathTypedMultiNamesPrefixIndex1
extends JSONPathTypedMultiNames {
    final int index;

    JSONPathTypedMultiNamesPrefixIndex1(JSONPath[] paths, JSONPathSingleIndex prefix, JSONPath[] namePaths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, long features) {
        super(paths, prefix, namePaths, types, formats, pathFeatures, zoneId, features);
        this.index = prefix.index;
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        if (jsonReader.nextIfNull()) {
            return new Object[this.paths.length];
        }
        if (!jsonReader.nextIfMatch('[')) {
            throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
        }
        for (int i2 = 0; i2 < this.index; ++i2) {
            if (jsonReader.nextIfMatch(']')) {
                return new Object[this.paths.length];
            }
            if (jsonReader.isEnd()) {
                throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
            }
            jsonReader.skipValue();
        }
        if (jsonReader.nextIfNull()) {
            return new Object[this.paths.length];
        }
        if (jsonReader.nextIfMatch(']')) {
            return new Object[this.paths.length];
        }
        if (!jsonReader.nextIfObjectStart()) {
            throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
        }
        Object[] values = new Object[this.paths.length];
        while (!jsonReader.nextIfObjectEnd()) {
            Object fieldValue;
            long nameHashCode = jsonReader.readFieldNameHashCode();
            int m = Arrays.binarySearch(this.hashCodes, nameHashCode);
            if (m < 0) {
                jsonReader.skipValue();
                continue;
            }
            short index = this.mapping[m];
            FieldReader fieldReader = this.fieldReaders[index];
            try {
                fieldValue = fieldReader.readFieldValue(jsonReader);
            }
            catch (Exception e) {
                if (!this.ignoreError(index)) {
                    throw e;
                }
                fieldValue = null;
            }
            values[index] = fieldValue;
        }
        return values;
    }
}

