/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONSchemaValidException;
import com.alibaba.fastjson2.annotation.JSONCreator;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.AllOf;
import com.alibaba.fastjson2.schema.Any;
import com.alibaba.fastjson2.schema.AnyOf;
import com.alibaba.fastjson2.schema.ArraySchema;
import com.alibaba.fastjson2.schema.BooleanSchema;
import com.alibaba.fastjson2.schema.EnumSchema;
import com.alibaba.fastjson2.schema.IntegerSchema;
import com.alibaba.fastjson2.schema.Not;
import com.alibaba.fastjson2.schema.NullSchema;
import com.alibaba.fastjson2.schema.NumberSchema;
import com.alibaba.fastjson2.schema.ObjectSchema;
import com.alibaba.fastjson2.schema.OneOf;
import com.alibaba.fastjson2.schema.StringSchema;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class JSONSchema {
    static final Map<String, JSONSchema> CACHE = new ConcurrentHashMap<String, JSONSchema>();
    final String title;
    final String description;
    static final JSONReader.Context CONTEXT = JSONFactory.createReadContext();
    static final ValidateResult SUCCESS = new ValidateResult(true, "success", new Object[0]);
    static final ValidateResult FAIL_INPUT_NULL = new ValidateResult(false, "input null", new Object[0]);
    static final ValidateResult FAIL_ANY_OF = new ValidateResult(false, "anyOf fail", new Object[0]);
    static final ValidateResult FAIL_ONE_OF = new ValidateResult(false, "oneOf fail", new Object[0]);
    static final ValidateResult FAIL_NOT = new ValidateResult(false, "not fail", new Object[0]);
    static final ValidateResult FAIL_TYPE_NOT_MATCH = new ValidateResult(false, "type not match", new Object[0]);
    static final ValidateResult FAIL_PROPERTY_NAME = new ValidateResult(false, "propertyName not match", new Object[0]);
    static final ValidateResult CONTAINS_NOT_MATCH = new ValidateResult(false, "contains not match", new Object[0]);
    static final ValidateResult UNIQUE_ITEMS_NOT_MATCH = new ValidateResult(false, "uniqueItems not match", new Object[0]);
    static final ValidateResult REQUIRED_NOT_MATCH = new ValidateResult(false, "required", new Object[0]);

    JSONSchema(JSONObject input) {
        this.title = input.getString("title");
        this.description = input.getString("description");
    }

    JSONSchema(String title, String description) {
        this.title = title;
        this.description = description;
    }

    public static JSONSchema of(JSONObject input, Class objectClass) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        if (objectClass == null || objectClass == Object.class) {
            return JSONSchema.of(input);
        }
        if (objectClass == Byte.TYPE || objectClass == Short.TYPE || objectClass == Integer.TYPE || objectClass == Long.TYPE || objectClass == Byte.class || objectClass == Short.class || objectClass == Integer.class || objectClass == Long.class || objectClass == BigInteger.class || objectClass == AtomicInteger.class || objectClass == AtomicLong.class) {
            if (input.containsKey("AnyOf") || input.containsKey("anyOf")) {
                return JSONSchema.anyOf(input, objectClass);
            }
            if (input.containsKey("oneOf")) {
                return JSONSchema.oneOf(input, objectClass);
            }
            if (input.containsKey("not")) {
                return JSONSchema.ofNot(input, objectClass);
            }
            return new IntegerSchema(input);
        }
        if (objectClass == BigDecimal.class || objectClass == Float.TYPE || objectClass == Double.TYPE || objectClass == Float.class || objectClass == Double.class || objectClass == Number.class) {
            if (input.containsKey("AnyOf") || input.containsKey("anyOf")) {
                return JSONSchema.anyOf(input, objectClass);
            }
            if (input.containsKey("oneOf")) {
                return JSONSchema.oneOf(input, objectClass);
            }
            if (input.containsKey("not")) {
                return JSONSchema.ofNot(input, objectClass);
            }
            return new NumberSchema(input);
        }
        if (objectClass == Boolean.TYPE || objectClass == Boolean.class) {
            return new BooleanSchema(input);
        }
        if (objectClass == String.class) {
            return new StringSchema(input);
        }
        if (Collection.class.isAssignableFrom(objectClass)) {
            return new ArraySchema(input, null);
        }
        if (objectClass.isArray()) {
            return new ArraySchema(input, null);
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            return new ObjectSchema(input, null);
        }
        return new ObjectSchema(input, null);
    }

    static Not ofNot(JSONObject input, Class objectClass) {
        Object type;
        Object not = input.get("not");
        if (not instanceof Boolean) {
            return new Not(null, null, (Boolean)not);
        }
        JSONObject object = (JSONObject)not;
        if (object == null || object.isEmpty()) {
            return new Not(null, new Type[]{Type.Any}, null);
        }
        if (object.size() == 1 && (type = object.get("type")) instanceof JSONArray) {
            JSONArray array = (JSONArray)type;
            Type[] types = new Type[array.size()];
            for (int i2 = 0; i2 < array.size(); ++i2) {
                types[i2] = array.getObject(i2, Type.class, new JSONReader.Feature[0]);
            }
            return new Not(null, types, null);
        }
        JSONSchema schema = JSONSchema.of(object, objectClass);
        return new Not(schema, null, null);
    }

    public static JSONSchema parseSchema(String schema) {
        if ("true".equals(schema)) {
            return Any.INSTANCE;
        }
        if ("false".equals(schema)) {
            return Any.NOT_ANY;
        }
        try (JSONReader reader = JSONReader.of(schema);){
            ObjectReader objectReader = reader.getObjectReader((java.lang.reflect.Type)((Object)Object.class));
            JSONObject object = (JSONObject)objectReader.readObject(reader, null, null, 0L);
            JSONSchema jSONSchema = JSONSchema.of(object);
            return jSONSchema;
        }
    }

    @JSONCreator
    public static JSONSchema of(JSONObject input) {
        return JSONSchema.of(input, (JSONSchema)null);
    }

    @JSONCreator
    public static JSONSchema of(JSONObject input, JSONSchema parent) {
        Type type = Type.of(input.getString("type"));
        if (type == null) {
            Object propertyType;
            Object[] enums = input.getObject("enum", Object[].class, new JSONReader.Feature[0]);
            if (enums != null) {
                boolean nonString = false;
                for (int i2 = 0; i2 < enums.length; ++i2) {
                    if (enums[i2] instanceof String) continue;
                    nonString = true;
                    break;
                }
                if (!nonString) {
                    return new StringSchema(input);
                }
                return new EnumSchema(enums);
            }
            Object constValue = input.get("const");
            if (constValue instanceof String) {
                return new StringSchema(input);
            }
            if (constValue instanceof Integer || constValue instanceof Long) {
                return new IntegerSchema(input);
            }
            if (input.size() == 1) {
                String ref = input.getString("$ref");
                if (ref != null && !ref.isEmpty()) {
                    if ("http://json-schema.org/draft-04/schema#".equals(ref)) {
                        URL draf4Resource;
                        JSONSchema origin;
                        JSONSchema schema = CACHE.get(ref);
                        if (schema == null && (origin = CACHE.putIfAbsent(ref, schema = JSONSchema.of(JSON.parseObject(draf4Resource = JSONSchema.class.getClassLoader().getResource("schema/draft-04.json")), (JSONSchema)null))) != null) {
                            schema = origin;
                        }
                        return schema;
                    }
                    if ("#".equals(ref)) {
                        return parent;
                    }
                    Map<String, JSONSchema> definitions = null;
                    Map<String, JSONSchema> defs = null;
                    Map<String, JSONSchema> properties = null;
                    if (parent instanceof ObjectSchema) {
                        ObjectSchema objectSchema = (ObjectSchema)parent;
                        definitions = objectSchema.definitions;
                        defs = objectSchema.defs;
                        properties = objectSchema.properties;
                    } else if (parent instanceof ArraySchema) {
                        definitions = ((ArraySchema)parent).definitions;
                        defs = ((ArraySchema)parent).defs;
                    }
                    if (definitions != null && ref.startsWith("#/definitions/")) {
                        int PREFIX_LEN = 14;
                        String refName = ref.substring(14);
                        JSONSchema refSchema = definitions.get(refName);
                        return refSchema;
                    }
                    if (defs != null && ref.startsWith("#/$defs/")) {
                        int PREFIX_LEN = 8;
                        String refName = ref.substring(8);
                        JSONSchema refSchema = defs.get(refName = URLDecoder.decode(refName));
                        if (refSchema == null) {
                            refSchema = Any.NOT_ANY;
                        }
                        return refSchema;
                    }
                    if (properties != null && ref.startsWith("#/properties/")) {
                        int PREFIX_LEN = 13;
                        String refName = ref.substring(13);
                        JSONSchema refSchema = properties.get(refName);
                        return refSchema;
                    }
                    if (ref.startsWith("#/prefixItems/") && parent instanceof ArraySchema) {
                        int PREFIX_LEN = 14;
                        int index = Integer.parseInt(ref.substring(14));
                        JSONSchema refSchema = ((ArraySchema)parent).prefixItems[index];
                        return refSchema;
                    }
                }
                Object exclusiveMaximum = input.get("exclusiveMaximum");
                Object exclusiveMinimum = input.get("exclusiveMinimum");
                if (exclusiveMaximum instanceof Integer || exclusiveMinimum instanceof Integer || exclusiveMaximum instanceof Long || exclusiveMinimum instanceof Long) {
                    return new IntegerSchema(input);
                }
                if (exclusiveMaximum instanceof Number || exclusiveMinimum instanceof Number) {
                    return new NumberSchema(input);
                }
            }
            if (input.containsKey("properties") || input.containsKey("dependentSchemas") || input.containsKey("if") || input.containsKey("required") || input.containsKey("patternProperties") || input.containsKey("additionalProperties") || input.containsKey("minProperties") || input.containsKey("maxProperties") || input.containsKey("propertyNames") || input.containsKey("$ref")) {
                return new ObjectSchema(input, parent);
            }
            if (input.containsKey("maxItems") || input.containsKey("minItems") || input.containsKey("additionalItems") || input.containsKey("items") || input.containsKey("prefixItems") || input.containsKey("uniqueItems") || input.containsKey("maxContains") || input.containsKey("minContains")) {
                return new ArraySchema(input, parent);
            }
            if (input.containsKey("pattern") || input.containsKey("format") || input.containsKey("minLength") || input.containsKey("maxLength")) {
                return new StringSchema(input);
            }
            boolean allOf = input.containsKey("allOf");
            boolean anyOf = input.containsKey("anyOf");
            boolean oneOf = input.containsKey("oneOf");
            if (allOf || anyOf || oneOf) {
                int count = (allOf ? 1 : 0) + (anyOf ? 1 : 0) + (oneOf ? 1 : 0);
                if (count == 1) {
                    if (allOf) {
                        return new AllOf(input, parent);
                    }
                    if (anyOf) {
                        return new AnyOf(input, parent);
                    }
                    if (oneOf) {
                        return new OneOf(input, parent);
                    }
                }
                JSONSchema[] items = new JSONSchema[count];
                int index = 0;
                if (allOf) {
                    items[index++] = new AllOf(input, parent);
                }
                if (anyOf) {
                    items[index++] = new AnyOf(input, parent);
                }
                if (oneOf) {
                    items[index++] = new OneOf(input, parent);
                }
                return new AllOf(items);
            }
            if (input.containsKey("not")) {
                return JSONSchema.ofNot(input, null);
            }
            if (input.get("maximum") instanceof Number || input.get("minimum") instanceof Number || input.containsKey("multipleOf")) {
                return new NumberSchema(input);
            }
            if (input.isEmpty()) {
                return Any.INSTANCE;
            }
            if (input.size() == 1 && (propertyType = input.get("type")) instanceof JSONArray) {
                JSONArray array = (JSONArray)propertyType;
                JSONSchema[] typeSchemas = new JSONSchema[array.size()];
                block19: for (int i3 = 0; i3 < array.size(); ++i3) {
                    Type itemType = Type.of(array.getString(i3));
                    switch (itemType) {
                        case String: {
                            typeSchemas[i3] = new StringSchema(JSONObject.of("type", "string"));
                            continue block19;
                        }
                        case Integer: {
                            typeSchemas[i3] = new IntegerSchema(JSONObject.of("type", "integer"));
                            continue block19;
                        }
                        case Number: {
                            typeSchemas[i3] = new NumberSchema(JSONObject.of("type", "number"));
                            continue block19;
                        }
                        case Boolean: {
                            typeSchemas[i3] = new BooleanSchema(JSONObject.of("type", "boolean"));
                            continue block19;
                        }
                        case Null: {
                            typeSchemas[i3] = new NullSchema(JSONObject.of("type", "null"));
                            continue block19;
                        }
                        case Object: {
                            typeSchemas[i3] = new ObjectSchema(JSONObject.of("type", "object"));
                            continue block19;
                        }
                        case Array: {
                            typeSchemas[i3] = new ArraySchema(JSONObject.of("type", "array"), null);
                            continue block19;
                        }
                        default: {
                            throw new JSONSchemaValidException("not support type : " + (Object)((Object)itemType));
                        }
                    }
                }
                return new AnyOf(typeSchemas);
            }
            if (input.getString("type") == null) {
                throw new JSONSchemaValidException("type required");
            }
            throw new JSONSchemaValidException("not support type : " + input.getString("type"));
        }
        switch (type) {
            case String: {
                return new StringSchema(input);
            }
            case Integer: {
                return new IntegerSchema(input);
            }
            case Number: {
                return new NumberSchema(input);
            }
            case Boolean: {
                return new BooleanSchema(input);
            }
            case Null: {
                return new NullSchema(input);
            }
            case Object: {
                return new ObjectSchema(input, parent);
            }
            case Array: {
                return new ArraySchema(input, parent);
            }
        }
        throw new JSONSchemaValidException("not support type : " + (Object)((Object)type));
    }

    static AnyOf anyOf(JSONObject input, Class type) {
        JSONArray array = input.getJSONArray("anyOf");
        if (array == null || array.isEmpty()) {
            return null;
        }
        JSONSchema[] items = new JSONSchema[array.size()];
        for (int i2 = 0; i2 < items.length; ++i2) {
            items[i2] = JSONSchema.of(array.getJSONObject(i2), type);
        }
        AnyOf anyOf = new AnyOf(items);
        return anyOf;
    }

    static AnyOf anyOf(JSONArray array, Class type) {
        if (array == null || array.isEmpty()) {
            return null;
        }
        JSONSchema[] items = new JSONSchema[array.size()];
        for (int i2 = 0; i2 < items.length; ++i2) {
            items[i2] = JSONSchema.of(array.getJSONObject(i2), type);
        }
        AnyOf anyOf = new AnyOf(items);
        return anyOf;
    }

    static AllOf allOf(JSONObject input, Class type) {
        JSONArray array = input.getJSONArray("allOf");
        if (array == null || array.isEmpty()) {
            return null;
        }
        JSONSchema[] items = new JSONSchema[array.size()];
        for (int i2 = 0; i2 < items.length; ++i2) {
            items[i2] = JSONSchema.of(array.getJSONObject(i2), type);
        }
        return new AllOf(items);
    }

    static OneOf oneOf(JSONObject input, Class type) {
        JSONArray array = input.getJSONArray("oneOf");
        if (array == null || array.isEmpty()) {
            return null;
        }
        JSONSchema[] items = new JSONSchema[array.size()];
        for (int i2 = 0; i2 < items.length; ++i2) {
            items[i2] = JSONSchema.of(array.getJSONObject(i2), type);
        }
        return new OneOf(items);
    }

    static OneOf oneOf(JSONArray array, Class type) {
        if (array == null || array.isEmpty()) {
            return null;
        }
        JSONSchema[] items = new JSONSchema[array.size()];
        for (int i2 = 0; i2 < items.length; ++i2) {
            items[i2] = JSONSchema.of(array.getJSONObject(i2), type);
        }
        return new OneOf(items);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract Type getType();

    public abstract ValidateResult validate(Object var1);

    public boolean isValid(Object value) {
        return this.validate(value).isSuccess();
    }

    public boolean isValid(long value) {
        return this.validate(value).isSuccess();
    }

    public boolean isValid(double value) {
        return this.validate(value).isSuccess();
    }

    public boolean isValid(Double value) {
        return this.validate(value).isSuccess();
    }

    public boolean isValid(float value) {
        return this.validate((double)value).isSuccess();
    }

    public boolean isValid(Float value) {
        return this.validate(value).isSuccess();
    }

    public boolean isValid(Integer value) {
        return this.validate(value).isSuccess();
    }

    public boolean isValid(Long value) {
        return this.validate(value).isSuccess();
    }

    public ValidateResult validate(long value) {
        return this.validate((Object)value);
    }

    public ValidateResult validate(double value) {
        return this.validate((Object)value);
    }

    public ValidateResult validate(Float value) {
        return this.validate((Object)value);
    }

    public ValidateResult validate(Double value) {
        return this.validate((Object)value);
    }

    public ValidateResult validate(Integer value) {
        return this.validate((Object)value);
    }

    public ValidateResult validate(Long value) {
        return this.validate((Object)value);
    }

    public void assertValidate(Object value) {
        ValidateResult result = this.validate(value);
        if (result.isSuccess()) {
            return;
        }
        throw new JSONSchemaValidException(result.getMessage());
    }

    public void assertValidate(Integer value) {
        ValidateResult result = this.validate(value);
        if (result.isSuccess()) {
            return;
        }
        throw new JSONSchemaValidException(result.getMessage());
    }

    public void assertValidate(Long value) {
        ValidateResult result = this.validate(value);
        if (result.isSuccess()) {
            return;
        }
        throw new JSONSchemaValidException(result.getMessage());
    }

    public void assertValidate(Double value) {
        ValidateResult result = this.validate(value);
        if (result.isSuccess()) {
            return;
        }
        throw new JSONSchemaValidException(result.getMessage());
    }

    public void assertValidate(Float value) {
        ValidateResult result = this.validate(value);
        if (result.isSuccess()) {
            return;
        }
        throw new JSONSchemaValidException(result.getMessage());
    }

    public void assertValidate(long value) {
        ValidateResult result = this.validate(value);
        if (result.isSuccess()) {
            return;
        }
        throw new JSONSchemaValidException(result.getMessage());
    }

    public void assertValidate(double value) {
        ValidateResult result = this.validate(value);
        if (result.isSuccess()) {
            return;
        }
        throw new JSONSchemaValidException(result.getMessage());
    }

    public static enum Type {
        Null,
        Boolean,
        Object,
        Array,
        Number,
        String,
        Integer,
        Enum,
        Const,
        OneOf,
        AllOf,
        AnyOf,
        Any;


        public static Type of(String typeStr) {
            if (typeStr == null) {
                return null;
            }
            switch (typeStr) {
                case "Null": 
                case "null": {
                    return Null;
                }
                case "String": 
                case "string": {
                    return String;
                }
                case "Integer": 
                case "integer": {
                    return Integer;
                }
                case "Number": 
                case "number": {
                    return Number;
                }
                case "Boolean": 
                case "boolean": {
                    return Boolean;
                }
                case "Object": 
                case "object": {
                    return Object;
                }
                case "Array": 
                case "array": {
                    return Array;
                }
            }
            return null;
        }
    }
}

