/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.airlift;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.IOUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;

public class SliceValueConsumer
implements ValueConsumer {
    public Slice slice;

    @Override
    public void accept(byte[] bytes, int off, int len) {
        this.slice = Slices.wrappedBuffer((byte[])bytes, (int)off, (int)len);
    }

    @Override
    public void acceptNull() {
        this.slice = null;
    }

    @Override
    public void accept(int value) {
        int size = value < 0 ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
        byte[] bytes = new byte[size];
        IOUtils.getChars(value, bytes.length, bytes);
        this.slice = Slices.wrappedBuffer((byte[])bytes);
    }

    @Override
    public void accept(boolean val2) {
        byte[] byArray;
        if (val2) {
            byte[] byArray2 = new byte[4];
            byArray2[0] = 116;
            byArray2[1] = 114;
            byArray2[2] = 117;
            byArray = byArray2;
            byArray2[3] = 101;
        } else {
            byte[] byArray3 = new byte[5];
            byArray3[0] = 102;
            byArray3[1] = 97;
            byArray3[2] = 108;
            byArray3[3] = 115;
            byArray = byArray3;
            byArray3[4] = 101;
        }
        byte[] bytes = byArray;
        this.slice = Slices.wrappedBuffer((byte[])bytes);
    }

    @Override
    public void accept(long value) {
        int size = value < 0L ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
        byte[] bytes = new byte[size];
        IOUtils.getChars(value, bytes.length, bytes);
        this.slice = Slices.wrappedBuffer((byte[])bytes);
    }

    @Override
    public void accept(Number val2) {
        if (val2 == null) {
            this.slice = null;
            return;
        }
        if (val2 instanceof Long) {
            long value = val2.longValue();
            int size = value < 0L ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
            byte[] bytes = new byte[size];
            IOUtils.getChars(value, bytes.length, bytes);
            this.slice = Slices.wrappedBuffer((byte[])bytes);
            return;
        }
        if (val2 instanceof Integer || val2 instanceof Short || val2 instanceof Byte) {
            int value = val2.intValue();
            int size = value < 0 ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
            byte[] bytes = new byte[size];
            IOUtils.getChars(value, bytes.length, bytes);
            this.slice = Slices.wrappedBuffer((byte[])bytes);
            return;
        }
        String str = val2.toString();
        this.slice = Slices.utf8Slice((String)str);
    }

    @Override
    public void accept(String val2) {
        this.slice = Slices.utf8Slice((String)val2);
    }

    @Override
    public void accept(Map object) {
        if (object.isEmpty()) {
            this.slice = Slices.wrappedBuffer((byte[])new byte[]{123, 125});
            return;
        }
        try (JSONWriter jsonWriter = JSONWriter.ofUTF8();){
            jsonWriter.write(object);
            byte[] bytes = jsonWriter.getBytes();
            this.slice = Slices.wrappedBuffer((byte[])bytes);
        }
    }

    @Override
    public void accept(List array) {
        if (array.isEmpty()) {
            this.slice = Slices.wrappedBuffer((byte[])new byte[]{91, 93});
            return;
        }
        try (JSONWriter jsonWriter = JSONWriter.ofUTF8();){
            jsonWriter.write(array);
            byte[] bytes = jsonWriter.getBytes();
            this.slice = Slices.wrappedBuffer((byte[])bytes);
        }
    }
}

